/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JToggleButton;
import martin.tempest.core.TSDRLibrary;
import martin.tempest.gui.OnTSDRParamChangedCallback;

public class ParametersToggleButton
extends JToggleButton {
    private static final long serialVersionUID = -7115465123485780108L;
    private final TSDRLibrary.PARAM param;
    private OnTSDRParamChangedCallback callback;
    private final String prefname;
    private final Preferences prefs;

    private void notifyCallback(boolean bl) {
        if (this.callback != null) {
            this.callback.onSetParam(this.param, bl ? 1L : 0L);
        }
        if (this.prefs != null) {
            this.prefs.putBoolean(this.prefname, bl);
        }
    }

    public ParametersToggleButton(TSDRLibrary.PARAM pARAM, String string, Preferences preferences, boolean bl) {
        super(string, preferences != null ? preferences.getBoolean("PARAM" + (Object)((Object)pARAM), bl) : bl);
        this.param = pARAM;
        this.prefs = preferences;
        this.prefname = "PARAM" + (Object)((Object)pARAM);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ParametersToggleButton.this.notifyCallback(ParametersToggleButton.this.isSelected());
            }
        });
    }

    public void setParaChangeCallback(OnTSDRParamChangedCallback onTSDRParamChangedCallback) {
        this.callback = onTSDRParamChangedCallback;
        this.notifyCallback(this.isSelected());
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        this.notifyCallback(this.isSelected());
        super.setBounds(n, n2, n3, n4);
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        this.notifyCallback(bl);
    }
}

