/*
 * Decompiled with CFR 0.152.
 */
package martin.tempest.gui.scale;

import java.awt.Color;
import java.awt.Graphics;

public class LogScale {
    private static final double MAX_SPAN_DB = 500.0;
    private static final double[] POSSIBLE_SCALE_VALUES_DB = new double[]{50.0, 20.0, 10.0, 5.0, 2.0, 1.0, 0.5, 0.2, 0.1};
    private final double font_spacing_coeff;
    private static final double DB_MULTIPLIER = 10.0;
    private final Color default_txt_colour_background;
    private double lowest_db = -21.0;
    private double highest_db = 1.0;
    private double span_db = this.highest_db - this.lowest_db;
    private double lowest_val = this.dbtoval(this.lowest_db);
    private double highest_val = this.dbtoval(this.highest_db);
    private int nwidth = 0;
    private int nheight = 0;

    public LogScale(Color color, double d) {
        this.font_spacing_coeff = d;
        this.default_txt_colour_background = color;
    }

    public LogScale(Color color, double d, double d2, double d3) {
        this.font_spacing_coeff = d;
        this.default_txt_colour_background = color;
        this.setLowestHighestDb(d2, d3);
    }

    public void setLowestHighestDb(double d, double d2) {
        this.lowest_db = d;
        this.highest_db = d2;
        this.span_db = d2 - d;
        this.lowest_val = this.dbtoval(d);
        this.highest_val = this.dbtoval(d2);
    }

    public double getLowestValue() {
        return this.lowest_val;
    }

    public double getHighestValue() {
        return this.highest_val;
    }

    public double getLowestDb() {
        return this.lowest_db;
    }

    public double getHighestDb() {
        return this.highest_db;
    }

    private static final int getAccuracy(double d) {
        if (Math.abs((double)((int)d) - d) < 1.0E-10) {
            return 0;
        }
        int n = 0;
        int n2 = 1;
        do {
            int n3;
            n2 *= 10;
            if (!((double)n3 < 1.0E9)) break;
            ++n;
        } while (!(Math.abs((double)((int)(d * (double)n2)) / (double)n2 - d) < 1.0E-10));
        return n;
    }

    public void setDimentions(int n, int n2) {
        this.nwidth = n;
        this.nheight = n2;
    }

    public double valtodb(double d) {
        return 10.0 * Math.log10(d);
    }

    public double dbtoval(double d) {
        return Math.pow(10.0, d / 10.0);
    }

    public int valtopx(double d) {
        if (d <= this.lowest_val) {
            return this.nheight;
        }
        if (d >= this.highest_val) {
            return 0;
        }
        return (int)((double)this.nheight - (this.valtodb(d) - this.lowest_db) * (double)this.nheight / this.span_db);
    }

    public int dbtopx(double d) {
        int n = (int)((double)this.nheight - (d - this.lowest_db) * (double)this.nheight / this.span_db);
        return n < 0 ? 0 : (n >= this.nheight ? this.nheight - 1 : n);
    }

    public double pxtoval(int n) {
        double d = (double)(this.nheight - n) * this.span_db / (double)this.nheight + this.lowest_db;
        return this.dbtoval(d);
    }

    public void setLowestHighestValue(double d, double d2) {
        double d3 = this.valtodb(d);
        double d4 = this.valtodb(d2);
        double d5 = d4 - d3;
        if (Double.isInfinite(d5) || Double.isNaN(d5) || d5 > 500.0) {
            return;
        }
        this.lowest_val = d;
        this.highest_val = d2;
        this.lowest_db = d3;
        this.highest_db = d4;
        this.span_db = d5;
    }

    public boolean valuesValid() {
        return !Double.isInfinite(this.span_db) && !Double.isNaN(this.span_db);
    }

    public void paintScale(Graphics graphics) {
        if (!this.valuesValid()) {
            return;
        }
        int n = graphics.getFont().getSize() / 2;
        int n2 = this.nwidth / 200;
        int n3 = this.nwidth / 400;
        int n4 = n2 + 2 * n3;
        double d = this.font_spacing_coeff * this.span_db / (double)n;
        double d2 = POSSIBLE_SCALE_VALUES_DB[POSSIBLE_SCALE_VALUES_DB.length - 1];
        for (double d3 : POSSIBLE_SCALE_VALUES_DB) {
            if (!(d3 < d)) continue;
            d2 = d3;
            break;
        }
        double d4 = d2 / 5.0;
        double d5 = (double)((int)(this.highest_db / d2)) * d2;
        double d6 = (double)((int)(this.highest_db / d4)) * d4;
        graphics.setColor(this.default_txt_colour_background);
        for (double d7 = d6; d7 >= this.lowest_db; d7 -= d4) {
            if (!(d7 >= this.lowest_db) || !(d7 <= this.highest_db)) continue;
            int n5 = this.dbtopx(d7);
            graphics.drawLine(0, n5, n3, n5);
        }
        int n6 = LogScale.getAccuracy(d2);
        String string = String.format("+%%.%df", n6);
        String string2 = String.format("%%.%df", n6);
        boolean bl = true;
        for (double d8 = d5; d8 >= this.lowest_db; d8 -= d2) {
            if (!(d8 >= this.lowest_db) || !(d8 <= this.highest_db)) continue;
            int n7 = this.dbtopx(d8);
            if (bl) {
                bl = false;
                graphics.drawString((d8 > 0.0 ? String.format(string, d8) : String.format(string2, d8)) + " dB", n4, n7 + n);
            } else {
                graphics.drawString(d8 > 0.0 ? String.format(string, d8) : String.format(string2, d8), n4, n7 + n);
            }
            graphics.drawLine(0, n7, n2, n7);
        }
    }
}

