
if (DEFINED ENV{ROCM_PATH})
  set(ROCM_PATH "$ENV{ROCM_PATH}" CACHE PATH "Path to the ROCm installation.")
  set(rocm_bin "$ENV{ROCM_PATH}/bin")
else()
  set(ROCM_PATH "/opt/rocm" CACHE PATH "Path to the ROCm installation.")
  set(rocm_bin "/opt/rocm/bin")
endif()

if (NOT DEFINED ENV{CXX})
  if(EXISTS "${rocm_bin}/amdclang++")
    set(CMAKE_CXX_COMPILER "${rocm_bin}/amdclang++" CACHE PATH "Path to the C++ compiler")
  else()
    if(EXISTS "${ROCM_PATH}/llvm/bin/amdclang++")
      set(rocm_bin "${ROCM_PATH}/llvm/bin")
      set(CMAKE_CXX_COMPILER "${rocm_bin}/amdclang++" CACHE PATH "Path to the C++ compiler")
    elseif(EXISTS "${ROCM_PATH}/llvm/bin/clang++")
      set(rocm_bin "${ROCM_PATH}/llvm/bin")
      set(CMAKE_CXX_COMPILER "${rocm_bin}/clang++" CACHE PATH "Path to the C++ compiler")
    endif()
  endif()
else()
  set(CMAKE_CXX_COMPILER "$ENV{CXX}" CACHE PATH "Path to the C++ compiler")
endif()

if (NOT DEFINED ENV{CXXFLAGS})
  set(CMAKE_CXX_FLAGS_DEBUG "-g -O1")
  set(CMAKE_CXX_FLAGS_RELEASE "-O3")
endif()

if(NOT CMAKE_BUILD_TYPE)
  message(STATUS "Setting build type to 'Release' as none was specified.")
  set(CMAKE_BUILD_TYPE "Release" CACHE STRING "Choose the type of build." FORCE)
endif()
