/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.iterators;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class CollatingIterator
implements Iterator {
    private Comparator comparator = null;
    private ArrayList iterators = null;
    private ArrayList values = null;
    private BitSet valueSet = null;
    private int lastReturned = -1;

    public CollatingIterator() {
        this(null, 2);
    }

    public CollatingIterator(Comparator comparator) {
        this(comparator, 2);
    }

    public CollatingIterator(Comparator comparator, int n) {
        this.iterators = new ArrayList(n);
        this.setComparator(comparator);
    }

    public CollatingIterator(Comparator comparator, Collection collection) {
        this(comparator, collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = (Iterator)iterator.next();
            this.addIterator(iterator2);
        }
    }

    public CollatingIterator(Comparator comparator, Iterator iterator, Iterator iterator2) {
        this(comparator, 2);
        this.addIterator(iterator);
        this.addIterator(iterator2);
    }

    public CollatingIterator(Comparator comparator, Iterator[] iteratorArray) {
        this(comparator, iteratorArray.length);
        int n = 0;
        while (n < iteratorArray.length) {
            this.addIterator(iteratorArray[n]);
            ++n;
        }
    }

    public void addIterator(Iterator iterator) {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.add(iterator);
    }

    private boolean anyHasNext(ArrayList arrayList) {
        int n = 0;
        while (n < arrayList.size()) {
            Iterator iterator = (Iterator)arrayList.get(n);
            if (iterator.hasNext()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean anyValueSet(BitSet bitSet) {
        int n = 0;
        while (n < bitSet.size()) {
            if (bitSet.get(n)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void checkNotStarted() throws IllegalStateException {
        if (this.values != null) {
            throw new IllegalStateException("Can't do that after next or hasNext has been called.");
        }
    }

    private void clear(int n) {
        this.values.set(n, null);
        this.valueSet.clear(n);
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public List getIterators() {
        return Collections.unmodifiableList(this.iterators);
    }

    public boolean hasNext() {
        this.start();
        return this.anyValueSet(this.valueSet) || this.anyHasNext(this.iterators);
    }

    private int least() throws IllegalStateException {
        int n = -1;
        Object t = null;
        int n2 = 0;
        while (n2 < this.values.size()) {
            if (!this.valueSet.get(n2)) {
                this.set(n2);
            }
            if (this.valueSet.get(n2)) {
                if (n == -1) {
                    n = n2;
                    t = this.values.get(n2);
                } else {
                    Object e2 = this.values.get(n2);
                    if (this.comparator.compare(e2, t) < 0) {
                        t = e2;
                        n = n2;
                    }
                }
            }
            ++n2;
        }
        return n;
    }

    public Object next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int n = this.least();
        if (n == -1) {
            throw new NoSuchElementException();
        }
        Object e2 = this.values.get(n);
        this.clear(n);
        this.lastReturned = n;
        return e2;
    }

    public void remove() {
        if (this.lastReturned == -1) {
            throw new NoSuchElementException("No value has been returned yet.");
        }
        Iterator iterator = (Iterator)this.iterators.get(this.lastReturned);
        iterator.remove();
    }

    private boolean set(int n) {
        Iterator iterator = (Iterator)this.iterators.get(n);
        if (iterator.hasNext()) {
            this.values.set(n, iterator.next());
            this.valueSet.set(n);
            return true;
        }
        this.values.set(n, null);
        this.valueSet.clear(n);
        return false;
    }

    public void setComparator(Comparator comparator) {
        this.checkNotStarted();
        this.comparator = comparator;
    }

    public void setIterator(int n, Iterator iterator) throws IndexOutOfBoundsException {
        this.checkNotStarted();
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        this.iterators.set(n, iterator);
    }

    private void start() {
        if (this.values == null) {
            this.values = new ArrayList(this.iterators.size());
            this.valueSet = new BitSet(this.iterators.size());
            int n = 0;
            while (n < this.iterators.size()) {
                this.values.add(null);
                this.valueSet.clear(n);
                ++n;
            }
        }
    }
}

