/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import org.eso.cpl.ScriptSyntax;

public class BourneSyntax
implements ScriptSyntax {
    @Override
    public String getName() {
        return "Bourne shell";
    }

    @Override
    public String getExtension() {
        return ".sh";
    }

    @Override
    public String startScript() {
        return "#!/bin/sh\n";
    }

    @Override
    public String blankLine() {
        return "\n";
    }

    @Override
    public String commentLine(String text) {
        return "# " + text + "\n";
    }

    @Override
    public String invokeCommand(String cmd) {
        return cmd + "\n";
    }

    @Override
    public String defineMacro(String name, String value) {
        return name + "=" + value + "\n";
    }

    @Override
    public String defineMacro(String name, String[] value) {
        StringBuffer buf = new StringBuffer().append(name).append('=').append('\"');
        for (int i = 0; i < value.length; ++i) {
            buf.append("\n   ").append(value[i]);
        }
        buf.append('\"').append('\n');
        return buf.toString();
    }

    @Override
    public String useMacro(String name) {
        return '$' + name;
    }

    @Override
    public String quoteWord(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append("'");
        block3: for (int i = 0; i < text.length(); ++i) {
            char c2 = text.charAt(i);
            switch (c2) {
                case '\'': {
                    buf.append("'\"'\"'");
                    continue block3;
                }
                default: {
                    buf.append(c2);
                }
            }
        }
        buf.append("'");
        return buf.toString();
    }

    @Override
    public String namify(String name) {
        return name.replaceAll("[^a-zA-Z0-9]", "_");
    }
}

