/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.NamingScheme;
import org.eso.cpl.Parameter;
import org.eso.cpl.Recipe;
import org.eso.cpl.RecipeLibrary;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class StateSaver {
    private final Document doc_;

    public StateSaver(Recipe recipe, Parameter[] params, FrameList inFrames, String productRoot, NamingScheme namer) {
        try {
            this.doc_ = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element el = this.storeRequest(recipe, params, inFrames, productRoot, namer);
            this.doc_.appendChild(el);
        }
        catch (ParserConfigurationException e2) {
            throw new RuntimeException("Unexpected XML exception", e2);
        }
    }

    public void write(OutputStream ostrm) throws IOException {
        try {
            Transformer trans = TransformerFactory.newInstance().newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            trans.setOutputProperty("omit-xml-declaration", "yes");
            trans.transform(new DOMSource(this.doc_), new StreamResult(ostrm));
        }
        catch (TransformerException e2) {
            throw new RuntimeException("Unexpected XML error", e2);
        }
    }

    private Element storeRequest(Recipe recipe, Parameter[] params, FrameList inFrames, String productRoot, NamingScheme namer) {
        Element recipeEl;
        Element prootEl;
        Element inframesEl;
        Element paramsEl;
        Element libraryEl;
        if (recipe != null) {
            RecipeLibrary rlib = recipe.getLibrary();
            if (rlib != null) {
                libraryEl = this.doc_.createElement("library");
                StateSaver.setAttributeValue(libraryEl, "name", rlib.getName());
                StateSaver.setAttributeValue(libraryEl, "class", rlib.getClass().getName());
                StateSaver.setAttributeValue(libraryEl, "location", rlib.getLocation());
            } else {
                libraryEl = null;
            }
        } else {
            libraryEl = null;
        }
        if (params != null) {
            paramsEl = this.doc_.createElement("parameters");
            for (int i = 0; i < params.length; ++i) {
                paramsEl.appendChild(this.storeParameter(params[i]));
            }
        } else {
            paramsEl = null;
        }
        if (inFrames != null) {
            inframesEl = this.doc_.createElement("frames");
            Iterator it = inFrames.iterator();
            while (it.hasNext()) {
                inframesEl.appendChild(this.storeFrame((Frame)it.next()));
            }
        } else {
            inframesEl = null;
        }
        if (productRoot != null && !productRoot.equals(".") || namer != null) {
            prootEl = this.doc_.createElement("products");
            StateSaver.setAttributeValue(prootEl, "directory", productRoot);
            StateSaver.setAttributeValue(prootEl, "naming", namer.getName());
        } else {
            prootEl = null;
        }
        if (recipe != null) {
            recipeEl = this.doc_.createElement("recipe");
            StateSaver.setAttributeValue(recipeEl, "name", recipe.getName());
            StateSaver.setAttributeValue(recipeEl, "version", Long.toString(recipe.getVersion()));
            if (libraryEl != null) {
                recipeEl.appendChild(libraryEl);
            }
            if (paramsEl != null) {
                recipeEl.appendChild(paramsEl);
            }
        } else {
            recipeEl = null;
        }
        Element requestEl = this.doc_.createElement("request");
        if (recipeEl != null) {
            requestEl.appendChild(recipeEl);
        }
        if (inframesEl != null) {
            requestEl.appendChild(inframesEl);
        }
        if (prootEl != null) {
            requestEl.appendChild(prootEl);
        }
        return requestEl;
    }

    public Element storeParameter(Parameter param) {
        Element el = this.doc_.createElement("parameter");
        StateSaver.setAttributeValue(el, "name", param.getName());
        StateSaver.setAttributeValue(el, "value", param.getValue().toString());
        return el;
    }

    public Element storeFrame(Frame frame) {
        Element el = this.doc_.createElement("frame");
        String filename = frame.getFile().getPath();
        String tag = frame.getTag();
        FrameLevel level = frame.getLevel();
        FrameGroup group = frame.getGroup();
        FrameType type = frame.getType();
        StateSaver.setAttributeValue(el, "filename", filename);
        StateSaver.setAttributeValue(el, "tag", tag);
        StateSaver.setAttributeValue(el, "level", level == null ? null : level.getName());
        StateSaver.setAttributeValue(el, "group", group == null ? null : group.getName());
        StateSaver.setAttributeValue(el, "type", type == null ? null : type.getName());
        return el;
    }

    private static void setAttributeValue(Element el, String attname, String attvalue) {
        if (attvalue != null) {
            el.setAttribute(attname, StateSaver.escapeAttributeValue(attvalue));
        }
    }

    private static String escapeAttributeValue(String text) {
        int leng = text.length();
        StringBuffer sbuf = new StringBuffer(leng);
        block7: for (int i = 0; i < leng; ++i) {
            char c2 = text.charAt(i);
            switch (c2) {
                case '<': {
                    sbuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sbuf.append("&gt;");
                    continue block7;
                }
                case '&': {
                    sbuf.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    sbuf.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sbuf.append("&quot;");
                    continue block7;
                }
                default: {
                    sbuf.append(c2);
                }
            }
        }
        return sbuf.toString();
    }
}

