/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.test;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eso.cpl.CPLException;
import org.eso.cpl.EnumConstraint;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.cpl.MarkedFrameList;
import org.eso.cpl.Parameter;
import org.eso.cpl.ParameterConstraint;
import org.eso.cpl.ParameterType;
import org.eso.cpl.ParameterValueException;
import org.eso.cpl.RangeConstraint;
import org.eso.cpl.Recipe;
import org.eso.cpl.Request;
import org.eso.cpl.jni.CPLControl;
import org.eso.cpl.jni.LTDLException;
import org.eso.cpl.jni.LibraryLoader;
import org.eso.cpl.jni.MessageListener;
import org.eso.cpl.jni.PluginLibrary;
import org.eso.cpl.test.CPLDebug;

public class JNICPLTest
extends TestCase {
    public static final String DLL_NAME = "libtestgimasterbias.so";
    public static final String DLL_SUBDIR = "recipes";
    public static final String DATA_DIR = "../testdata";
    public static final String RECIPE_NAME = "gimasterbias";

    public JNICPLTest(String name) {
        super(name);
    }

    public void testCPL() throws LTDLException, CPLException, ParameterValueException, IOException {
        LibraryLoader loader = new LibraryLoader();
        try {
            loader.getLibrary("libneverwas.so");
            JNICPLTest.fail();
        }
        catch (LTDLException e2) {
            // empty catch block
        }
        PluginLibrary giraffeLib = JNICPLTest.getGiraffeLibrary(loader);
        JNICPLTest.assertNotNull(giraffeLib);
        this.exercisePluginLibrary(giraffeLib);
    }

    private static PluginLibrary getGiraffeLibrary(LibraryLoader loader) throws LTDLException, CPLException {
        String[] pathEls = System.getProperty("java.library.path").split(":");
        for (int i = 0; i < pathEls.length; ++i) {
            loader.getPath().add(pathEls[i] + File.separator + DLL_SUBDIR);
        }
        PluginLibrary giraffeLib = loader.getLibrary(DLL_NAME);
        return giraffeLib;
    }

    public static PluginLibrary getGiraffeLibrary() throws LTDLException, CPLException {
        return JNICPLTest.getGiraffeLibrary(new LibraryLoader());
    }

    private void exercisePluginLibrary(PluginLibrary lib) throws CPLException, ParameterValueException, IOException {
        Recipe[] giraffeRecipes = lib.getRecipes();
        JNICPLTest.assertNotNull(giraffeRecipes);
        JNICPLTest.assertEquals(1, giraffeRecipes.length);
        Recipe rec = giraffeRecipes[0];
        JNICPLTest.assertEquals(RECIPE_NAME, rec.getName());
        this.exerciseRecipe(rec);
    }

    private void exerciseRecipe(Recipe recipe) throws CPLException, ParameterValueException, IOException {
        String author = recipe.getAuthor();
        String copyright = recipe.getCopyright();
        String description = recipe.getDescription();
        String email = recipe.getEmail();
        String name = recipe.getName();
        String synopsis = recipe.getSynopsis();
        long version = recipe.getVersion();
        JNICPLTest.assertEquals("Michael Kiesgen", author);
        JNICPLTest.assertTrue(copyright.indexOf("(C)") >= 0);
        JNICPLTest.assertEquals("TBD", description);
        JNICPLTest.assertTrue(email.indexOf("@eso.org") > 0);
        JNICPLTest.assertTrue(synopsis.length() > 0);
        JNICPLTest.assertEquals(105L, version);
        Parameter[] params = recipe.getDefaultParameters();
        JNICPLTest.assertEquals(8, params.length);
        HashSet ptypes = new HashSet();
        HashSet pconstraints = new HashSet();
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            JNICPLTest.assertEquals(params[i].getDefault(), params[i].getValue());
            this.exerciseParameter(param, ptypes, pconstraints);
        }
        ParameterType[] knownTypes = new ParameterType[]{ParameterType.BOOL, ParameterType.DOUBLE, ParameterType.INT, ParameterType.STRING};
        JNICPLTest.assertEquals(new HashSet<ParameterType>(Arrays.asList(knownTypes)), new HashSet(ptypes));
        Class[] knownConstraints = new Class[]{EnumConstraint.class, null};
        JNICPLTest.assertEquals(new HashSet<Class>(Arrays.asList(knownConstraints)), new HashSet(pconstraints));
        for (int i = 0; i < params.length; ++i) {
            Parameter param = params[i];
            param.setValue(param.getDefault());
        }
        TestMessageListener ml1 = new TestMessageListener("ML1");
        TestMessageListener ml2 = new TestMessageListener("ML2");
        CPLControl.addMessageListener(ml1);
        CPLControl.addMessageListener(ml2);
        this.executeMasterBiasRecipe(recipe);
        JNICPLTest.assertEquals(0, ml1.logMessageCount);
        JNICPLTest.assertEquals(3, ml1.outMessageCount);
        JNICPLTest.assertEquals(3, ml1.errMessageCount);
        JNICPLTest.assertEquals(ml1.logMessageCount, ml2.logMessageCount);
        JNICPLTest.assertEquals(ml1.outMessageCount, ml2.outMessageCount);
        JNICPLTest.assertEquals(ml1.errMessageCount, ml2.errMessageCount);
    }

    private void exerciseParameter(Parameter param, Set usedTypes, Set usedConstraints) throws ParameterValueException {
        ParameterType type = param.getType();
        ParameterConstraint constraint = param.getConstraint();
        String context = param.getContext();
        String help = param.getHelp();
        String name = param.getName();
        String tag = param.getTag();
        Object initValue = param.getValue();
        usedTypes.add(type);
        Class<?> constraintClass = constraint == null ? null : constraint.getClass();
        usedConstraints.add(constraintClass);
        try {
            param.setValue(null);
            JNICPLTest.fail();
        }
        catch (NullPointerException e2) {
        }
        catch (ParameterValueException e3) {
            // empty catch block
        }
        if (constraintClass == null) {
            if (type == ParameterType.BOOL) {
                this.parameterSet(param, Boolean.TRUE);
                this.parameterSet(param, Boolean.FALSE);
                this.parameterSetString(param, "true", Boolean.TRUE);
                this.parameterSetString(param, "FaLsE", Boolean.FALSE);
                this.parameterBad(param, new Integer(100));
                this.parameterBadString(param, "not a boolean");
            } else if (type == ParameterType.DOUBLE) {
                this.parameterSet(param, new Double(-23.0));
                this.parameterSet(param, new Double(Double.NaN));
                this.parameterSetString(param, "-23", new Double(-23.0));
                this.parameterSetString(param, "0.25e-33", new Double(2.5E-34));
                this.parameterBad(param, new Integer(101));
                this.parameterBadString(param, "not a double");
            } else if (type == ParameterType.INT) {
                this.parameterSet(param, new Integer(5));
                this.parameterSetString(param, "-5", new Integer(-5));
                this.parameterBad(param, new Double(Math.PI));
                this.parameterBadString(param, "3.1415");
                this.parameterBadString(param, "not an integer");
            } else if (type == ParameterType.STRING) {
                this.parameterSet(param, "");
                this.parameterSet(param, "value");
                this.parameterSetString(param, "", "");
                this.parameterSetString(param, "value", "value");
            } else {
                JNICPLTest.fail();
            }
        } else if (constraintClass == EnumConstraint.class) {
            EnumConstraint econs = (EnumConstraint)constraint;
            Iterator it = econs.getOptions().iterator();
            while (it.hasNext()) {
                this.parameterSet(param, it.next());
            }
            if (type == ParameterType.STRING) {
                this.parameterBad(param, "not an option");
            } else if (type == ParameterType.INT) {
                this.parameterBad(param, new Integer(9998));
            } else if (type == ParameterType.DOUBLE) {
                this.parameterBad(param, new Double(2.818281828459045));
            } else {
                JNICPLTest.fail();
            }
        } else if (constraintClass == RangeConstraint.class) {
            RangeConstraint rcons = (RangeConstraint)constraint;
            if (type == ParameterType.INT) {
                int min = (Integer)rcons.getMinimum();
                int max = (Integer)rcons.getMaximum();
                this.parameterSet(param, new Integer(min));
                this.parameterSet(param, new Integer(min + 1));
                this.parameterSet(param, new Integer(max - 1));
                this.parameterSet(param, new Integer(max));
                this.parameterBad(param, new Integer(min - 1));
                this.parameterBad(param, new Integer(max + 1));
            } else if (type == ParameterType.DOUBLE) {
                double min = (Double)rcons.getMinimum();
                double max = (Double)rcons.getMaximum();
                this.parameterSet(param, new Double(min));
                this.parameterSet(param, new Double(min + 0.1));
                this.parameterSet(param, new Double(max - 0.1));
                this.parameterSet(param, new Double(max));
                this.parameterBad(param, new Double(min - 0.1));
                this.parameterBad(param, new Double(min + 0.1));
            } else {
                JNICPLTest.fail();
            }
        }
    }

    private void executeMasterBiasRecipe(Recipe recipe) throws CPLException, ParameterValueException, IOException {
        Parameter[] params2;
        Parameter[] params = recipe.getDefaultParameters();
        JNICPLTest.assertTrue(params != (params2 = recipe.getDefaultParameters()));
        params2[0].setValue(params2[0].getValue());
        MarkedFrameList inFrames = JNICPLTest.getMasterBiasInputFrames();
        File dir = new File("Sir_Not-Appearing-In-This-Filesystem");
        JNICPLTest.assertTrue(!dir.exists());
        try {
            recipe.execute(params, inFrames, dir);
            JNICPLTest.fail();
        }
        catch (CPLException e2) {
            // empty catch block
        }
        dir = new File("/");
        JNICPLTest.assertTrue(!dir.canWrite());
        try {
            recipe.execute(params, inFrames, dir);
            JNICPLTest.fail();
        }
        catch (CPLException e3) {
            // empty catch block
        }
        CPLDebug logger = new CPLDebug();
        File productName = new File("master_bias.fits");
        productName.delete();
        JNICPLTest.assertTrue(!productName.exists());
        FrameList outFrames = recipe.execute(params, inFrames, null);
        File newDir = new File("./tmp_JNICPLTest");
        if (newDir.exists()) {
            File[] files = newDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                JNICPLTest.assertTrue(files[i].delete());
            }
            JNICPLTest.assertTrue(newDir.delete());
        }
        JNICPLTest.assertTrue(newDir.mkdir());
        FrameList outFrames2 = recipe.execute(params, inFrames, newDir);
        params = recipe.getDefaultParameters();
        Parameter cbpParam = params[7];
        JNICPLTest.assertEquals("giraffe.masterbias.crebadpixmap", cbpParam.getName());
        JNICPLTest.assertEquals(ParameterType.BOOL, cbpParam.getType());
        JNICPLTest.assertEquals(Boolean.FALSE, cbpParam.getValue());
        cbpParam.setValue(Boolean.TRUE);
        FrameList outFrames3 = recipe.execute(params, inFrames, null);
    }

    public static MarkedFrameList getMasterBiasInputFrames() {
        File[] files = new File(DATA_DIR).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("small_GIRAF") && name.endsWith(".fits");
            }
        });
        MarkedFrameList inFrames = new MarkedFrameList();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            Frame frm = new Frame(file);
            inFrames.add(frm);
            frm.setGroup(FrameGroup.RAW);
            frm.setLevel(FrameLevel.INTERMEDIATE);
            frm.setType(FrameType.IMAGE);
            frm.setTag("BIAS");
        }
        return inFrames;
    }

    public static Request getMasterBiasRequest() {
        try {
            Request req = new Request(JNICPLTest.getGiraffeLibrary().getRecipes()[0]);
            req.getInputFrames().addAll(JNICPLTest.getMasterBiasInputFrames());
            return req;
        }
        catch (LTDLException e2) {
            throw new RuntimeException(e2);
        }
        catch (CPLException e3) {
            throw new RuntimeException(e3);
        }
    }

    private void parameterSet(Parameter param, Object value) throws ParameterValueException {
        param.setValue(value);
        JNICPLTest.assertEquals(value, param.getValue());
    }

    private void parameterSetString(Parameter param, String str, Object value) throws ParameterValueException {
        param.setValueFromString(str);
        JNICPLTest.assertEquals(value, param.getValue());
    }

    private void parameterBad(Parameter param, Object value) {
        try {
            param.setValue(value);
            JNICPLTest.fail(param + " erroneously accepted value " + value);
        }
        catch (ParameterValueException parameterValueException) {
            // empty catch block
        }
    }

    private void parameterBadString(Parameter param, String str) {
        try {
            param.setValueFromString(str);
            JNICPLTest.fail(param + " erroneously accepted value " + str);
        }
        catch (ParameterValueException parameterValueException) {
            // empty catch block
        }
    }

    public static TestSuite suite() {
        return new TestSuite(JNICPLTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run(JNICPLTest.suite());
    }

    private static class TestMessageListener
    implements MessageListener {
        int outMessageCount;
        int errMessageCount;
        int logMessageCount;
        String name;

        public TestMessageListener(String nm) {
            this.name = nm;
        }

        @Override
        public void logMessage(String domain, String msg, int flags) {
            ++this.logMessageCount;
            System.out.println("[" + this.name + "] LOGMSG " + this.logMessageCount + ": " + domain + " :: " + msg);
        }

        @Override
        public void outMessage(String msg) {
            ++this.outMessageCount;
            System.out.println("[" + this.name + "] OUTMSG " + this.outMessageCount + ": " + msg);
        }

        @Override
        public void errMessage(String msg) {
            ++this.errMessageCount;
            System.out.println("[" + this.name + "] ERRMSG " + this.errMessageCount + ": " + msg);
        }
    }
}

