/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.database;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import org.eso.gasgano.properties.PropertyDB;

public class FileDownloader {
    public static int retrieveFilesFromDb(Enumeration list, String dirPath) {
        int rc = -1;
        PrintWriter printStream = null;
        String retrieveCommand = null;
        String singleLine = null;
        if (dirPath == null) {
            System.err.println("Directory for file retrieval has not been specified");
            return rc;
        }
        if (!list.hasMoreElements()) {
            System.err.println("No files to be retrieved");
            return rc;
        }
        retrieveCommand = new String(PropertyDB.getInstance().getProperty("MENU_RETRIEVE") + " " + dirPath);
        try {
            Process p = Runtime.getRuntime().exec(retrieveCommand);
            printStream = new PrintWriter(new BufferedOutputStream(p.getOutputStream()));
            BufferedReader buffRed = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while (list.hasMoreElements()) {
                String tmpString = list.nextElement().toString();
                System.out.println(tmpString);
                printStream.print(tmpString);
                if (!list.hasMoreElements()) continue;
                printStream.print("\n");
            }
            printStream.close();
            while ((singleLine = buffRed.readLine()) != null) {
                System.out.println(singleLine);
            }
            try {
                p.waitFor();
                rc = p.exitValue();
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted while executing: " + ie.toString());
            }
            catch (IllegalThreadStateException ie) {
                System.out.println(ie.toString());
            }
        }
        catch (IOException e2) {
            System.out.println("Error executing command: " + e2.toString());
        }
        return rc;
    }
}

