/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.viewers;

import java.io.IOException;
import java.util.Vector;
import org.eso.gasgano.viewers.ExternalViewer;
import org.eso.gasgano.viewers.ExternalViewerException;
import org.eso.gasgano.viewers.SkyCatConnection;

public class SkyCatExternalViewer
implements ExternalViewer {
    private String skyCatCommand;

    @Override
    public void setCommand(String command) {
        this.skyCatCommand = command;
    }

    @Override
    public void displayFiles(Vector filePaths) throws ExternalViewerException {
        if (filePaths == null || filePaths.size() < 1) {
            throw new ExternalViewerException("Invalid or empty file paths argument.");
        }
        try {
            SkyCatConnection c2 = new SkyCatConnection();
            c2.setAddressFromRTDFile();
            if (!c2.isSkyCatRunning()) {
                c2.startSkyCat(this.skyCatCommand);
            }
            c2.setAddressFromRTDFile();
            c2.sendFile(filePaths.elementAt(0).toString());
        }
        catch (IOException e2) {
            throw new ExternalViewerException("Error sending file to SkyCat: " + e2.getMessage());
        }
    }
}

