/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.log4j.Logger;
import org.eso.util.archive.ArchiveClient;
import org.eso.util.archive.ArchiveException;
import org.eso.util.archive.ArchiveTask;
import org.eso.util.archive.MimeType;
import org.eso.util.archive.NgasActiveNodesService;
import org.eso.util.archive.NgasHost;
import org.eso.util.archive.Pair;
import org.eso.util.archive.RestoreTask;
import org.eso.util.archive.RetrieveFileTask;
import org.eso.util.archive.RetrieveStreamTask;
import org.eso.util.archive.RoundRobin;

public class NgasArchiveClient
implements ArchiveClient {
    static final Logger logger = Logger.getLogger(NgasArchiveClient.class);
    private String downloadDir;
    private NgasActiveNodesService ngasActiveNodesService;
    private RoundRobin<NgasHost> ngasHosts;
    private Iterator<NgasHost> ngasHostsIterator;
    private HttpClient httpclient;
    private ExecutorService execService;
    private CompletionService<Pair<String, File>> completionService;
    private boolean overwrite = false;
    private Map<String, String> uncompressCommands;

    public NgasArchiveClient(String downloadDir, NgasActiveNodesService ngasActiveNodesService, int numThreads, int timeout, boolean overwrite) throws ArchiveException {
        this.init(downloadDir, ngasActiveNodesService, numThreads, timeout, overwrite);
    }

    public NgasArchiveClient(String downloadDir, NgasActiveNodesService ngasActiveNodesService, int numThreads, int timeout) throws ArchiveException {
        this.init(downloadDir, ngasActiveNodesService, numThreads, timeout, true);
    }

    public void init(String downloadDir, NgasActiveNodesService ngasActiveNodesService, int numThreads, int timeout, boolean overwrite) throws ArchiveException {
        this.downloadDir = downloadDir;
        this.ngasActiveNodesService = ngasActiveNodesService;
        this.refreshArchiveNodes();
        this.execService = Executors.newFixedThreadPool(numThreads);
        this.completionService = new ExecutorCompletionService<Pair<String, File>>(this.execService);
        this.overwrite = overwrite;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, timeout);
        HttpConnectionParams.setSoTimeout(params, timeout);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", PlainSocketFactory.getSocketFactory(), 80));
        ThreadSafeClientConnManager cm = new ThreadSafeClientConnManager(params, registry);
        this.httpclient = new DefaultHttpClient(cm, params);
        this.httpclient.getParams().setParameter("http.protocol.handle-redirects", false);
        Thread runtimeHookThread = new Thread(){

            @Override
            public void run() {
                logger.debug("Shutting down executor service...");
                NgasArchiveClient.this.execService.shutdown();
                logger.debug("Done");
            }
        };
        Runtime.getRuntime().addShutdownHook(runtimeHookThread);
    }

    @Override
    public Map<String, File> retrieve(Set<String> fileIds, boolean uncompress, boolean hotFly, boolean addIrafKeywords) throws ArchiveException {
        if (!hotFly && addIrafKeywords) {
            throw new ArchiveException("Add IRAF keywords option requires hotfly to be enabled");
        }
        HashMap<String, File> downloadedFiles = new HashMap<String, File>();
        HashSet<Future<Pair<String, File>>> results = new HashSet<Future<Pair<String, File>>>();
        for (String id : fileIds) {
            RetrieveFileTask task = new RetrieveFileTask(this.httpclient, this.ngasHostsIterator.next(), id, hotFly, addIrafKeywords);
            task.setDownloadDir(this.downloadDir);
            task.setOverwrite(this.overwrite);
            task.setUncompress(uncompress);
            task.setUncompressCommands(this.uncompressCommands);
            results.add(this.completionService.submit(task));
        }
        boolean success = true;
        for (int i = 0; i < fileIds.size(); ++i) {
            try {
                Pair<String, File> downloadedFile = this.completionService.take().get();
                logger.info("Successfully downloaded id [" + downloadedFile.getFirst() + "] to [" + downloadedFile.getSecond().getAbsolutePath() + "]");
                downloadedFiles.put(downloadedFile.getFirst(), downloadedFile.getSecond());
                continue;
            }
            catch (InterruptedException e2) {
                logger.error(e2.getMessage());
                success = false;
                continue;
            }
            catch (ExecutionException e3) {
                logger.error(e3.getMessage());
                success = false;
            }
        }
        if (!success) {
            throw new ArchiveException("Errors occurred while retrieving some of the files");
        }
        logger.info("All files successfully downloaded");
        return downloadedFiles;
    }

    @Override
    public File retrieve(String fileId, boolean uncompress, boolean hotFly, boolean addIrafKeywords) throws ArchiveException {
        if (!hotFly && addIrafKeywords) {
            throw new ArchiveException("Add IRAF keywords option requires hotfly to be enabled");
        }
        RetrieveFileTask task = new RetrieveFileTask(this.httpclient, this.ngasHostsIterator.next(), fileId, hotFly, addIrafKeywords);
        task.setDownloadDir(this.downloadDir);
        task.setOverwrite(this.overwrite);
        task.setUncompress(uncompress);
        task.setUncompressCommands(this.uncompressCommands);
        Future<Pair<String, File>> res = this.completionService.submit(task);
        try {
            Pair<String, File> downloadedFile = res.get();
            logger.info("Successfully downloaded id [" + downloadedFile.getFirst() + "] to [" + downloadedFile.getSecond().getAbsolutePath() + "]");
            return downloadedFile.getSecond();
        }
        catch (InterruptedException e2) {
            throw new ArchiveException(e2);
        }
        catch (ExecutionException e3) {
            throw new ArchiveException(e3);
        }
    }

    @Override
    public InputStream retrieveStream(String fileId, boolean hotFly, boolean addIrafKeywords) throws ArchiveException {
        RetrieveStreamTask task = new RetrieveStreamTask(this.httpclient, this.ngasHostsIterator.next(), fileId, hotFly, addIrafKeywords);
        try {
            return task.call();
        }
        catch (Exception e2) {
            throw new ArchiveException(e2);
        }
    }

    @Override
    public File retrieve(String fileId) throws ArchiveException {
        return this.retrieve(fileId, false, false);
    }

    @Override
    public File retrieve(String fileId, boolean uncompress) throws ArchiveException {
        return this.retrieve(fileId, uncompress, false, false);
    }

    @Override
    public Map<String, File> retrieve(Set<String> fileIds) throws ArchiveException {
        return this.retrieve(fileIds, false, false);
    }

    @Override
    public Map<String, File> retrieve(Set<String> fileIds, boolean uncompress) throws ArchiveException {
        return this.retrieve(fileIds, uncompress, false, false);
    }

    @Override
    public Map<String, File> retrieve(Set<String> fileIds, boolean uncompress, boolean hotFly) throws ArchiveException {
        return this.retrieve(fileIds, uncompress, hotFly, false);
    }

    @Override
    public File retrieve(String fileId, boolean uncompress, boolean hotFly) throws ArchiveException {
        return this.retrieve(fileId, uncompress, hotFly, false);
    }

    @Override
    public InputStream retrieveStream(String fileId) throws ArchiveException {
        return this.retrieveStream(fileId, false, false);
    }

    @Override
    public InputStream retrieveStream(String fileId, boolean hotFly) throws ArchiveException {
        return this.retrieveStream(fileId, hotFly, false);
    }

    @Override
    public void archive(File file, String mimeType, String fileId) throws ArchiveException {
        Future<Pair<String, File>> res = this.completionService.submit(new ArchiveTask(this.httpclient, this.ngasHostsIterator.next(), file, mimeType, fileId));
        try {
            res.get();
        }
        catch (InterruptedException e2) {
            throw new ArchiveException(e2);
        }
        catch (ExecutionException e3) {
            throw new ArchiveException(e3);
        }
    }

    @Override
    public void archive(File file, String mimeType) throws ArchiveException {
        this.archive(file, mimeType, null);
    }

    @Override
    public void archive(File file) throws ArchiveException {
        this.archive(file, MimeType.AUTO.toString(), null);
    }

    @Override
    public void restore(File file, String fileId, int version) throws ArchiveException {
        Future<Pair<String, File>> res = this.completionService.submit(new RestoreTask(this.httpclient, this.ngasHostsIterator.next(), file, fileId, version));
        try {
            res.get();
        }
        catch (InterruptedException e2) {
            throw new ArchiveException(e2);
        }
        catch (ExecutionException e3) {
            throw new ArchiveException(e3);
        }
    }

    @Override
    public void refreshArchiveNodes() throws ArchiveException {
        List<NgasHost> nodes = this.ngasActiveNodesService.getActiveNodes();
        if (nodes.size() == 0) {
            throw new ArchiveException("No active archiving node found, please check the configuration");
        }
        this.ngasHosts = new RoundRobin<NgasHost>(nodes);
        this.ngasHostsIterator = this.ngasHosts.iterator();
    }

    public Map<String, String> getUncompressCommands() {
        return this.uncompressCommands;
    }

    public void setUncompressCommands(Map<String, String> uncompressCommands) {
        this.uncompressCommands = uncompressCommands;
    }
}

