/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpGet;
import org.apache.log4j.Logger;
import org.eso.util.archive.ArchiveException;
import org.eso.util.archive.NgasHost;
import org.eso.util.archive.NgasRedirectResponseException;
import org.eso.util.archive.RetrieveTask;

public class RetrieveStreamTask
extends RetrieveTask
implements Callable<InputStream> {
    static final Logger logger = Logger.getLogger(RetrieveStreamTask.class);

    public RetrieveStreamTask(HttpClient httpClient, NgasHost host, String fileId, boolean hotfly, boolean irafKeywords) {
        super(httpClient, host, fileId, hotfly, irafKeywords);
    }

    @Override
    public InputStream call() throws Exception {
        logger.info("Downloading file " + this.fileId);
        HttpGet get = this.prepareHttpCall();
        try {
            InputStream in;
            try {
                in = this.httpClient.execute(get).getEntity().getContent();
            }
            catch (HttpResponseException e2) {
                String newLocation = ((NgasRedirectResponseException)e2).getRedirectLocation();
                get = new HttpGet(newLocation);
                in = this.httpClient.execute(get).getEntity().getContent();
            }
            return in;
        }
        catch (ClientProtocolException e3) {
            throw new ArchiveException(e3);
        }
        catch (IOException e4) {
            throw new ArchiveException(e4);
        }
    }
}

