%{

#include "headers.h"
#include "cshelly.h"

%}

%option never-interactive 8bit
%option noyywrap
%option caseless pointer
%option noinput nounput

%x string
%x end

%%

ip		return C_IP;
help		return C_HELP;

sta[a-z]*	return C_STAT;
cle[a-z]*	return C_CLEAR;
shut[a-z]*	return C_SHUTDOWN;
sh[a-z]*	return C_SHOW;
acco[a-z]*	return C_ACCOUNTING;
che[a-z]*	return C_CHECKPOINT;
ca[che]*	return C_CACHE;
fl[ow]		return C_FLOW;
rest[a-z]*	return C_RESTORE;

ve[a-z]*	return C_VERSION;

in[a-z]*	{ BEGIN(string); return C_INTERFACE; }
dump		{ BEGIN(string); return C_DUMP; }
imp[a-z]*	{ BEGIN(string); return C_IMPORT; }

<string>{
	[a-z0-9_/.-]+	{
		BEGIN(INITIAL);
		if(!(CSlval.tv_char = strdup(yytext)))
			return ERROR;
		return TOK_STRING;
	}
}

<*>[[:space:]]	/* skip unknown */

<*>.	return ERROR;

<*><<EOF>>	{
		BEGIN(INITIAL);
		yyterminate();
	}

%%
