/*
 * This code was taken from the libstrfunc project, http://lionet.info
 * All rights reserved.
 */
/*-
 * Copyright (c) 1999, 2000, 2001 Lev Walkin <vlm@lionet.info>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: sf_lite.h,v 1.3 2005/05/25 21:07:00 vlm Exp $
 */

#ifndef __SF_LITE_H__
#define __SF_LITE_H__

	  /*************************/
	 /*** 1. String vectors ***/
	/*************************/

/*
 * A vector of known size lengths.
 */
typedef struct {
	char   **list;
	size_t	*lens;
	size_t	count;		/* Count of active elements */
	size_t	listlen;	/* Allocated size */
} svect;

svect	*sinit(void);		/* Create empty string vector */
void	sclear(svect *);	/* Clear elements of filled structure */
void	sfree(svect *);		/* Destroy the entire object vector */

/* Add element to the end of list */
int	sadd(svect *, char *toadd);	/* with strdup(toadd) */
int	sadd2(svect *, char *toadd, size_t len); /* With length. */

int	sdel(svect *, size_t num);	/* Delete specified element */
ssize_t sins(svect *, char *, size_t num); /* Insert element before num */

/* String splitting functions */
svect *split(char *what, char *delim, int flags); /* creates new (svect *) */
int splitf(svect *sl, char *what, char *delim, int strict);
int sf_iaton(const char *cp, unsigned int *pin); /* aka inet_aton */

/* Find element */
ssize_t sfind(svect *, const char *);	/* Case-sensitive */

#endif	/* __SF_LITE_H__ */
