/*
 * Decompiled with CFR 0.152.
 */
package eu.geekplace.sandmann;

import eu.geekplace.jnr.LinuxRtc;
import eu.geekplace.jnr.LinuxRtc$;
import eu.geekplace.jnr.linux.RealtimeAlarm;
import eu.geekplace.jnr.time.Itimerspec;
import eu.geekplace.sandmann.Configuration;
import eu.geekplace.sandmann.Configuration$;
import eu.geekplace.sandmann.Logging$;
import eu.geekplace.sandmann.Logind;
import eu.geekplace.sandmann.Sandmann;
import eu.geekplace.systemd.Systemd;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.login1.ListInhibitorsStruct;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Using$;
import scala.util.Using$Releasable$AutoCloseableIsReleasable$;

public final class Sandmann$
implements Serializable {
    private static final String version;
    private static final String gitVersion;
    private static final String scalaVersion;
    private static final ZoneId systemTimezone;
    private static final ExecutionContext ec;
    public static final Sandmann$ MODULE$;

    private Sandmann$() {
    }

    static {
        MODULE$ = new Sandmann$();
        Logging$.MODULE$.initialize();
        version = Source$.MODULE$.fromResource("eu.geekplace.sandmann/version", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
        gitVersion = Source$.MODULE$.fromResource("eu.geekplace.sandmann/gitVersion", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
        scalaVersion = Source$.MODULE$.fromResource("eu.geekplace.sandmann/scalaVersion", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().next();
        systemTimezone = ZoneId.systemDefault();
        ec = ExecutionContext$.MODULE$.global();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Sandmann$.class);
    }

    public String version() {
        return version;
    }

    public String gitVersion() {
        return gitVersion;
    }

    public String scalaVersion() {
        return scalaVersion;
    }

    public ZoneId systemTimezone() {
        return systemTimezone;
    }

    public ExecutionContext ec() {
        return ec;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void main(String[] args) {
        boolean specialCommand;
        boolean bl;
        if (args.length == 3) {
            String string2 = args[2];
            switch (string2 == null ? 0 : string2.hashCode()) {
                case -1852006340: {
                    if (!"suspend".equals(string2)) break;
                    this.suspend();
                    return;
                }
                case -639497632: {
                    if (!"set-alarm-from-suspend".equals(string2)) break;
                    this.setAlarmFromSuspend();
                    return;
                }
                case -208362330: {
                    if (!"set-alarm-from-poweroff".equals(string2)) break;
                    this.setAlarmFromPoweroff();
                    return;
                }
                case 3322014: {
                    if (!"list".equals(string2)) break;
                    this.list();
                    return;
                }
                case 3496815: {
                    if (!"repl".equals(string2)) break;
                    throw new Exception("Ammonite REPL not yet avaialble with Scala 3.3");
                }
            }
            bl = false;
        } else {
            bl = false;
        }
        if (specialCommand = bl) return;
        Object object = Predef$.MODULE$.refArrayOps(args);
        Configuration config = Configuration$.MODULE$.apply(ArrayOps$.MODULE$.toIndexedSeq$extension(object));
        Using$.MODULE$.resource(DBusConnectionBuilder.forSystemBus().build(), dbus -> Using$.MODULE$.resource(new Sandmann(config, (DBusConnection)dbus), sandmann -> sandmann.run(), Using$Releasable$AutoCloseableIsReleasable$.MODULE$), Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private void suspend() {
        Using$.MODULE$.resource(DBusConnectionBuilder.forSystemBus().build(), sessionConnection -> {
            Logind logind = new Logind((DBusConnection)sessionConnection, null);
            logind.suspendThenHibernateSystem();
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private void list() {
        Using$.MODULE$.resource(DBusConnectionBuilder.forSystemBus().build(), sessionConnection -> {
            Logind logind = new Logind((DBusConnection)sessionConnection, null);
            Buffer<Logind.Session> sessions = logind.getSessionProperties();
            Predef$.MODULE$.println("Sessions");
            Predef$.MODULE$.println(sessions);
            Predef$.MODULE$.println("System");
            Logind.System system = logind.getSystemProperties();
            Predef$.MODULE$.println(system);
            Predef$.MODULE$.println("Inhibitors");
            List<ListInhibitorsStruct> inhibitors = logind.getInhibitors();
            Predef$.MODULE$.println(inhibitors);
            Systemd systemd = new Systemd((DBusConnection)sessionConnection);
            Predef$.MODULE$.println("Sorted Timers");
            Buffer activeTimers = (Buffer)systemd.getActiveTimers().sortBy((Function1<Systemd.ActiveTimer, Instant> & Serializable)_$1 -> _$1.instant(), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
            Predef$.MODULE$.println(((IterableOnceOps)activeTimers.map((Function1<Systemd.ActiveTimer, String> & Serializable)_$2 -> _$2.toVerboseString())).mkString("\n- "));
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private void setAlarmFromSuspend() {
        Duration delay = Duration.ofSeconds(90L);
        Instant alarmInstant = Instant.now().plus(delay);
        Using$.MODULE$.resource(new RealtimeAlarm(), alarm -> {
            alarm.setAlarm(alarmInstant);
            Itimerspec itimerspec = alarm.getAlarm();
            Predef$.MODULE$.println(new StringBuilder(60).append("Wakeup alarm set to ").append(itimerspec).append(", sleeping so that timerfd is not closed").toString());
            Thread.sleep(delay.plus(Duration.ofSeconds(30L)).toMillis());
        }, Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }

    private void setAlarmFromPoweroff() {
        Instant alarmInstant = Instant.now().plus(Duration.ofMinutes(3L));
        Using$.MODULE$.resource(new LinuxRtc(LinuxRtc$.MODULE$.$lessinit$greater$default$1(), LinuxRtc$.MODULE$.$lessinit$greater$default$2()), rtc -> rtc.setAlarm(alarmInstant), Using$Releasable$AutoCloseableIsReleasable$.MODULE$);
    }
}

