// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// Code generated by internal/generate/endpoints/main.go; DO NOT EDIT.

package endpoints

import (
	"regexp"
)

// All known partition IDs.
const (
	AwsPartitionID      = "aws"        // AWS Standard
	AwsCnPartitionID    = "aws-cn"     // AWS China
	AwsIsoPartitionID   = "aws-iso"    // AWS ISO (US)
	AwsIsoBPartitionID  = "aws-iso-b"  // AWS ISOB (US)
	AwsIsoEPartitionID  = "aws-iso-e"  // AWS ISOE (Europe)
	AwsIsoFPartitionID  = "aws-iso-f"  // AWS ISOF
	AwsUsGovPartitionID = "aws-us-gov" // AWS GovCloud (US)
)

// All known Region IDs.
const (
	// AWS Standard partition's Regions.
	AfSouth1RegionID     = "af-south-1"     // Africa (Cape Town)
	ApEast1RegionID      = "ap-east-1"      // Asia Pacific (Hong Kong)
	ApNortheast1RegionID = "ap-northeast-1" // Asia Pacific (Tokyo)
	ApNortheast2RegionID = "ap-northeast-2" // Asia Pacific (Seoul)
	ApNortheast3RegionID = "ap-northeast-3" // Asia Pacific (Osaka)
	ApSouth1RegionID     = "ap-south-1"     // Asia Pacific (Mumbai)
	ApSouth2RegionID     = "ap-south-2"     // Asia Pacific (Hyderabad)
	ApSoutheast1RegionID = "ap-southeast-1" // Asia Pacific (Singapore)
	ApSoutheast2RegionID = "ap-southeast-2" // Asia Pacific (Sydney)
	ApSoutheast3RegionID = "ap-southeast-3" // Asia Pacific (Jakarta)
	ApSoutheast4RegionID = "ap-southeast-4" // Asia Pacific (Melbourne)
	ApSoutheast5RegionID = "ap-southeast-5" // Asia Pacific (Malaysia)
	ApSoutheast7RegionID = "ap-southeast-7" // Asia Pacific (Thailand)
	CaCentral1RegionID   = "ca-central-1"   // Canada (Central)
	CaWest1RegionID      = "ca-west-1"      // Canada West (Calgary)
	EuCentral1RegionID   = "eu-central-1"   // Europe (Frankfurt)
	EuCentral2RegionID   = "eu-central-2"   // Europe (Zurich)
	EuNorth1RegionID     = "eu-north-1"     // Europe (Stockholm)
	EuSouth1RegionID     = "eu-south-1"     // Europe (Milan)
	EuSouth2RegionID     = "eu-south-2"     // Europe (Spain)
	EuWest1RegionID      = "eu-west-1"      // Europe (Ireland)
	EuWest2RegionID      = "eu-west-2"      // Europe (London)
	EuWest3RegionID      = "eu-west-3"      // Europe (Paris)
	IlCentral1RegionID   = "il-central-1"   // Israel (Tel Aviv)
	MeCentral1RegionID   = "me-central-1"   // Middle East (UAE)
	MeSouth1RegionID     = "me-south-1"     // Middle East (Bahrain)
	MxCentral1RegionID   = "mx-central-1"   // Mexico (Central)
	SaEast1RegionID      = "sa-east-1"      // South America (Sao Paulo)
	UsEast1RegionID      = "us-east-1"      // US East (N. Virginia)
	UsEast2RegionID      = "us-east-2"      // US East (Ohio)
	UsWest1RegionID      = "us-west-1"      // US West (N. California)
	UsWest2RegionID      = "us-west-2"      // US West (Oregon)
	// AWS China partition's Regions.
	CnNorth1RegionID     = "cn-north-1"     // China (Beijing)
	CnNorthwest1RegionID = "cn-northwest-1" // China (Ningxia)
	// AWS ISO (US) partition's Regions.
	UsIsoEast1RegionID = "us-iso-east-1" // US ISO East
	UsIsoWest1RegionID = "us-iso-west-1" // US ISO WEST
	// AWS ISOB (US) partition's Regions.
	UsIsobEast1RegionID = "us-isob-east-1" // US ISOB East (Ohio)
	// AWS ISOE (Europe) partition's Regions.
	EuIsoeWest1RegionID = "eu-isoe-west-1" // EU ISOE West
	// AWS ISOF partition's Regions.
	UsIsofEast1RegionID  = "us-isof-east-1"  // US ISOF EAST
	UsIsofSouth1RegionID = "us-isof-south-1" // US ISOF SOUTH
	// AWS GovCloud (US) partition's Regions.
	UsGovEast1RegionID = "us-gov-east-1" // AWS GovCloud (US-East)
	UsGovWest1RegionID = "us-gov-west-1" // AWS GovCloud (US-West)
)

var (
	partitions = map[string]Partition{
		AwsPartitionID: {
			id:          AwsPartitionID,
			name:        "AWS Standard",
			dnsSuffix:   "amazonaws.com",
			regionRegex: regexp.MustCompile(`^(us|eu|ap|sa|ca|me|af|il|mx)\-\w+\-\d+$`),
			regions: map[string]Region{
				AfSouth1RegionID: {
					id:          AfSouth1RegionID,
					description: "Africa (Cape Town)",
				},
				ApEast1RegionID: {
					id:          ApEast1RegionID,
					description: "Asia Pacific (Hong Kong)",
				},
				ApNortheast1RegionID: {
					id:          ApNortheast1RegionID,
					description: "Asia Pacific (Tokyo)",
				},
				ApNortheast2RegionID: {
					id:          ApNortheast2RegionID,
					description: "Asia Pacific (Seoul)",
				},
				ApNortheast3RegionID: {
					id:          ApNortheast3RegionID,
					description: "Asia Pacific (Osaka)",
				},
				ApSouth1RegionID: {
					id:          ApSouth1RegionID,
					description: "Asia Pacific (Mumbai)",
				},
				ApSouth2RegionID: {
					id:          ApSouth2RegionID,
					description: "Asia Pacific (Hyderabad)",
				},
				ApSoutheast1RegionID: {
					id:          ApSoutheast1RegionID,
					description: "Asia Pacific (Singapore)",
				},
				ApSoutheast2RegionID: {
					id:          ApSoutheast2RegionID,
					description: "Asia Pacific (Sydney)",
				},
				ApSoutheast3RegionID: {
					id:          ApSoutheast3RegionID,
					description: "Asia Pacific (Jakarta)",
				},
				ApSoutheast4RegionID: {
					id:          ApSoutheast4RegionID,
					description: "Asia Pacific (Melbourne)",
				},
				ApSoutheast5RegionID: {
					id:          ApSoutheast5RegionID,
					description: "Asia Pacific (Malaysia)",
				},
				ApSoutheast7RegionID: {
					id:          ApSoutheast7RegionID,
					description: "Asia Pacific (Thailand)",
				},
				CaCentral1RegionID: {
					id:          CaCentral1RegionID,
					description: "Canada (Central)",
				},
				CaWest1RegionID: {
					id:          CaWest1RegionID,
					description: "Canada West (Calgary)",
				},
				EuCentral1RegionID: {
					id:          EuCentral1RegionID,
					description: "Europe (Frankfurt)",
				},
				EuCentral2RegionID: {
					id:          EuCentral2RegionID,
					description: "Europe (Zurich)",
				},
				EuNorth1RegionID: {
					id:          EuNorth1RegionID,
					description: "Europe (Stockholm)",
				},
				EuSouth1RegionID: {
					id:          EuSouth1RegionID,
					description: "Europe (Milan)",
				},
				EuSouth2RegionID: {
					id:          EuSouth2RegionID,
					description: "Europe (Spain)",
				},
				EuWest1RegionID: {
					id:          EuWest1RegionID,
					description: "Europe (Ireland)",
				},
				EuWest2RegionID: {
					id:          EuWest2RegionID,
					description: "Europe (London)",
				},
				EuWest3RegionID: {
					id:          EuWest3RegionID,
					description: "Europe (Paris)",
				},
				IlCentral1RegionID: {
					id:          IlCentral1RegionID,
					description: "Israel (Tel Aviv)",
				},
				MeCentral1RegionID: {
					id:          MeCentral1RegionID,
					description: "Middle East (UAE)",
				},
				MeSouth1RegionID: {
					id:          MeSouth1RegionID,
					description: "Middle East (Bahrain)",
				},
				MxCentral1RegionID: {
					id:          MxCentral1RegionID,
					description: "Mexico (Central)",
				},
				SaEast1RegionID: {
					id:          SaEast1RegionID,
					description: "South America (Sao Paulo)",
				},
				UsEast1RegionID: {
					id:          UsEast1RegionID,
					description: "US East (N. Virginia)",
				},
				UsEast2RegionID: {
					id:          UsEast2RegionID,
					description: "US East (Ohio)",
				},
				UsWest1RegionID: {
					id:          UsWest1RegionID,
					description: "US West (N. California)",
				},
				UsWest2RegionID: {
					id:          UsWest2RegionID,
					description: "US West (Oregon)",
				},
			},
			services: map[string]Service{
				"access-analyzer": {
					id: "access-analyzer",
				},
				"account": {
					id: "account",
				},
				"acm": {
					id: "acm",
				},
				"acm-pca": {
					id: "acm-pca",
				},
				"agreement-marketplace": {
					id: "agreement-marketplace",
				},
				"airflow": {
					id: "airflow",
				},
				"amplify": {
					id: "amplify",
				},
				"amplifybackend": {
					id: "amplifybackend",
				},
				"amplifyuibuilder": {
					id: "amplifyuibuilder",
				},
				"aoss": {
					id: "aoss",
				},
				"api.detective": {
					id: "api.detective",
				},
				"api.ecr": {
					id: "api.ecr",
				},
				"api.ecr-public": {
					id: "api.ecr-public",
				},
				"api.elastic-inference": {
					id: "api.elastic-inference",
				},
				"api.fleethub.iot": {
					id: "api.fleethub.iot",
				},
				"api.iotdeviceadvisor": {
					id: "api.iotdeviceadvisor",
				},
				"api.iotwireless": {
					id: "api.iotwireless",
				},
				"api.mediatailor": {
					id: "api.mediatailor",
				},
				"api.pricing": {
					id: "api.pricing",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"api.tunneling.iot": {
					id: "api.tunneling.iot",
				},
				"apigateway": {
					id: "apigateway",
				},
				"app-integrations": {
					id: "app-integrations",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"appflow": {
					id: "appflow",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"applicationinsights": {
					id: "applicationinsights",
				},
				"appmesh": {
					id: "appmesh",
				},
				"apprunner": {
					id: "apprunner",
				},
				"appstream2": {
					id: "appstream2",
				},
				"appsync": {
					id: "appsync",
				},
				"apptest": {
					id: "apptest",
				},
				"aps": {
					id: "aps",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"athena": {
					id: "athena",
				},
				"auditmanager": {
					id: "auditmanager",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"autoscaling-plans": {
					id: "autoscaling-plans",
				},
				"backup": {
					id: "backup",
				},
				"backup-gateway": {
					id: "backup-gateway",
				},
				"batch": {
					id: "batch",
				},
				"bedrock": {
					id: "bedrock",
				},
				"billingconductor": {
					id: "billingconductor",
				},
				"braket": {
					id: "braket",
				},
				"budgets": {
					id: "budgets",
				},
				"cases": {
					id: "cases",
				},
				"cassandra": {
					id: "cassandra",
				},
				"catalog.marketplace": {
					id: "catalog.marketplace",
				},
				"ce": {
					id: "ce",
				},
				"chime": {
					id: "chime",
				},
				"cleanrooms": {
					id: "cleanrooms",
				},
				"cloud9": {
					id: "cloud9",
				},
				"cloudcontrolapi": {
					id: "cloudcontrolapi",
				},
				"clouddirectory": {
					id: "clouddirectory",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudfront": {
					id: "cloudfront",
				},
				"cloudhsm": {
					id: "cloudhsm",
				},
				"cloudhsmv2": {
					id: "cloudhsmv2",
				},
				"cloudsearch": {
					id: "cloudsearch",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"cloudtrail-data": {
					id: "cloudtrail-data",
				},
				"codeartifact": {
					id: "codeartifact",
				},
				"codebuild": {
					id: "codebuild",
				},
				"codecatalyst": {
					id: "codecatalyst",
				},
				"codecommit": {
					id: "codecommit",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"codeguru-reviewer": {
					id: "codeguru-reviewer",
				},
				"codepipeline": {
					id: "codepipeline",
				},
				"codestar-connections": {
					id: "codestar-connections",
				},
				"codestar-notifications": {
					id: "codestar-notifications",
				},
				"cognito-identity": {
					id: "cognito-identity",
				},
				"cognito-idp": {
					id: "cognito-idp",
				},
				"cognito-sync": {
					id: "cognito-sync",
				},
				"comprehend": {
					id: "comprehend",
				},
				"comprehendmedical": {
					id: "comprehendmedical",
				},
				"compute-optimizer": {
					id: "compute-optimizer",
				},
				"config": {
					id: "config",
				},
				"connect": {
					id: "connect",
				},
				"connect-campaigns": {
					id: "connect-campaigns",
				},
				"contact-lens": {
					id: "contact-lens",
				},
				"controltower": {
					id: "controltower",
				},
				"cost-optimization-hub": {
					id: "cost-optimization-hub",
				},
				"cur": {
					id: "cur",
				},
				"data-ats.iot": {
					id: "data-ats.iot",
				},
				"data.iot": {
					id: "data.iot",
				},
				"data.jobs.iot": {
					id: "data.jobs.iot",
				},
				"data.mediastore": {
					id: "data.mediastore",
				},
				"databrew": {
					id: "databrew",
				},
				"dataexchange": {
					id: "dataexchange",
				},
				"datapipeline": {
					id: "datapipeline",
				},
				"datasync": {
					id: "datasync",
				},
				"datazone": {
					id: "datazone",
				},
				"dax": {
					id: "dax",
				},
				"devicefarm": {
					id: "devicefarm",
				},
				"devops-guru": {
					id: "devops-guru",
				},
				"directconnect": {
					id: "directconnect",
				},
				"discovery": {
					id: "discovery",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"docdb": {
					id: "docdb",
				},
				"drs": {
					id: "drs",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"edge.sagemaker": {
					id: "edge.sagemaker",
				},
				"eks": {
					id: "eks",
				},
				"eks-auth": {
					id: "eks-auth",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticbeanstalk": {
					id: "elasticbeanstalk",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"elastictranscoder": {
					id: "elastictranscoder",
				},
				"email": {
					id: "email",
				},
				"emr-containers": {
					id: "emr-containers",
				},
				"emr-serverless": {
					id: "emr-serverless",
				},
				"entitlement.marketplace": {
					id: "entitlement.marketplace",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"evidently": {
					id: "evidently",
				},
				"finspace": {
					id: "finspace",
				},
				"finspace-api": {
					id: "finspace-api",
				},
				"firehose": {
					id: "firehose",
				},
				"fms": {
					id: "fms",
				},
				"forecast": {
					id: "forecast",
				},
				"forecastquery": {
					id: "forecastquery",
				},
				"frauddetector": {
					id: "frauddetector",
				},
				"fsx": {
					id: "fsx",
				},
				"gamelift": {
					id: "gamelift",
				},
				"geo": {
					id: "geo",
				},
				"glacier": {
					id: "glacier",
				},
				"globalaccelerator": {
					id: "globalaccelerator",
				},
				"glue": {
					id: "glue",
				},
				"grafana": {
					id: "grafana",
				},
				"greengrass": {
					id: "greengrass",
				},
				"groundstation": {
					id: "groundstation",
				},
				"guardduty": {
					id: "guardduty",
				},
				"health": {
					id: "health",
				},
				"healthlake": {
					id: "healthlake",
				},
				"iam": {
					id: "iam",
				},
				"identity-chime": {
					id: "identity-chime",
				},
				"identitystore": {
					id: "identitystore",
				},
				"importexport": {
					id: "importexport",
				},
				"ingest.timestream": {
					id: "ingest.timestream",
				},
				"inspector": {
					id: "inspector",
				},
				"inspector2": {
					id: "inspector2",
				},
				"internetmonitor": {
					id: "internetmonitor",
				},
				"iot": {
					id: "iot",
				},
				"iotanalytics": {
					id: "iotanalytics",
				},
				"iotevents": {
					id: "iotevents",
				},
				"ioteventsdata": {
					id: "ioteventsdata",
				},
				"iotfleetwise": {
					id: "iotfleetwise",
				},
				"iotsecuredtunneling": {
					id: "iotsecuredtunneling",
				},
				"iotsitewise": {
					id: "iotsitewise",
				},
				"iotthingsgraph": {
					id: "iotthingsgraph",
				},
				"iottwinmaker": {
					id: "iottwinmaker",
				},
				"iotwireless": {
					id: "iotwireless",
				},
				"ivs": {
					id: "ivs",
				},
				"ivschat": {
					id: "ivschat",
				},
				"ivsrealtime": {
					id: "ivsrealtime",
				},
				"kafka": {
					id: "kafka",
				},
				"kafkaconnect": {
					id: "kafkaconnect",
				},
				"kendra": {
					id: "kendra",
				},
				"kendra-ranking": {
					id: "kendra-ranking",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kinesisanalytics": {
					id: "kinesisanalytics",
				},
				"kinesisvideo": {
					id: "kinesisvideo",
				},
				"kms": {
					id: "kms",
				},
				"lakeformation": {
					id: "lakeformation",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"license-manager-linux-subscriptions": {
					id: "license-manager-linux-subscriptions",
				},
				"license-manager-user-subscriptions": {
					id: "license-manager-user-subscriptions",
				},
				"lightsail": {
					id: "lightsail",
				},
				"logs": {
					id: "logs",
				},
				"lookoutequipment": {
					id: "lookoutequipment",
				},
				"lookoutmetrics": {
					id: "lookoutmetrics",
				},
				"lookoutvision": {
					id: "lookoutvision",
				},
				"m2": {
					id: "m2",
				},
				"machinelearning": {
					id: "machinelearning",
				},
				"macie2": {
					id: "macie2",
				},
				"managedblockchain": {
					id: "managedblockchain",
				},
				"managedblockchain-query": {
					id: "managedblockchain-query",
				},
				"marketplacecommerceanalytics": {
					id: "marketplacecommerceanalytics",
				},
				"media-pipelines-chime": {
					id: "media-pipelines-chime",
				},
				"mediaconnect": {
					id: "mediaconnect",
				},
				"mediaconvert": {
					id: "mediaconvert",
				},
				"medialive": {
					id: "medialive",
				},
				"mediapackage": {
					id: "mediapackage",
				},
				"mediapackage-vod": {
					id: "mediapackage-vod",
				},
				"mediapackagev2": {
					id: "mediapackagev2",
				},
				"mediastore": {
					id: "mediastore",
				},
				"meetings-chime": {
					id: "meetings-chime",
				},
				"memory-db": {
					id: "memory-db",
				},
				"messaging-chime": {
					id: "messaging-chime",
				},
				"metering.marketplace": {
					id: "metering.marketplace",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"mgh": {
					id: "mgh",
				},
				"mgn": {
					id: "mgn",
				},
				"migrationhub-orchestrator": {
					id: "migrationhub-orchestrator",
				},
				"migrationhub-strategy": {
					id: "migrationhub-strategy",
				},
				"mobileanalytics": {
					id: "mobileanalytics",
				},
				"models-v2-lex": {
					id: "models-v2-lex",
				},
				"models.lex": {
					id: "models.lex",
				},
				"monitoring": {
					id: "monitoring",
				},
				"mq": {
					id: "mq",
				},
				"mturk-requester": {
					id: "mturk-requester",
				},
				"neptune": {
					id: "neptune",
				},
				"network-firewall": {
					id: "network-firewall",
				},
				"networkmanager": {
					id: "networkmanager",
				},
				"notifications": {
					id: "notifications",
				},
				"notifications-contacts": {
					id: "notifications-contacts",
				},
				"oam": {
					id: "oam",
				},
				"oidc": {
					id: "oidc",
				},
				"omics": {
					id: "omics",
				},
				"opsworks": {
					id: "opsworks",
				},
				"opsworks-cm": {
					id: "opsworks-cm",
				},
				"organizations": {
					id: "organizations",
				},
				"osis": {
					id: "osis",
				},
				"outposts": {
					id: "outposts",
				},
				"participant.connect": {
					id: "participant.connect",
				},
				"personalize": {
					id: "personalize",
				},
				"pi": {
					id: "pi",
				},
				"pinpoint": {
					id: "pinpoint",
				},
				"pipes": {
					id: "pipes",
				},
				"polly": {
					id: "polly",
				},
				"portal.sso": {
					id: "portal.sso",
				},
				"private-networks": {
					id: "private-networks",
				},
				"profile": {
					id: "profile",
				},
				"proton": {
					id: "proton",
				},
				"qbusiness": {
					id: "qbusiness",
				},
				"qldb": {
					id: "qldb",
				},
				"quicksight": {
					id: "quicksight",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"rds-data": {
					id: "rds-data",
				},
				"redshift": {
					id: "redshift",
				},
				"redshift-serverless": {
					id: "redshift-serverless",
				},
				"rekognition": {
					id: "rekognition",
				},
				"resiliencehub": {
					id: "resiliencehub",
				},
				"resource-explorer-2": {
					id: "resource-explorer-2",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"robomaker": {
					id: "robomaker",
				},
				"rolesanywhere": {
					id: "rolesanywhere",
				},
				"route53": {
					id: "route53",
				},
				"route53-recovery-control-config": {
					id: "route53-recovery-control-config",
				},
				"route53domains": {
					id: "route53domains",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"rum": {
					id: "rum",
				},
				"runtime-v2-lex": {
					id: "runtime-v2-lex",
				},
				"runtime.lex": {
					id: "runtime.lex",
				},
				"runtime.sagemaker": {
					id: "runtime.sagemaker",
				},
				"s3": {
					id: "s3",
				},
				"s3-control": {
					id: "s3-control",
				},
				"s3-outposts": {
					id: "s3-outposts",
				},
				"sagemaker-geospatial": {
					id: "sagemaker-geospatial",
				},
				"savingsplans": {
					id: "savingsplans",
				},
				"scheduler": {
					id: "scheduler",
				},
				"schemas": {
					id: "schemas",
				},
				"sdb": {
					id: "sdb",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"securityhub": {
					id: "securityhub",
				},
				"securitylake": {
					id: "securitylake",
				},
				"serverlessrepo": {
					id: "serverlessrepo",
				},
				"servicecatalog": {
					id: "servicecatalog",
				},
				"servicecatalog-appregistry": {
					id: "servicecatalog-appregistry",
				},
				"servicediscovery": {
					id: "servicediscovery",
				},
				"servicequotas": {
					id: "servicequotas",
				},
				"session.qldb": {
					id: "session.qldb",
				},
				"shield": {
					id: "shield",
				},
				"signer": {
					id: "signer",
				},
				"simspaceweaver": {
					id: "simspaceweaver",
				},
				"sms": {
					id: "sms",
				},
				"sms-voice": {
					id: "sms-voice",
				},
				"snowball": {
					id: "snowball",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"ssm-contacts": {
					id: "ssm-contacts",
				},
				"ssm-incidents": {
					id: "ssm-incidents",
				},
				"ssm-quicksetup": {
					id: "ssm-quicksetup",
				},
				"ssm-sap": {
					id: "ssm-sap",
				},
				"sso": {
					id: "sso",
				},
				"states": {
					id: "states",
				},
				"storagegateway": {
					id: "storagegateway",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"support": {
					id: "support",
				},
				"supportapp": {
					id: "supportapp",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"tax": {
					id: "tax",
				},
				"textract": {
					id: "textract",
				},
				"thinclient": {
					id: "thinclient",
				},
				"tnb": {
					id: "tnb",
				},
				"transcribe": {
					id: "transcribe",
				},
				"transcribestreaming": {
					id: "transcribestreaming",
				},
				"transfer": {
					id: "transfer",
				},
				"translate": {
					id: "translate",
				},
				"trustedadvisor": {
					id: "trustedadvisor",
				},
				"verifiedpermissions": {
					id: "verifiedpermissions",
				},
				"voice-chime": {
					id: "voice-chime",
				},
				"voiceid": {
					id: "voiceid",
				},
				"vpc-lattice": {
					id: "vpc-lattice",
				},
				"waf": {
					id: "waf",
				},
				"waf-regional": {
					id: "waf-regional",
				},
				"wafv2": {
					id: "wafv2",
				},
				"wellarchitected": {
					id: "wellarchitected",
				},
				"wisdom": {
					id: "wisdom",
				},
				"workdocs": {
					id: "workdocs",
				},
				"workmail": {
					id: "workmail",
				},
				"workspaces": {
					id: "workspaces",
				},
				"workspaces-web": {
					id: "workspaces-web",
				},
				"xray": {
					id: "xray",
				},
			},
		},
		AwsCnPartitionID: {
			id:          AwsCnPartitionID,
			name:        "AWS China",
			dnsSuffix:   "amazonaws.com.cn",
			regionRegex: regexp.MustCompile(`^cn\-\w+\-\d+$`),
			regions: map[string]Region{
				CnNorth1RegionID: {
					id:          CnNorth1RegionID,
					description: "China (Beijing)",
				},
				CnNorthwest1RegionID: {
					id:          CnNorthwest1RegionID,
					description: "China (Ningxia)",
				},
			},
			services: map[string]Service{
				"access-analyzer": {
					id: "access-analyzer",
				},
				"account": {
					id: "account",
				},
				"acm": {
					id: "acm",
				},
				"acm-pca": {
					id: "acm-pca",
				},
				"airflow": {
					id: "airflow",
				},
				"api.ecr": {
					id: "api.ecr",
				},
				"api.pricing": {
					id: "api.pricing",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"api.tunneling.iot": {
					id: "api.tunneling.iot",
				},
				"apigateway": {
					id: "apigateway",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"applicationinsights": {
					id: "applicationinsights",
				},
				"appmesh": {
					id: "appmesh",
				},
				"appsync": {
					id: "appsync",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"athena": {
					id: "athena",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"autoscaling-plans": {
					id: "autoscaling-plans",
				},
				"backup": {
					id: "backup",
				},
				"batch": {
					id: "batch",
				},
				"budgets": {
					id: "budgets",
				},
				"cassandra": {
					id: "cassandra",
				},
				"ce": {
					id: "ce",
				},
				"cloudcontrolapi": {
					id: "cloudcontrolapi",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudfront": {
					id: "cloudfront",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"codebuild": {
					id: "codebuild",
				},
				"codecommit": {
					id: "codecommit",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"codepipeline": {
					id: "codepipeline",
				},
				"cognito-identity": {
					id: "cognito-identity",
				},
				"compute-optimizer": {
					id: "compute-optimizer",
				},
				"config": {
					id: "config",
				},
				"cur": {
					id: "cur",
				},
				"data-ats.iot": {
					id: "data-ats.iot",
				},
				"data.iot": {
					id: "data.iot",
				},
				"data.jobs.iot": {
					id: "data.jobs.iot",
				},
				"databrew": {
					id: "databrew",
				},
				"datasync": {
					id: "datasync",
				},
				"datazone": {
					id: "datazone",
				},
				"dax": {
					id: "dax",
				},
				"directconnect": {
					id: "directconnect",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"docdb": {
					id: "docdb",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"eks": {
					id: "eks",
				},
				"eks-auth": {
					id: "eks-auth",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticbeanstalk": {
					id: "elasticbeanstalk",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"emr-containers": {
					id: "emr-containers",
				},
				"emr-serverless": {
					id: "emr-serverless",
				},
				"entitlement.marketplace": {
					id: "entitlement.marketplace",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"firehose": {
					id: "firehose",
				},
				"fms": {
					id: "fms",
				},
				"fsx": {
					id: "fsx",
				},
				"gamelift": {
					id: "gamelift",
				},
				"glacier": {
					id: "glacier",
				},
				"glue": {
					id: "glue",
				},
				"greengrass": {
					id: "greengrass",
				},
				"guardduty": {
					id: "guardduty",
				},
				"health": {
					id: "health",
				},
				"iam": {
					id: "iam",
				},
				"identitystore": {
					id: "identitystore",
				},
				"inspector2": {
					id: "inspector2",
				},
				"internetmonitor": {
					id: "internetmonitor",
				},
				"iot": {
					id: "iot",
				},
				"iotanalytics": {
					id: "iotanalytics",
				},
				"iotevents": {
					id: "iotevents",
				},
				"ioteventsdata": {
					id: "ioteventsdata",
				},
				"iotsecuredtunneling": {
					id: "iotsecuredtunneling",
				},
				"iotsitewise": {
					id: "iotsitewise",
				},
				"iottwinmaker": {
					id: "iottwinmaker",
				},
				"kafka": {
					id: "kafka",
				},
				"kendra-ranking": {
					id: "kendra-ranking",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kinesisanalytics": {
					id: "kinesisanalytics",
				},
				"kinesisvideo": {
					id: "kinesisvideo",
				},
				"kms": {
					id: "kms",
				},
				"lakeformation": {
					id: "lakeformation",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"license-manager-linux-subscriptions": {
					id: "license-manager-linux-subscriptions",
				},
				"logs": {
					id: "logs",
				},
				"mediaconvert": {
					id: "mediaconvert",
				},
				"memory-db": {
					id: "memory-db",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"monitoring": {
					id: "monitoring",
				},
				"mq": {
					id: "mq",
				},
				"neptune": {
					id: "neptune",
				},
				"network-firewall": {
					id: "network-firewall",
				},
				"notifications": {
					id: "notifications",
				},
				"oam": {
					id: "oam",
				},
				"oidc": {
					id: "oidc",
				},
				"organizations": {
					id: "organizations",
				},
				"personalize": {
					id: "personalize",
				},
				"pi": {
					id: "pi",
				},
				"pipes": {
					id: "pipes",
				},
				"polly": {
					id: "polly",
				},
				"portal.sso": {
					id: "portal.sso",
				},
				"qbusiness": {
					id: "qbusiness",
				},
				"quicksight": {
					id: "quicksight",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"redshift": {
					id: "redshift",
				},
				"redshift-serverless": {
					id: "redshift-serverless",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"rolesanywhere": {
					id: "rolesanywhere",
				},
				"route53": {
					id: "route53",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"runtime.sagemaker": {
					id: "runtime.sagemaker",
				},
				"s3": {
					id: "s3",
				},
				"s3-control": {
					id: "s3-control",
				},
				"savingsplans": {
					id: "savingsplans",
				},
				"schemas": {
					id: "schemas",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"securityhub": {
					id: "securityhub",
				},
				"serverlessrepo": {
					id: "serverlessrepo",
				},
				"servicecatalog": {
					id: "servicecatalog",
				},
				"servicediscovery": {
					id: "servicediscovery",
				},
				"servicequotas": {
					id: "servicequotas",
				},
				"signer": {
					id: "signer",
				},
				"sms": {
					id: "sms",
				},
				"snowball": {
					id: "snowball",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"sso": {
					id: "sso",
				},
				"states": {
					id: "states",
				},
				"storagegateway": {
					id: "storagegateway",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"support": {
					id: "support",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"transcribe": {
					id: "transcribe",
				},
				"transcribestreaming": {
					id: "transcribestreaming",
				},
				"transfer": {
					id: "transfer",
				},
				"waf-regional": {
					id: "waf-regional",
				},
				"wafv2": {
					id: "wafv2",
				},
				"workspaces": {
					id: "workspaces",
				},
				"xray": {
					id: "xray",
				},
			},
		},
		AwsIsoPartitionID: {
			id:          AwsIsoPartitionID,
			name:        "AWS ISO (US)",
			dnsSuffix:   "c2s.ic.gov",
			regionRegex: regexp.MustCompile(`^us\-iso\-\w+\-\d+$`),
			regions: map[string]Region{
				UsIsoEast1RegionID: {
					id:          UsIsoEast1RegionID,
					description: "US ISO East",
				},
				UsIsoWest1RegionID: {
					id:          UsIsoWest1RegionID,
					description: "US ISO WEST",
				},
			},
			services: map[string]Service{
				"agreement-marketplace": {
					id: "agreement-marketplace",
				},
				"api.ecr": {
					id: "api.ecr",
				},
				"api.pricing": {
					id: "api.pricing",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"apigateway": {
					id: "apigateway",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"athena": {
					id: "athena",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"bedrock": {
					id: "bedrock",
				},
				"budgets": {
					id: "budgets",
				},
				"cloudcontrolapi": {
					id: "cloudcontrolapi",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"codebuild": {
					id: "codebuild",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"comprehend": {
					id: "comprehend",
				},
				"config": {
					id: "config",
				},
				"datapipeline": {
					id: "datapipeline",
				},
				"datasync": {
					id: "datasync",
				},
				"directconnect": {
					id: "directconnect",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"eks": {
					id: "eks",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"firehose": {
					id: "firehose",
				},
				"fsx": {
					id: "fsx",
				},
				"glacier": {
					id: "glacier",
				},
				"glue": {
					id: "glue",
				},
				"guardduty": {
					id: "guardduty",
				},
				"health": {
					id: "health",
				},
				"iam": {
					id: "iam",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kms": {
					id: "kms",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"logs": {
					id: "logs",
				},
				"medialive": {
					id: "medialive",
				},
				"mediapackage": {
					id: "mediapackage",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"monitoring": {
					id: "monitoring",
				},
				"oam": {
					id: "oam",
				},
				"organizations": {
					id: "organizations",
				},
				"outposts": {
					id: "outposts",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"redshift": {
					id: "redshift",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"route53": {
					id: "route53",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"runtime.sagemaker": {
					id: "runtime.sagemaker",
				},
				"s3": {
					id: "s3",
				},
				"s3-control": {
					id: "s3-control",
				},
				"s3-outposts": {
					id: "s3-outposts",
				},
				"scheduler": {
					id: "scheduler",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"snowball": {
					id: "snowball",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"states": {
					id: "states",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"support": {
					id: "support",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"textract": {
					id: "textract",
				},
				"transcribe": {
					id: "transcribe",
				},
				"transcribestreaming": {
					id: "transcribestreaming",
				},
				"translate": {
					id: "translate",
				},
				"workspaces": {
					id: "workspaces",
				},
			},
		},
		AwsIsoBPartitionID: {
			id:          AwsIsoBPartitionID,
			name:        "AWS ISOB (US)",
			dnsSuffix:   "sc2s.sgov.gov",
			regionRegex: regexp.MustCompile(`^us\-isob\-\w+\-\d+$`),
			regions: map[string]Region{
				UsIsobEast1RegionID: {
					id:          UsIsobEast1RegionID,
					description: "US ISOB East (Ohio)",
				},
			},
			services: map[string]Service{
				"api.ecr": {
					id: "api.ecr",
				},
				"api.pricing": {
					id: "api.pricing",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"apigateway": {
					id: "apigateway",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"budgets": {
					id: "budgets",
				},
				"cloudcontrolapi": {
					id: "cloudcontrolapi",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"config": {
					id: "config",
				},
				"directconnect": {
					id: "directconnect",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"eks": {
					id: "eks",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"firehose": {
					id: "firehose",
				},
				"glacier": {
					id: "glacier",
				},
				"health": {
					id: "health",
				},
				"iam": {
					id: "iam",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kms": {
					id: "kms",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"logs": {
					id: "logs",
				},
				"medialive": {
					id: "medialive",
				},
				"mediapackage": {
					id: "mediapackage",
				},
				"metering.marketplace": {
					id: "metering.marketplace",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"monitoring": {
					id: "monitoring",
				},
				"oam": {
					id: "oam",
				},
				"organizations": {
					id: "organizations",
				},
				"outposts": {
					id: "outposts",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"redshift": {
					id: "redshift",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"route53": {
					id: "route53",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"runtime.sagemaker": {
					id: "runtime.sagemaker",
				},
				"s3": {
					id: "s3",
				},
				"s3-control": {
					id: "s3-control",
				},
				"s3-outposts": {
					id: "s3-outposts",
				},
				"scheduler": {
					id: "scheduler",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"snowball": {
					id: "snowball",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"states": {
					id: "states",
				},
				"storagegateway": {
					id: "storagegateway",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"support": {
					id: "support",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"workspaces": {
					id: "workspaces",
				},
				"xray": {
					id: "xray",
				},
			},
		},
		AwsIsoEPartitionID: {
			id:          AwsIsoEPartitionID,
			name:        "AWS ISOE (Europe)",
			dnsSuffix:   "cloud.adc-e.uk",
			regionRegex: regexp.MustCompile(`^eu\-isoe\-\w+\-\d+$`),
			regions: map[string]Region{
				EuIsoeWest1RegionID: {
					id:          EuIsoeWest1RegionID,
					description: "EU ISOE West",
				},
			},
			services: map[string]Service{},
		},
		AwsIsoFPartitionID: {
			id:          AwsIsoFPartitionID,
			name:        "AWS ISOF",
			dnsSuffix:   "csp.hci.ic.gov",
			regionRegex: regexp.MustCompile(`^us\-isof\-\w+\-\d+$`),
			regions: map[string]Region{
				UsIsofEast1RegionID: {
					id:          UsIsofEast1RegionID,
					description: "US ISOF EAST",
				},
				UsIsofSouth1RegionID: {
					id:          UsIsofSouth1RegionID,
					description: "US ISOF SOUTH",
				},
			},
			services: map[string]Service{
				"access-analyzer": {
					id: "access-analyzer",
				},
				"acm": {
					id: "acm",
				},
				"acm-pca": {
					id: "acm-pca",
				},
				"api.ecr": {
					id: "api.ecr",
				},
				"api.pricing": {
					id: "api.pricing",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"athena": {
					id: "athena",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"backup": {
					id: "backup",
				},
				"batch": {
					id: "batch",
				},
				"budgets": {
					id: "budgets",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"codebuild": {
					id: "codebuild",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"codepipeline": {
					id: "codepipeline",
				},
				"comprehend": {
					id: "comprehend",
				},
				"compute-optimizer": {
					id: "compute-optimizer",
				},
				"config": {
					id: "config",
				},
				"cost-optimization-hub": {
					id: "cost-optimization-hub",
				},
				"directconnect": {
					id: "directconnect",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"eks": {
					id: "eks",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"firehose": {
					id: "firehose",
				},
				"fsx": {
					id: "fsx",
				},
				"glue": {
					id: "glue",
				},
				"guardduty": {
					id: "guardduty",
				},
				"iam": {
					id: "iam",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kms": {
					id: "kms",
				},
				"lakeformation": {
					id: "lakeformation",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"logs": {
					id: "logs",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"monitoring": {
					id: "monitoring",
				},
				"oam": {
					id: "oam",
				},
				"organizations": {
					id: "organizations",
				},
				"pi": {
					id: "pi",
				},
				"pipes": {
					id: "pipes",
				},
				"quicksight": {
					id: "quicksight",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"redshift": {
					id: "redshift",
				},
				"redshift-serverless": {
					id: "redshift-serverless",
				},
				"rekognition": {
					id: "rekognition",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"route53": {
					id: "route53",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"s3": {
					id: "s3",
				},
				"savingsplans": {
					id: "savingsplans",
				},
				"scheduler": {
					id: "scheduler",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"servicediscovery": {
					id: "servicediscovery",
				},
				"servicequotas": {
					id: "servicequotas",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"states": {
					id: "states",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"textract": {
					id: "textract",
				},
				"transcribe": {
					id: "transcribe",
				},
				"transcribestreaming": {
					id: "transcribestreaming",
				},
				"translate": {
					id: "translate",
				},
				"xray": {
					id: "xray",
				},
			},
		},
		AwsUsGovPartitionID: {
			id:          AwsUsGovPartitionID,
			name:        "AWS GovCloud (US)",
			dnsSuffix:   "amazonaws.com",
			regionRegex: regexp.MustCompile(`^us\-gov\-\w+\-\d+$`),
			regions: map[string]Region{
				UsGovEast1RegionID: {
					id:          UsGovEast1RegionID,
					description: "AWS GovCloud (US-East)",
				},
				UsGovWest1RegionID: {
					id:          UsGovWest1RegionID,
					description: "AWS GovCloud (US-West)",
				},
			},
			services: map[string]Service{
				"access-analyzer": {
					id: "access-analyzer",
				},
				"acm": {
					id: "acm",
				},
				"acm-pca": {
					id: "acm-pca",
				},
				"aoss": {
					id: "aoss",
				},
				"api.detective": {
					id: "api.detective",
				},
				"api.ecr": {
					id: "api.ecr",
				},
				"api.sagemaker": {
					id: "api.sagemaker",
				},
				"api.tunneling.iot": {
					id: "api.tunneling.iot",
				},
				"apigateway": {
					id: "apigateway",
				},
				"appconfig": {
					id: "appconfig",
				},
				"appconfigdata": {
					id: "appconfigdata",
				},
				"application-autoscaling": {
					id: "application-autoscaling",
				},
				"applicationinsights": {
					id: "applicationinsights",
				},
				"appstream2": {
					id: "appstream2",
				},
				"arc-zonal-shift": {
					id: "arc-zonal-shift",
				},
				"athena": {
					id: "athena",
				},
				"autoscaling": {
					id: "autoscaling",
				},
				"autoscaling-plans": {
					id: "autoscaling-plans",
				},
				"backup": {
					id: "backup",
				},
				"backup-gateway": {
					id: "backup-gateway",
				},
				"batch": {
					id: "batch",
				},
				"bedrock": {
					id: "bedrock",
				},
				"cassandra": {
					id: "cassandra",
				},
				"cloudcontrolapi": {
					id: "cloudcontrolapi",
				},
				"clouddirectory": {
					id: "clouddirectory",
				},
				"cloudformation": {
					id: "cloudformation",
				},
				"cloudhsm": {
					id: "cloudhsm",
				},
				"cloudhsmv2": {
					id: "cloudhsmv2",
				},
				"cloudtrail": {
					id: "cloudtrail",
				},
				"codebuild": {
					id: "codebuild",
				},
				"codecommit": {
					id: "codecommit",
				},
				"codedeploy": {
					id: "codedeploy",
				},
				"codepipeline": {
					id: "codepipeline",
				},
				"codestar-connections": {
					id: "codestar-connections",
				},
				"cognito-identity": {
					id: "cognito-identity",
				},
				"cognito-idp": {
					id: "cognito-idp",
				},
				"comprehend": {
					id: "comprehend",
				},
				"comprehendmedical": {
					id: "comprehendmedical",
				},
				"compute-optimizer": {
					id: "compute-optimizer",
				},
				"config": {
					id: "config",
				},
				"connect": {
					id: "connect",
				},
				"controltower": {
					id: "controltower",
				},
				"data-ats.iot": {
					id: "data-ats.iot",
				},
				"data.iot": {
					id: "data.iot",
				},
				"data.jobs.iot": {
					id: "data.jobs.iot",
				},
				"databrew": {
					id: "databrew",
				},
				"datasync": {
					id: "datasync",
				},
				"datazone": {
					id: "datazone",
				},
				"directconnect": {
					id: "directconnect",
				},
				"dlm": {
					id: "dlm",
				},
				"dms": {
					id: "dms",
				},
				"docdb": {
					id: "docdb",
				},
				"drs": {
					id: "drs",
				},
				"ds": {
					id: "ds",
				},
				"dynamodb": {
					id: "dynamodb",
				},
				"ebs": {
					id: "ebs",
				},
				"ec2": {
					id: "ec2",
				},
				"ecs": {
					id: "ecs",
				},
				"eks": {
					id: "eks",
				},
				"eks-auth": {
					id: "eks-auth",
				},
				"elasticache": {
					id: "elasticache",
				},
				"elasticbeanstalk": {
					id: "elasticbeanstalk",
				},
				"elasticfilesystem": {
					id: "elasticfilesystem",
				},
				"elasticloadbalancing": {
					id: "elasticloadbalancing",
				},
				"elasticmapreduce": {
					id: "elasticmapreduce",
				},
				"email": {
					id: "email",
				},
				"emr-containers": {
					id: "emr-containers",
				},
				"emr-serverless": {
					id: "emr-serverless",
				},
				"es": {
					id: "es",
				},
				"events": {
					id: "events",
				},
				"firehose": {
					id: "firehose",
				},
				"fms": {
					id: "fms",
				},
				"fsx": {
					id: "fsx",
				},
				"geo": {
					id: "geo",
				},
				"glacier": {
					id: "glacier",
				},
				"glue": {
					id: "glue",
				},
				"greengrass": {
					id: "greengrass",
				},
				"guardduty": {
					id: "guardduty",
				},
				"health": {
					id: "health",
				},
				"iam": {
					id: "iam",
				},
				"identitystore": {
					id: "identitystore",
				},
				"ingest.timestream": {
					id: "ingest.timestream",
				},
				"inspector": {
					id: "inspector",
				},
				"inspector2": {
					id: "inspector2",
				},
				"internetmonitor": {
					id: "internetmonitor",
				},
				"iot": {
					id: "iot",
				},
				"iotevents": {
					id: "iotevents",
				},
				"ioteventsdata": {
					id: "ioteventsdata",
				},
				"iotsecuredtunneling": {
					id: "iotsecuredtunneling",
				},
				"iotsitewise": {
					id: "iotsitewise",
				},
				"iottwinmaker": {
					id: "iottwinmaker",
				},
				"kafka": {
					id: "kafka",
				},
				"kendra": {
					id: "kendra",
				},
				"kendra-ranking": {
					id: "kendra-ranking",
				},
				"kinesis": {
					id: "kinesis",
				},
				"kinesisanalytics": {
					id: "kinesisanalytics",
				},
				"kinesisvideo": {
					id: "kinesisvideo",
				},
				"kms": {
					id: "kms",
				},
				"lakeformation": {
					id: "lakeformation",
				},
				"lambda": {
					id: "lambda",
				},
				"license-manager": {
					id: "license-manager",
				},
				"license-manager-linux-subscriptions": {
					id: "license-manager-linux-subscriptions",
				},
				"license-manager-user-subscriptions": {
					id: "license-manager-user-subscriptions",
				},
				"logs": {
					id: "logs",
				},
				"m2": {
					id: "m2",
				},
				"managedblockchain": {
					id: "managedblockchain",
				},
				"mediaconvert": {
					id: "mediaconvert",
				},
				"meetings-chime": {
					id: "meetings-chime",
				},
				"memory-db": {
					id: "memory-db",
				},
				"metering.marketplace": {
					id: "metering.marketplace",
				},
				"metrics.sagemaker": {
					id: "metrics.sagemaker",
				},
				"mgn": {
					id: "mgn",
				},
				"models-v2-lex": {
					id: "models-v2-lex",
				},
				"models.lex": {
					id: "models.lex",
				},
				"monitoring": {
					id: "monitoring",
				},
				"mq": {
					id: "mq",
				},
				"neptune": {
					id: "neptune",
				},
				"network-firewall": {
					id: "network-firewall",
				},
				"networkmanager": {
					id: "networkmanager",
				},
				"notifications": {
					id: "notifications",
				},
				"oam": {
					id: "oam",
				},
				"oidc": {
					id: "oidc",
				},
				"organizations": {
					id: "organizations",
				},
				"outposts": {
					id: "outposts",
				},
				"participant.connect": {
					id: "participant.connect",
				},
				"pi": {
					id: "pi",
				},
				"pinpoint": {
					id: "pinpoint",
				},
				"polly": {
					id: "polly",
				},
				"portal.sso": {
					id: "portal.sso",
				},
				"qbusiness": {
					id: "qbusiness",
				},
				"quicksight": {
					id: "quicksight",
				},
				"ram": {
					id: "ram",
				},
				"rbin": {
					id: "rbin",
				},
				"rds": {
					id: "rds",
				},
				"redshift": {
					id: "redshift",
				},
				"redshift-serverless": {
					id: "redshift-serverless",
				},
				"rekognition": {
					id: "rekognition",
				},
				"resiliencehub": {
					id: "resiliencehub",
				},
				"resource-groups": {
					id: "resource-groups",
				},
				"robomaker": {
					id: "robomaker",
				},
				"rolesanywhere": {
					id: "rolesanywhere",
				},
				"route53": {
					id: "route53",
				},
				"route53resolver": {
					id: "route53resolver",
				},
				"runtime-v2-lex": {
					id: "runtime-v2-lex",
				},
				"runtime.lex": {
					id: "runtime.lex",
				},
				"runtime.sagemaker": {
					id: "runtime.sagemaker",
				},
				"s3": {
					id: "s3",
				},
				"s3-control": {
					id: "s3-control",
				},
				"s3-outposts": {
					id: "s3-outposts",
				},
				"schemas": {
					id: "schemas",
				},
				"secretsmanager": {
					id: "secretsmanager",
				},
				"securityhub": {
					id: "securityhub",
				},
				"securitylake": {
					id: "securitylake",
				},
				"serverlessrepo": {
					id: "serverlessrepo",
				},
				"servicecatalog": {
					id: "servicecatalog",
				},
				"servicecatalog-appregistry": {
					id: "servicecatalog-appregistry",
				},
				"servicediscovery": {
					id: "servicediscovery",
				},
				"servicequotas": {
					id: "servicequotas",
				},
				"signer": {
					id: "signer",
				},
				"simspaceweaver": {
					id: "simspaceweaver",
				},
				"sms": {
					id: "sms",
				},
				"sms-voice": {
					id: "sms-voice",
				},
				"snowball": {
					id: "snowball",
				},
				"sns": {
					id: "sns",
				},
				"sqs": {
					id: "sqs",
				},
				"ssm": {
					id: "ssm",
				},
				"sso": {
					id: "sso",
				},
				"states": {
					id: "states",
				},
				"storagegateway": {
					id: "storagegateway",
				},
				"streams.dynamodb": {
					id: "streams.dynamodb",
				},
				"sts": {
					id: "sts",
				},
				"support": {
					id: "support",
				},
				"swf": {
					id: "swf",
				},
				"synthetics": {
					id: "synthetics",
				},
				"tagging": {
					id: "tagging",
				},
				"textract": {
					id: "textract",
				},
				"transcribe": {
					id: "transcribe",
				},
				"transcribestreaming": {
					id: "transcribestreaming",
				},
				"transfer": {
					id: "transfer",
				},
				"translate": {
					id: "translate",
				},
				"verifiedpermissions": {
					id: "verifiedpermissions",
				},
				"waf-regional": {
					id: "waf-regional",
				},
				"wafv2": {
					id: "wafv2",
				},
				"wellarchitected": {
					id: "wellarchitected",
				},
				"workspaces": {
					id: "workspaces",
				},
				"xray": {
					id: "xray",
				},
			},
		},
	}
)
