package permissions

import (
	"fmt"

	"github.com/hashicorp/go-azure-sdk/sdk/client/resourcemanager"
	sdkEnv "github.com/hashicorp/go-azure-sdk/sdk/environments"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type PermissionsClient struct {
	Client *resourcemanager.Client
}

func NewPermissionsClientWithBaseURI(sdkApi sdkEnv.Api) (*PermissionsClient, error) {
	client, err := resourcemanager.NewClient(sdkApi, "permissions", defaultApiVersion)
	if err != nil {
		return nil, fmt.Errorf("instantiating PermissionsClient: %+v", err)
	}

	return &PermissionsClient{
		Client: client,
	}, nil
}
