package activity

import (
	"time"

	"github.com/hashicorp/go-azure-helpers/lang/dates"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type ActivityProperties struct {
	CreationTime     *string                 `json:"creationTime,omitempty"`
	Definition       *string                 `json:"definition,omitempty"`
	Description      *string                 `json:"description,omitempty"`
	LastModifiedTime *string                 `json:"lastModifiedTime,omitempty"`
	OutputTypes      *[]ActivityOutputType   `json:"outputTypes,omitempty"`
	ParameterSets    *[]ActivityParameterSet `json:"parameterSets,omitempty"`
}

func (o *ActivityProperties) GetCreationTimeAsTime() (*time.Time, error) {
	if o.CreationTime == nil {
		return nil, nil
	}
	return dates.ParseAsFormat(o.CreationTime, "2006-01-02T15:04:05Z07:00")
}

func (o *ActivityProperties) SetCreationTimeAsTime(input time.Time) {
	formatted := input.Format("2006-01-02T15:04:05Z07:00")
	o.CreationTime = &formatted
}

func (o *ActivityProperties) GetLastModifiedTimeAsTime() (*time.Time, error) {
	if o.LastModifiedTime == nil {
		return nil, nil
	}
	return dates.ParseAsFormat(o.LastModifiedTime, "2006-01-02T15:04:05Z07:00")
}

func (o *ActivityProperties) SetLastModifiedTimeAsTime(input time.Time) {
	formatted := input.Format("2006-01-02T15:04:05Z07:00")
	o.LastModifiedTime = &formatted
}
