// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0-devel
// 	protoc        v3.12.2
// source: google/cloud/aiplatform/v1beta1/model_monitoring.proto

package aiplatform

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Next ID: 6
type ModelMonitoringObjectiveConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Training dataset for models. This field has to be set only if
	// TrainingPredictionSkewDetectionConfig is specified.
	TrainingDataset *ModelMonitoringObjectiveConfig_TrainingDataset `protobuf:"bytes,1,opt,name=training_dataset,json=trainingDataset,proto3" json:"training_dataset,omitempty"`
	// The config for skew between training data and prediction data.
	TrainingPredictionSkewDetectionConfig *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig `protobuf:"bytes,2,opt,name=training_prediction_skew_detection_config,json=trainingPredictionSkewDetectionConfig,proto3" json:"training_prediction_skew_detection_config,omitempty"`
	// The config for drift of prediction data.
	PredictionDriftDetectionConfig *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig `protobuf:"bytes,3,opt,name=prediction_drift_detection_config,json=predictionDriftDetectionConfig,proto3" json:"prediction_drift_detection_config,omitempty"`
}

func (x *ModelMonitoringObjectiveConfig) Reset() {
	*x = ModelMonitoringObjectiveConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveConfig) ProtoMessage() {}

func (x *ModelMonitoringObjectiveConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{0}
}

func (x *ModelMonitoringObjectiveConfig) GetTrainingDataset() *ModelMonitoringObjectiveConfig_TrainingDataset {
	if x != nil {
		return x.TrainingDataset
	}
	return nil
}

func (x *ModelMonitoringObjectiveConfig) GetTrainingPredictionSkewDetectionConfig() *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig {
	if x != nil {
		return x.TrainingPredictionSkewDetectionConfig
	}
	return nil
}

func (x *ModelMonitoringObjectiveConfig) GetPredictionDriftDetectionConfig() *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig {
	if x != nil {
		return x.PredictionDriftDetectionConfig
	}
	return nil
}

// Next ID: 2
type ModelMonitoringAlertConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Alert:
	//	*ModelMonitoringAlertConfig_EmailAlertConfig_
	Alert isModelMonitoringAlertConfig_Alert `protobuf_oneof:"alert"`
}

func (x *ModelMonitoringAlertConfig) Reset() {
	*x = ModelMonitoringAlertConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringAlertConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringAlertConfig) ProtoMessage() {}

func (x *ModelMonitoringAlertConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringAlertConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringAlertConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{1}
}

func (m *ModelMonitoringAlertConfig) GetAlert() isModelMonitoringAlertConfig_Alert {
	if m != nil {
		return m.Alert
	}
	return nil
}

func (x *ModelMonitoringAlertConfig) GetEmailAlertConfig() *ModelMonitoringAlertConfig_EmailAlertConfig {
	if x, ok := x.GetAlert().(*ModelMonitoringAlertConfig_EmailAlertConfig_); ok {
		return x.EmailAlertConfig
	}
	return nil
}

type isModelMonitoringAlertConfig_Alert interface {
	isModelMonitoringAlertConfig_Alert()
}

type ModelMonitoringAlertConfig_EmailAlertConfig_ struct {
	// Email alert config.
	EmailAlertConfig *ModelMonitoringAlertConfig_EmailAlertConfig `protobuf:"bytes,1,opt,name=email_alert_config,json=emailAlertConfig,proto3,oneof"`
}

func (*ModelMonitoringAlertConfig_EmailAlertConfig_) isModelMonitoringAlertConfig_Alert() {}

// The config for feature monitoring threshold.
// Next ID: 3
type ThresholdConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Threshold:
	//	*ThresholdConfig_Value
	Threshold isThresholdConfig_Threshold `protobuf_oneof:"threshold"`
}

func (x *ThresholdConfig) Reset() {
	*x = ThresholdConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ThresholdConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ThresholdConfig) ProtoMessage() {}

func (x *ThresholdConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ThresholdConfig.ProtoReflect.Descriptor instead.
func (*ThresholdConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{2}
}

func (m *ThresholdConfig) GetThreshold() isThresholdConfig_Threshold {
	if m != nil {
		return m.Threshold
	}
	return nil
}

func (x *ThresholdConfig) GetValue() float64 {
	if x, ok := x.GetThreshold().(*ThresholdConfig_Value); ok {
		return x.Value
	}
	return 0
}

type isThresholdConfig_Threshold interface {
	isThresholdConfig_Threshold()
}

type ThresholdConfig_Value struct {
	// Specify a threshold value that can trigger the alert.
	// If this threshold config is for feature distribution distance:
	//   1. For categorical feature, the distribution distance is calculated by
	//      L-inifinity norm.
	//   2. For numerical feature, the distribution distance is calculated by
	//      Jensen–Shannon divergence.
	// Each feature must have a non-zero threshold if they need to be monitored.
	// Otherwise no alert will be triggered for that feature.
	Value float64 `protobuf:"fixed64,1,opt,name=value,proto3,oneof"`
}

func (*ThresholdConfig_Value) isThresholdConfig_Threshold() {}

// Sampling Strategy for logging, can be for both training and prediction
// dataset.
// Next ID: 2
type SamplingStrategy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Random sample config. Will support more sampling strategies later.
	RandomSampleConfig *SamplingStrategy_RandomSampleConfig `protobuf:"bytes,1,opt,name=random_sample_config,json=randomSampleConfig,proto3" json:"random_sample_config,omitempty"`
}

func (x *SamplingStrategy) Reset() {
	*x = SamplingStrategy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SamplingStrategy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SamplingStrategy) ProtoMessage() {}

func (x *SamplingStrategy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SamplingStrategy.ProtoReflect.Descriptor instead.
func (*SamplingStrategy) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{3}
}

func (x *SamplingStrategy) GetRandomSampleConfig() *SamplingStrategy_RandomSampleConfig {
	if x != nil {
		return x.RandomSampleConfig
	}
	return nil
}

// Training Dataset information.
type ModelMonitoringObjectiveConfig_TrainingDataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to DataSource:
	//	*ModelMonitoringObjectiveConfig_TrainingDataset_Dataset
	//	*ModelMonitoringObjectiveConfig_TrainingDataset_GcsSource
	//	*ModelMonitoringObjectiveConfig_TrainingDataset_BigquerySource
	DataSource isModelMonitoringObjectiveConfig_TrainingDataset_DataSource `protobuf_oneof:"data_source"`
	// Data format of the dataset, only applicable if the input is from
	// Google Cloud Storage.
	// The possible formats are:
	//
	// "tf-record"
	// The source file is a TFRecord file.
	//
	// "csv"
	// The source file is a CSV file.
	DataFormat string `protobuf:"bytes,2,opt,name=data_format,json=dataFormat,proto3" json:"data_format,omitempty"`
	// The target field name the model is to predict.
	// This field will be excluded when doing Predict and (or) Explain for the
	// training data.
	TargetField string `protobuf:"bytes,6,opt,name=target_field,json=targetField,proto3" json:"target_field,omitempty"`
	// Strategy to sample data from Training Dataset.
	// If not set, we process the whole dataset.
	LoggingSamplingStrategy *SamplingStrategy `protobuf:"bytes,7,opt,name=logging_sampling_strategy,json=loggingSamplingStrategy,proto3" json:"logging_sampling_strategy,omitempty"`
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) Reset() {
	*x = ModelMonitoringObjectiveConfig_TrainingDataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveConfig_TrainingDataset) ProtoMessage() {}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveConfig_TrainingDataset.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveConfig_TrainingDataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{0, 0}
}

func (m *ModelMonitoringObjectiveConfig_TrainingDataset) GetDataSource() isModelMonitoringObjectiveConfig_TrainingDataset_DataSource {
	if m != nil {
		return m.DataSource
	}
	return nil
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetDataset() string {
	if x, ok := x.GetDataSource().(*ModelMonitoringObjectiveConfig_TrainingDataset_Dataset); ok {
		return x.Dataset
	}
	return ""
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetGcsSource() *GcsSource {
	if x, ok := x.GetDataSource().(*ModelMonitoringObjectiveConfig_TrainingDataset_GcsSource); ok {
		return x.GcsSource
	}
	return nil
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetBigquerySource() *BigQuerySource {
	if x, ok := x.GetDataSource().(*ModelMonitoringObjectiveConfig_TrainingDataset_BigquerySource); ok {
		return x.BigquerySource
	}
	return nil
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetDataFormat() string {
	if x != nil {
		return x.DataFormat
	}
	return ""
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetTargetField() string {
	if x != nil {
		return x.TargetField
	}
	return ""
}

func (x *ModelMonitoringObjectiveConfig_TrainingDataset) GetLoggingSamplingStrategy() *SamplingStrategy {
	if x != nil {
		return x.LoggingSamplingStrategy
	}
	return nil
}

type isModelMonitoringObjectiveConfig_TrainingDataset_DataSource interface {
	isModelMonitoringObjectiveConfig_TrainingDataset_DataSource()
}

type ModelMonitoringObjectiveConfig_TrainingDataset_Dataset struct {
	// The resource name of the Dataset used to train this Model.
	Dataset string `protobuf:"bytes,3,opt,name=dataset,proto3,oneof"`
}

type ModelMonitoringObjectiveConfig_TrainingDataset_GcsSource struct {
	// The Google Cloud Storage uri of the unmanaged Dataset used to train
	// this Model.
	GcsSource *GcsSource `protobuf:"bytes,4,opt,name=gcs_source,json=gcsSource,proto3,oneof"`
}

type ModelMonitoringObjectiveConfig_TrainingDataset_BigquerySource struct {
	// The BigQuery table of the unmanaged Dataset used to train this
	// Model.
	BigquerySource *BigQuerySource `protobuf:"bytes,5,opt,name=bigquery_source,json=bigquerySource,proto3,oneof"`
}

func (*ModelMonitoringObjectiveConfig_TrainingDataset_Dataset) isModelMonitoringObjectiveConfig_TrainingDataset_DataSource() {
}

func (*ModelMonitoringObjectiveConfig_TrainingDataset_GcsSource) isModelMonitoringObjectiveConfig_TrainingDataset_DataSource() {
}

func (*ModelMonitoringObjectiveConfig_TrainingDataset_BigquerySource) isModelMonitoringObjectiveConfig_TrainingDataset_DataSource() {
}

// The config for Training & Prediction data skew detection. It specifies the
// training dataset sources and the skew detection parameters.
type ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key is the feature name and value is the threshold. If a feature needs to
	// be monitored for skew, a value threshold must be configed for that
	// feature. The threshold here is against feature distribution distance
	// between the training and prediction feature.
	SkewThresholds map[string]*ThresholdConfig `protobuf:"bytes,1,rep,name=skew_thresholds,json=skewThresholds,proto3" json:"skew_thresholds,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) Reset() {
	*x = ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) ProtoMessage() {}

func (x *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{0, 1}
}

func (x *ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig) GetSkewThresholds() map[string]*ThresholdConfig {
	if x != nil {
		return x.SkewThresholds
	}
	return nil
}

// The config for Prediction data drift detection.
type ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Key is the feature name and value is the threshold. If a feature needs to
	// be monitored for drift, a value threshold must be configed for that
	// feature. The threshold here is against feature distribution distance
	// between different time windws.
	DriftThresholds map[string]*ThresholdConfig `protobuf:"bytes,1,rep,name=drift_thresholds,json=driftThresholds,proto3" json:"drift_thresholds,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) Reset() {
	*x = ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) ProtoMessage() {}

func (x *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{0, 2}
}

func (x *ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig) GetDriftThresholds() map[string]*ThresholdConfig {
	if x != nil {
		return x.DriftThresholds
	}
	return nil
}

// The config for email alert.
type ModelMonitoringAlertConfig_EmailAlertConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email addresses to send the alert.
	UserEmails []string `protobuf:"bytes,1,rep,name=user_emails,json=userEmails,proto3" json:"user_emails,omitempty"`
}

func (x *ModelMonitoringAlertConfig_EmailAlertConfig) Reset() {
	*x = ModelMonitoringAlertConfig_EmailAlertConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ModelMonitoringAlertConfig_EmailAlertConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelMonitoringAlertConfig_EmailAlertConfig) ProtoMessage() {}

func (x *ModelMonitoringAlertConfig_EmailAlertConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelMonitoringAlertConfig_EmailAlertConfig.ProtoReflect.Descriptor instead.
func (*ModelMonitoringAlertConfig_EmailAlertConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ModelMonitoringAlertConfig_EmailAlertConfig) GetUserEmails() []string {
	if x != nil {
		return x.UserEmails
	}
	return nil
}

// Requests are randomly selected.
type SamplingStrategy_RandomSampleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sample rate (0, 1]
	SampleRate float64 `protobuf:"fixed64,1,opt,name=sample_rate,json=sampleRate,proto3" json:"sample_rate,omitempty"`
}

func (x *SamplingStrategy_RandomSampleConfig) Reset() {
	*x = SamplingStrategy_RandomSampleConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SamplingStrategy_RandomSampleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SamplingStrategy_RandomSampleConfig) ProtoMessage() {}

func (x *SamplingStrategy_RandomSampleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SamplingStrategy_RandomSampleConfig.ProtoReflect.Descriptor instead.
func (*SamplingStrategy_RandomSampleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP(), []int{3, 0}
}

func (x *SamplingStrategy_RandomSampleConfig) GetSampleRate() float64 {
	if x != nil {
		return x.SampleRate
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_model_monitoring_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDesc = []byte{
	0x0a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x0c, 0x0a,
	0x1e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x7a, 0x0a, 0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x52, 0x0f, 0x74, 0x72, 0x61, 0x69,
	0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0xbf, 0x01, 0x0a, 0x29,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x6b, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e,
	0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6b, 0x65, 0x77, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x25, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6b, 0x65, 0x77, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xa9, 0x01,
	0x0a, 0x21, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x72, 0x69,
	0x66, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x72, 0x69, 0x66, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x1e, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x72, 0x69, 0x66, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xc0, 0x03, 0x0a, 0x0f, 0x54, 0x72,
	0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x42, 0x0a,
	0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26,
	0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x48, 0x00, 0x52, 0x07, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x12, 0x4b, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x67, 0x63, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5a,
	0x0a, 0x0f, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x69, 0x67, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x62, 0x69, 0x67, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x64, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x21, 0x0a, 0x0c, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x6d,
	0x0a, 0x19, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61,
	0x74, 0x65, 0x67, 0x79, 0x52, 0x17, 0x6c, 0x6f, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x42, 0x0d, 0x0a,
	0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0xc1, 0x02, 0x0a,
	0x25, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x53, 0x6b, 0x65, 0x77, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xa2, 0x01, 0x0a, 0x0f, 0x73, 0x6b, 0x65, 0x77, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69,
	0x6e, 0x67, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x6b, 0x65, 0x77, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x6b, 0x65, 0x77, 0x54, 0x68, 0x72, 0x65,
	0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x73, 0x6b, 0x65,
	0x77, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x1a, 0x73, 0x0a, 0x13, 0x53,
	0x6b, 0x65, 0x77, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x46, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0xb7, 0x02, 0x0a, 0x1e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x72, 0x69, 0x66, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x9e, 0x01, 0x0a, 0x10, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67,
	0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x72, 0x69, 0x66, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x44,
	0x72, 0x69, 0x66, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x0f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68,
	0x6f, 0x6c, 0x64, 0x73, 0x1a, 0x74, 0x0a, 0x14, 0x44, 0x72, 0x69, 0x66, 0x74, 0x54, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x46,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xd8, 0x01, 0x0a, 0x1a, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c,
	0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x12, 0x65, 0x6d, 0x61,
	0x69, 0x6c, 0x5f, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x41, 0x6c, 0x65, 0x72,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x33, 0x0a, 0x10, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x41, 0x6c, 0x65, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x75,
	0x73, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0a, 0x75, 0x73, 0x65, 0x72, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x07, 0x0a, 0x05,
	0x61, 0x6c, 0x65, 0x72, 0x74, 0x22, 0x36, 0x0a, 0x0f, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x48, 0x00, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x0b, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0xc1, 0x01,
	0x0a, 0x10, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65,
	0x67, 0x79, 0x12, 0x76, 0x0a, 0x14, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x5f, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x61, 0x74,
	0x65, 0x67, 0x79, 0x2e, 0x52, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x12, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x53, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x35, 0x0a, 0x12, 0x52, 0x61,
	0x6e, 0x64, 0x6f, 0x6d, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x61, 0x74,
	0x65, 0x42, 0x88, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x14, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x49, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67,
	0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_goTypes = []interface{}{
	(*ModelMonitoringObjectiveConfig)(nil),                                       // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig
	(*ModelMonitoringAlertConfig)(nil),                                           // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig
	(*ThresholdConfig)(nil),                                                      // 2: google.cloud.aiplatform.v1beta1.ThresholdConfig
	(*SamplingStrategy)(nil),                                                     // 3: google.cloud.aiplatform.v1beta1.SamplingStrategy
	(*ModelMonitoringObjectiveConfig_TrainingDataset)(nil),                       // 4: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
	(*ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig)(nil), // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig
	(*ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig)(nil),        // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig
	nil, // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig.SkewThresholdsEntry
	nil, // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig.DriftThresholdsEntry
	(*ModelMonitoringAlertConfig_EmailAlertConfig)(nil), // 9: google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.EmailAlertConfig
	(*SamplingStrategy_RandomSampleConfig)(nil),         // 10: google.cloud.aiplatform.v1beta1.SamplingStrategy.RandomSampleConfig
	(*GcsSource)(nil),      // 11: google.cloud.aiplatform.v1beta1.GcsSource
	(*BigQuerySource)(nil), // 12: google.cloud.aiplatform.v1beta1.BigQuerySource
}
var file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_depIdxs = []int32{
	4,  // 0: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.training_dataset:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset
	5,  // 1: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.training_prediction_skew_detection_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig
	6,  // 2: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.prediction_drift_detection_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig
	9,  // 3: google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.email_alert_config:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringAlertConfig.EmailAlertConfig
	10, // 4: google.cloud.aiplatform.v1beta1.SamplingStrategy.random_sample_config:type_name -> google.cloud.aiplatform.v1beta1.SamplingStrategy.RandomSampleConfig
	11, // 5: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset.gcs_source:type_name -> google.cloud.aiplatform.v1beta1.GcsSource
	12, // 6: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset.bigquery_source:type_name -> google.cloud.aiplatform.v1beta1.BigQuerySource
	3,  // 7: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingDataset.logging_sampling_strategy:type_name -> google.cloud.aiplatform.v1beta1.SamplingStrategy
	7,  // 8: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig.skew_thresholds:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig.SkewThresholdsEntry
	8,  // 9: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig.drift_thresholds:type_name -> google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig.DriftThresholdsEntry
	2,  // 10: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.TrainingPredictionSkewDetectionConfig.SkewThresholdsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ThresholdConfig
	2,  // 11: google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveConfig.PredictionDriftDetectionConfig.DriftThresholdsEntry.value:type_name -> google.cloud.aiplatform.v1beta1.ThresholdConfig
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_monitoring_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringAlertConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ThresholdConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SamplingStrategy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveConfig_TrainingDataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveConfig_TrainingPredictionSkewDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringObjectiveConfig_PredictionDriftDetectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ModelMonitoringAlertConfig_EmailAlertConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SamplingStrategy_RandomSampleConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*ModelMonitoringAlertConfig_EmailAlertConfig_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[2].OneofWrappers = []interface{}{
		(*ThresholdConfig_Value)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ModelMonitoringObjectiveConfig_TrainingDataset_Dataset)(nil),
		(*ModelMonitoringObjectiveConfig_TrainingDataset_GcsSource)(nil),
		(*ModelMonitoringObjectiveConfig_TrainingDataset_BigquerySource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_monitoring_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_monitoring_proto_depIdxs = nil
}
