# Copyright 1999-2026 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DISTUTILS_EXT=1
DISTUTILS_USE_PEP517=setuptools
# pypy isn't supported upstream because of its UTF8 representation for strings
# See https://github.com/mrabarnett/mrab-regex/issues/521#issuecomment-1936260187.
PYTHON_COMPAT=( python3_{11..14} python3_{13,14}t )

inherit distutils-r1 pypi

DESCRIPTION="Alternative regular expression module to replace re"
HOMEPAGE="
	https://github.com/mrabarnett/mrab-regex/
	https://pypi.org/project/regex/
"

LICENSE="Apache-2.0"
SLOT="0"
KEYWORDS="~alpha amd64 arm arm64 ~hppa ~loong ~m68k ~mips ppc ppc64 ~riscv ~s390 ~sparc x86 ~arm64-macos ~x64-macos"
IUSE="doc"

distutils_enable_tests unittest

python_install_all() {
	use doc && local HTML_DOCS=( docs/Features.html )
	local DOCS=( README.rst docs/*.rst )

	distutils-r1_python_install_all
}

python_test() {
	cd "${BUILD_DIR}/install$(python_get_sitedir)/regex/tests" || die
	eunittest
}
