#!/bin/bash

# these chars are parts of library names but no valid shell names
OBS_MAP_CHARS="- / . +"

function obs_lib_to_package_name()
{
  local lib="$1"
  local lib="${lib#-l}" # strip leading -l argument
  for c in $OBS_MAP_CHARS ; do
    lib=${lib//$c/_} # strip illegal variable name char
  done

  eval 'obs_ret=${obs_libpack_map___'"${lib}"'}'
}

function obs_libs_to_package_names()
{
  obs_package_list=()
  while [ -n "$1" ]; do
    obs_lib_to_package_name "$1"
    if [ -z "$obs_ret" ]; then
      echo "WARNING: no package found for $1, skipping this one"
    fi
    shift
    local EXISTS="no"
    for i in "${obs_package_list[@]}"; do # a hash would be nicer
      if [[ "$i" == "${obs_ret}" ]] ; then 
        EXISTS="yes"
        break
      fi
    done
    if [ "$EXISTS" == "no" ] ; then
      obs_package_list=("${obs_package_list[@]}" $obs_ret )
    fi
  done 
}

function obs_generate_map()
{
  for i in /lib64/lib*.so /opt/*/lib64/lib*.so /usr/lib64/lib*.so; do
    local pack=`rpm -qf $i|tail -n 1`
    if [ "${pack:0:5}" == "file " ] ; then continue ; fi
    local lib=${i##*/lib}
    local lib=${lib%.so}
    for c in $OBS_MAP_CHARS ; do
      local lib=${lib//$c/_}
    done
    local pack=${pack%-*-*}
    echo obs_libpack_map___"${lib}"=\""$pack"\"
  done
}

# The large lists of libs mapped to the needed devel packages
#
# We source the fallback list, created automatically
source /usr/lib/obs/service/lib/obs_libpack_fallback_map.sh

# These are manual overrides, we know it better, this fixes stuff 
# for non openSUSE:Factory builds esp.
obs_libpack_map___svn_client_1="subversion"
obs_libpack_map___SDLmain="libSDL-devel"
obs_libpack_map___SDL_mixer="libSDL_mixer-devel"


