class RemoveDuplicateIndexes < ActiveRecord::Migration[5.0]
  def self.up
    # generated by pt-duplicate-key-checker 2.2.20 from structure.sql as of 7669128

    # ########################################################################
    # obs.attrib_namespace_modifiable_bies
    # ########################################################################

    # index_attrib_namespace_modifiable_bies_on_attrib_namespace_id is a left-prefix of attrib_namespace_user_role_all_index
    # Key definitions:
    #   KEY `index_attrib_namespace_modifiable_bies_on_attrib_namespace_id` (`attrib_namespace_id`),
    #   UNIQUE KEY `attrib_namespace_user_role_all_index` (`attrib_namespace_id`,`user_id`,`group_id`),
    # Column types:
    #	  `attrib_namespace_id` int(11) not null
    #	  `user_id` int(11) default null
    #	  `group_id` int(11) default null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `attrib_namespace_modifiable_bies` DROP INDEX `index_attrib_namespace_modifiable_bies_on_attrib_namespace_id`;"

    # ########################################################################
    # obs.attrib_types
    # ########################################################################

    # attrib_namespace_id is a left-prefix of index_attrib_types_on_attrib_namespace_id_and_name
    # Key definitions:
    #   KEY `attrib_namespace_id` (`attrib_namespace_id`),
    #   UNIQUE KEY `index_attrib_types_on_attrib_namespace_id_and_name` (`attrib_namespace_id`,`name`),
    # Column types:
    #	  `attrib_namespace_id` int(11) not null
    #	  `name` varchar(255) character set utf8 not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `attrib_types` DROP INDEX `attrib_namespace_id`;"

    # ########################################################################
    # obs.binary_releases
    # ########################################################################

    # index_binary_releases_on_binary_name is a left-prefix of exact_search_index
    # Key definitions:
    #   KEY `index_binary_releases_on_binary_name` (`binary_name`),
    #   KEY `exact_search_index` (`binary_name`,`binary_epoch`,`binary_version`,`binary_release`,`binary_arch`),
    # Column types:
    #	  `binary_name` varchar(255) collate utf8_unicode_ci not null
    #	  `binary_epoch` varchar(64) collate utf8_unicode_ci default null
    #	  `binary_version` varchar(64) collate utf8_unicode_ci not null
    #	  `binary_release` varchar(64) collate utf8_unicode_ci not null
    #	  `binary_arch` varchar(64) collate utf8_unicode_ci not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `binary_releases` DROP INDEX `index_binary_releases_on_binary_name`;"

    # ########################################################################
    # obs.bs_request_actions
    # ########################################################################

    # index_bs_request_actions_on_target_project is a left-prefix of index_bs_request_actions_on_target_project_and_source_project
    # Key definitions:
    #   KEY `index_bs_request_actions_on_target_project` (`target_project`),
    #   KEY `index_bs_request_actions_on_target_project_and_source_project` (`target_project`,`source_project`),
    # Column types:
    #	  `target_project` varchar(255) character set utf8 collate utf8_unicode_ci default null
    #	  `source_project` varchar(255) character set utf8 collate utf8_unicode_ci default null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `bs_request_actions` DROP INDEX `index_bs_request_actions_on_target_project_and_source_project`;"

    # ########################################################################
    # obs.cache_lines
    # ########################################################################

    # index_cache_lines_on_project is a left-prefix of index_cache_lines_on_project_and_package
    # Key definitions:
    #   KEY `index_cache_lines_on_project` (`project`),
    #   KEY `index_cache_lines_on_project_and_package` (`project`,`package`)
    # Column types:
    #	  `project` varchar(255) collate utf8_unicode_ci default null
    #	  `package` varchar(255) collate utf8_unicode_ci default null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `cache_lines` DROP INDEX `index_cache_lines_on_project`;"

    # ########################################################################
    # obs.channels
    # ########################################################################

    # package_id is a duplicate of index_unique
    # Key definitions:
    #   KEY `package_id` (`package_id`),
    #   UNIQUE KEY `index_unique` (`package_id`),
    # Column types:
    #	  `package_id` int(11) not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `channels` DROP INDEX `package_id`;"

    # ########################################################################
    # obs.history_elements
    # ########################################################################

    # index_history_elements_on_op_object_id is a left-prefix of index_search
    # Key definitions:
    #   KEY `index_history_elements_on_op_object_id` (`op_object_id`),
    #   KEY `index_search` (`op_object_id`,`type`)
    # Column types:
    #	  `op_object_id` int(11) not null
    #	  `type` varchar(255) collate utf8_unicode_ci not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `history_elements` DROP INDEX `index_history_elements_on_op_object_id`;"

    # ########################################################################
    # obs.package_issues
    # ########################################################################

    # index_package_issues_on_package_id is a left-prefix of index_package_issues_on_package_id_and_issue_id
    # Key definitions:
    #   KEY `index_package_issues_on_package_id` (`package_id`),
    #   KEY `index_package_issues_on_package_id_and_issue_id` (`package_id`,`issue_id`),
    # Column types:
    #	  `package_id` int(11) not null
    #	  `issue_id` int(11) not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `package_issues` DROP INDEX `index_package_issues_on_package_id`;"

    # ########################################################################
    # obs.packages
    # ########################################################################

    # index_packages_on_project_id is a left-prefix of packages_all_index
    # Key definitions:
    #   KEY `index_packages_on_project_id` (`project_id`),
    #   UNIQUE KEY `packages_all_index` (`project_id`,`name`),
    # Column types:
    #	  `project_id` int(11) not null
    #	  `name` varchar(200) collate utf8_bin not null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `packages` DROP INDEX `index_packages_on_project_id`;"

    # ########################################################################
    # obs.reviews
    # ########################################################################

    # index_reviews_on_state is a left-prefix of index_reviews_on_state_and_by_user
    # Key definitions:
    #   KEY `index_reviews_on_state` (`state`),
    #   KEY `index_reviews_on_state_and_by_user` (`state`,`by_user`),
    # Column types:
    #	  `state` varchar(255) collate utf8_unicode_ci default null
    #	  `by_user` varchar(255) collate utf8_unicode_ci default null
    # To remove this duplicate index, execute:
    execute "ALTER TABLE `reviews` DROP INDEX `index_reviews_on_state`;"
  end

  def self.down
    # rubocop:disable Metrics/LineLength
    # re-add duplicate indexes.
    # generated based the output of pt-duplicate-key-checker and the index definitions as of 7669128
    execute "ALTER TABLE `attrib_namespace_modifiable_bies` ADD INDEX `index_attrib_namespace_modifiable_bies_on_attrib_namespace_id` (`attrib_namespace_id`);"
    execute "ALTER TABLE `attrib_types` ADD INDEX `attrib_namespace_id` (`attrib_namespace_id`);"
    execute "ALTER TABLE `binary_releases` ADD INDEX `index_binary_releases_on_binary_name` (`binary_name`);"
    execute "ALTER TABLE `bs_request_actions` ADD INDEX `index_bs_request_actions_on_target_project_and_source_project` (`target_project`, `source_project`);"
    execute "ALTER TABLE `cache_lines` ADD INDEX `index_cache_lines_on_project` (`project`);"
    execute "ALTER TABLE `channels` ADD INDEX `package_id` (`package_id`);"
    execute "ALTER TABLE `history_elements` ADD INDEX `index_history_elements_on_op_object_id` (`op_object_id`);"
    execute "ALTER TABLE `package_issues` ADD INDEX `index_package_issues_on_package_id` (`package_id`);"
    execute "ALTER TABLE `packages` ADD INDEX `index_packages_on_project_id` (`project_id`);"
    execute "ALTER TABLE `reviews` ADD INDEX `index_reviews_on_state` (`state`);"
    # rubocop:enable Metrics/LineLength
  end
end
