// Compiled by ClojureScript 0.0-2138
goog.provide('crate.binding');
goog.require('cljs.core');
goog.require('clojure.set');
goog.require('clojure.set');

/**
* @constructor
*/
crate.binding.SubAtom = (function (atm,path,prevhash,watches,key){
this.atm = atm;
this.path = path;
this.prevhash = prevhash;
this.watches = watches;
this.key = key;
this.cljs$lang$protocol_mask$partition0$ = 2153807872;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.SubAtom.cljs$lang$type = true;
crate.binding.SubAtom.cljs$lang$ctorStr = "crate.binding/SubAtom";
crate.binding.SubAtom.cljs$lang$ctorPrWriter = (function (this__4082__auto__,writer__4083__auto__,opt__4084__auto__){return cljs.core._write.call(null,writer__4083__auto__,"crate.binding/SubAtom");
});
crate.binding.SubAtom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return goog.getUid(this$__$1);
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__15711 = cljs.core.seq.call(null,self__.watches);var chunk__15712 = null;var count__15713 = 0;var i__15714 = 0;while(true){
if((i__15714 < count__15713))
{var vec__15715 = cljs.core._nth.call(null,chunk__15712,i__15714);var key__$1 = cljs.core.nth.call(null,vec__15715,0,null);var f = cljs.core.nth.call(null,vec__15715,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__15717 = seq__15711;
var G__15718 = chunk__15712;
var G__15719 = count__15713;
var G__15720 = (i__15714 + 1);
seq__15711 = G__15717;
chunk__15712 = G__15718;
count__15713 = G__15719;
i__15714 = G__15720;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__15711);if(temp__4092__auto__)
{var seq__15711__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15711__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__15711__$1);{
var G__15721 = cljs.core.chunk_rest.call(null,seq__15711__$1);
var G__15722 = c__4262__auto__;
var G__15723 = cljs.core.count.call(null,c__4262__auto__);
var G__15724 = 0;
seq__15711 = G__15721;
chunk__15712 = G__15722;
count__15713 = G__15723;
i__15714 = G__15724;
continue;
}
} else
{var vec__15716 = cljs.core.first.call(null,seq__15711__$1);var key__$1 = cljs.core.nth.call(null,vec__15716,0,null);var f = cljs.core.nth.call(null,vec__15716,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__15725 = cljs.core.next.call(null,seq__15711__$1);
var G__15726 = null;
var G__15727 = 0;
var G__15728 = 0;
seq__15711 = G__15725;
chunk__15712 = G__15726;
count__15713 = G__15727;
i__15714 = G__15728;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key__$1,f){var self__ = this;
var this$__$1 = this;if(cljs.core.truth_(f))
{return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key__$1,f);
} else
{return null;
}
});
crate.binding.SubAtom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key__$1){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key__$1);
});
crate.binding.SubAtom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){var self__ = this;
var this$__$1 = this;return cljs.core._write.call(null,writer,[cljs.core.str("#<SubAtom: "),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,self__.atm),self__.path))),cljs.core.str(">")].join(''));
});
crate.binding.SubAtom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){var self__ = this;
var ___$1 = this;if(cljs.core.truth_(self__.atm))
{return cljs.core.get_in.call(null,cljs.core.deref.call(null,self__.atm),self__.path);
} else
{return null;
}
});
crate.binding.SubAtom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){var self__ = this;
var o__$1 = this;return (o__$1 === other);
});
crate.binding.__GT_SubAtom = (function __GT_SubAtom(atm,path,prevhash,watches,key){return (new crate.binding.SubAtom(atm,path,prevhash,watches,key));
});
crate.binding.subatom = (function subatom(atm,path){var path__$1 = ((cljs.core.coll_QMARK_.call(null,path))?path:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [path], null));var vec__15730 = (((atm instanceof crate.binding.SubAtom))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atm.atm,cljs.core.concat.call(null,atm.path,path__$1)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [atm,path__$1], null));var atm__$1 = cljs.core.nth.call(null,vec__15730,0,null);var path__$2 = cljs.core.nth.call(null,vec__15730,1,null);var k = cljs.core.gensym.call(null,"subatom");var sa = (new crate.binding.SubAtom(atm__$1,path__$2,cljs.core.hash.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,atm__$1),path__$2)),null,k));cljs.core.add_watch.call(null,atm__$1,k,(function (_,___$1,ov,nv){var latest = cljs.core.get_in.call(null,nv,path__$2);var prev = cljs.core.get_in.call(null,ov,path__$2);var latest_hash = cljs.core.hash.call(null,latest);if((cljs.core.not_EQ_.call(null,sa.prevhash,latest_hash)) && (cljs.core.not_EQ_.call(null,prev,latest)))
{sa.prevhash = latest_hash;
return cljs.core._notify_watches.call(null,sa,cljs.core.get_in.call(null,ov,path__$2),latest);
} else
{return null;
}
}));
return sa;
});
/**
* Sets the value of atom to newval without regard for the
* current value. Returns newval.
*/
crate.binding.sub_reset_BANG_ = (function sub_reset_BANG_(sa,new_value){cljs.core.swap_BANG_.call(null,sa.atm,cljs.core.assoc_in,sa.path,new_value);
return new_value;
});
/**
* Atomically swaps the value of atom to be:
* (apply f current-value-of-atom args). Note that f may be called
* multiple times, and thus should be free of side effects.  Returns
* the value that was swapped in.
* @param {...*} var_args
*/
crate.binding.sub_swap_BANG_ = (function() {
var sub_swap_BANG_ = null;
var sub_swap_BANG___2 = (function (sa,f){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa)));
});
var sub_swap_BANG___3 = (function (sa,f,x){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x));
});
var sub_swap_BANG___4 = (function (sa,f,x,y){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y));
});
var sub_swap_BANG___5 = (function (sa,f,x,y,z){return crate.binding.sub_reset_BANG_.call(null,sa,f.call(null,cljs.core.deref.call(null,sa),x,y,z));
});
var sub_swap_BANG___6 = (function() { 
var G__15731__delegate = function (sa,f,x,y,z,more){return crate.binding.sub_reset_BANG_.call(null,sa,cljs.core.apply.call(null,f,cljs.core.deref.call(null,sa),x,y,z,more));
};
var G__15731 = function (sa,f,x,y,z,var_args){
var more = null;if (arguments.length > 5) {
  more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5),0);} 
return G__15731__delegate.call(this,sa,f,x,y,z,more);};
G__15731.cljs$lang$maxFixedArity = 5;
G__15731.cljs$lang$applyTo = (function (arglist__15732){
var sa = cljs.core.first(arglist__15732);
arglist__15732 = cljs.core.next(arglist__15732);
var f = cljs.core.first(arglist__15732);
arglist__15732 = cljs.core.next(arglist__15732);
var x = cljs.core.first(arglist__15732);
arglist__15732 = cljs.core.next(arglist__15732);
var y = cljs.core.first(arglist__15732);
arglist__15732 = cljs.core.next(arglist__15732);
var z = cljs.core.first(arglist__15732);
var more = cljs.core.rest(arglist__15732);
return G__15731__delegate(sa,f,x,y,z,more);
});
G__15731.cljs$core$IFn$_invoke$arity$variadic = G__15731__delegate;
return G__15731;
})()
;
sub_swap_BANG_ = function(sa,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return sub_swap_BANG___2.call(this,sa,f);
case 3:
return sub_swap_BANG___3.call(this,sa,f,x);
case 4:
return sub_swap_BANG___4.call(this,sa,f,x,y);
case 5:
return sub_swap_BANG___5.call(this,sa,f,x,y,z);
default:
return sub_swap_BANG___6.cljs$core$IFn$_invoke$arity$variadic(sa,f,x,y,z, cljs.core.array_seq(arguments, 5));
}
throw(new Error('Invalid arity: ' + arguments.length));
};
sub_swap_BANG_.cljs$lang$maxFixedArity = 5;
sub_swap_BANG_.cljs$lang$applyTo = sub_swap_BANG___6.cljs$lang$applyTo;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = sub_swap_BANG___2;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = sub_swap_BANG___3;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = sub_swap_BANG___4;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = sub_swap_BANG___5;
sub_swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = sub_swap_BANG___6.cljs$core$IFn$_invoke$arity$variadic;
return sub_swap_BANG_;
})()
;
crate.binding.sub_destroy_BANG_ = (function sub_destroy_BANG_(sa){cljs.core.remove_watch.call(null,sa.atm,sa.key);
sa.watches = null;
return sa.atm = null;
});
crate.binding.computable = (function (){var obj15734 = {};return obj15734;
})();
crate.binding._depend = (function _depend(this$,atm){if((function (){var and__3508__auto__ = this$;if(and__3508__auto__)
{return this$.crate$binding$computable$_depend$arity$2;
} else
{return and__3508__auto__;
}
})())
{return this$.crate$binding$computable$_depend$arity$2(this$,atm);
} else
{var x__4141__auto__ = (((this$ == null))?null:this$);return (function (){var or__3520__auto__ = (crate.binding._depend[goog.typeOf(x__4141__auto__)]);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = (crate.binding._depend["_"]);if(or__3520__auto____$1)
{return or__3520__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"computable.-depend",this$);
}
}
})().call(null,this$,atm);
}
});
crate.binding._compute = (function _compute(this$){if((function (){var and__3508__auto__ = this$;if(and__3508__auto__)
{return this$.crate$binding$computable$_compute$arity$1;
} else
{return and__3508__auto__;
}
})())
{return this$.crate$binding$computable$_compute$arity$1(this$);
} else
{var x__4141__auto__ = (((this$ == null))?null:this$);return (function (){var or__3520__auto__ = (crate.binding._compute[goog.typeOf(x__4141__auto__)]);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = (crate.binding._compute["_"]);if(or__3520__auto____$1)
{return or__3520__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"computable.-compute",this$);
}
}
})().call(null,this$);
}
});

/**
* @constructor
*/
crate.binding.Computed = (function (atms,value,func,watches,key,meta){
this.atms = atms;
this.value = value;
this.func = func;
this.watches = watches;
this.key = key;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 2153938944;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.Computed.cljs$lang$type = true;
crate.binding.Computed.cljs$lang$ctorStr = "crate.binding/Computed";
crate.binding.Computed.cljs$lang$ctorPrWriter = (function (this__4082__auto__,writer__4083__auto__,opt__4084__auto__){return cljs.core._write.call(null,writer__4083__auto__,"crate.binding/Computed");
});
crate.binding.Computed.prototype.crate$binding$computable$ = true;
crate.binding.Computed.prototype.crate$binding$computable$_depend$arity$2 = (function (this$,atm){var self__ = this;
var this$__$1 = this;this$__$1.atms = cljs.core.conj.call(null,this$__$1.atms,atm);
return cljs.core.add_watch.call(null,atm,self__.key,(function (_,___$1,___$2,___$3){return crate.binding._compute.call(null,this$__$1);
}));
});
crate.binding.Computed.prototype.crate$binding$computable$_compute$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;var old = this$__$1.value;var nv = cljs.core.apply.call(null,self__.func,cljs.core.map.call(null,cljs.core.deref,self__.atms));this$__$1.value = nv;
return cljs.core._notify_watches.call(null,this$__$1,old,nv);
});
crate.binding.Computed.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return self__.meta;
});
crate.binding.Computed.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return goog.getUid(this$__$1);
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__15735 = cljs.core.seq.call(null,self__.watches);var chunk__15736 = null;var count__15737 = 0;var i__15738 = 0;while(true){
if((i__15738 < count__15737))
{var vec__15739 = cljs.core._nth.call(null,chunk__15736,i__15738);var key__$1 = cljs.core.nth.call(null,vec__15739,0,null);var f = cljs.core.nth.call(null,vec__15739,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__15741 = seq__15735;
var G__15742 = chunk__15736;
var G__15743 = count__15737;
var G__15744 = (i__15738 + 1);
seq__15735 = G__15741;
chunk__15736 = G__15742;
count__15737 = G__15743;
i__15738 = G__15744;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__15735);if(temp__4092__auto__)
{var seq__15735__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15735__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__15735__$1);{
var G__15745 = cljs.core.chunk_rest.call(null,seq__15735__$1);
var G__15746 = c__4262__auto__;
var G__15747 = cljs.core.count.call(null,c__4262__auto__);
var G__15748 = 0;
seq__15735 = G__15745;
chunk__15736 = G__15746;
count__15737 = G__15747;
i__15738 = G__15748;
continue;
}
} else
{var vec__15740 = cljs.core.first.call(null,seq__15735__$1);var key__$1 = cljs.core.nth.call(null,vec__15740,0,null);var f = cljs.core.nth.call(null,vec__15740,1,null);f.call(null,key__$1,this$__$1,oldval,newval);
{
var G__15749 = cljs.core.next.call(null,seq__15735__$1);
var G__15750 = null;
var G__15751 = 0;
var G__15752 = 0;
seq__15735 = G__15749;
chunk__15736 = G__15750;
count__15737 = G__15751;
i__15738 = G__15752;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key__$1,f){var self__ = this;
var this$__$1 = this;if(cljs.core.truth_(f))
{return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key__$1,f);
} else
{return null;
}
});
crate.binding.Computed.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key__$1){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key__$1);
});
crate.binding.Computed.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this$,writer,opts){var self__ = this;
var this$__$1 = this;return cljs.core._write.call(null,writer,[cljs.core.str("#<Computed: "),cljs.core.str(cljs.core.pr_str.call(null,self__.value)),cljs.core.str(">")].join(''));
});
crate.binding.Computed.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){var self__ = this;
var ___$1 = this;return self__.value;
});
crate.binding.Computed.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){var self__ = this;
var o__$1 = this;return (o__$1 === other);
});
crate.binding.__GT_Computed = (function __GT_Computed(atms,value,func,watches,key,meta){return (new crate.binding.Computed(atms,value,func,watches,key,meta));
});
crate.binding.computed = (function computed(atms,func){var k = cljs.core.gensym.call(null,"computed");var neue = (new crate.binding.Computed(cljs.core.PersistentVector.EMPTY,null,func,null,k,null));crate.binding._compute.call(null,neue);
var seq__15757_15761 = cljs.core.seq.call(null,atms);var chunk__15758_15762 = null;var count__15759_15763 = 0;var i__15760_15764 = 0;while(true){
if((i__15760_15764 < count__15759_15763))
{var atm_15765 = cljs.core._nth.call(null,chunk__15758_15762,i__15760_15764);crate.binding._depend.call(null,neue,atm_15765);
{
var G__15766 = seq__15757_15761;
var G__15767 = chunk__15758_15762;
var G__15768 = count__15759_15763;
var G__15769 = (i__15760_15764 + 1);
seq__15757_15761 = G__15766;
chunk__15758_15762 = G__15767;
count__15759_15763 = G__15768;
i__15760_15764 = G__15769;
continue;
}
} else
{var temp__4092__auto___15770 = cljs.core.seq.call(null,seq__15757_15761);if(temp__4092__auto___15770)
{var seq__15757_15771__$1 = temp__4092__auto___15770;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15757_15771__$1))
{var c__4262__auto___15772 = cljs.core.chunk_first.call(null,seq__15757_15771__$1);{
var G__15773 = cljs.core.chunk_rest.call(null,seq__15757_15771__$1);
var G__15774 = c__4262__auto___15772;
var G__15775 = cljs.core.count.call(null,c__4262__auto___15772);
var G__15776 = 0;
seq__15757_15761 = G__15773;
chunk__15758_15762 = G__15774;
count__15759_15763 = G__15775;
i__15760_15764 = G__15776;
continue;
}
} else
{var atm_15777 = cljs.core.first.call(null,seq__15757_15771__$1);crate.binding._depend.call(null,neue,atm_15777);
{
var G__15778 = cljs.core.next.call(null,seq__15757_15771__$1);
var G__15779 = null;
var G__15780 = 0;
var G__15781 = 0;
seq__15757_15761 = G__15778;
chunk__15758_15762 = G__15779;
count__15759_15763 = G__15780;
i__15760_15764 = G__15781;
continue;
}
}
} else
{}
}
break;
}
return neue;
});
crate.binding.compute = (function compute(compu){return crate.binding._compute.call(null,compu);
});
crate.binding.depend_on = (function depend_on(compu,atm){return crate.binding._depend.call(null,compu,atm);
});
crate.binding.notify = (function notify(w,o,v){return cljs.core._notify_watches.call(null,w,o,v);
});
crate.binding.bindable_coll = (function (){var obj15783 = {};return obj15783;
})();
crate.binding.bindable = (function (){var obj15785 = {};return obj15785;
})();
crate.binding._value = (function _value(this$){if((function (){var and__3508__auto__ = this$;if(and__3508__auto__)
{return this$.crate$binding$bindable$_value$arity$1;
} else
{return and__3508__auto__;
}
})())
{return this$.crate$binding$bindable$_value$arity$1(this$);
} else
{var x__4141__auto__ = (((this$ == null))?null:this$);return (function (){var or__3520__auto__ = (crate.binding._value[goog.typeOf(x__4141__auto__)]);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = (crate.binding._value["_"]);if(or__3520__auto____$1)
{return or__3520__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-value",this$);
}
}
})().call(null,this$);
}
});
crate.binding._on_change = (function _on_change(this$,func){if((function (){var and__3508__auto__ = this$;if(and__3508__auto__)
{return this$.crate$binding$bindable$_on_change$arity$2;
} else
{return and__3508__auto__;
}
})())
{return this$.crate$binding$bindable$_on_change$arity$2(this$,func);
} else
{var x__4141__auto__ = (((this$ == null))?null:this$);return (function (){var or__3520__auto__ = (crate.binding._on_change[goog.typeOf(x__4141__auto__)]);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = (crate.binding._on_change["_"]);if(or__3520__auto____$1)
{return or__3520__auto____$1;
} else
{throw cljs.core.missing_protocol.call(null,"bindable.-on-change",this$);
}
}
})().call(null,this$,func);
}
});

/**
* @constructor
*/
crate.binding.atom_binding = (function (atm,value_func){
this.atm = atm;
this.value_func = value_func;
})
crate.binding.atom_binding.cljs$lang$type = true;
crate.binding.atom_binding.cljs$lang$ctorStr = "crate.binding/atom-binding";
crate.binding.atom_binding.cljs$lang$ctorPrWriter = (function (this__4082__auto__,writer__4083__auto__,opt__4084__auto__){return cljs.core._write.call(null,writer__4083__auto__,"crate.binding/atom-binding");
});
crate.binding.atom_binding.prototype.crate$binding$bindable$ = true;
crate.binding.atom_binding.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return self__.value_func.call(null,cljs.core.deref.call(null,self__.atm));
});
crate.binding.atom_binding.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){var self__ = this;
var this$__$1 = this;return cljs.core.add_watch.call(null,self__.atm,cljs.core.gensym.call(null,"atom-binding"),(function (){return func.call(null,crate.binding._value.call(null,this$__$1));
}));
});
crate.binding.__GT_atom_binding = (function __GT_atom_binding(atm,value_func){return (new crate.binding.atom_binding(atm,value_func));
});

/**
* @constructor
*/
crate.binding.notifier = (function (watches){
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 0;
this.cljs$lang$protocol_mask$partition1$ = 2;
})
crate.binding.notifier.cljs$lang$type = true;
crate.binding.notifier.cljs$lang$ctorStr = "crate.binding/notifier";
crate.binding.notifier.cljs$lang$ctorPrWriter = (function (this__4082__auto__,writer__4083__auto__,opt__4084__auto__){return cljs.core._write.call(null,writer__4083__auto__,"crate.binding/notifier");
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){var self__ = this;
var this$__$1 = this;var seq__15786 = cljs.core.seq.call(null,self__.watches);var chunk__15787 = null;var count__15788 = 0;var i__15789 = 0;while(true){
if((i__15789 < count__15788))
{var vec__15790 = cljs.core._nth.call(null,chunk__15787,i__15789);var key = cljs.core.nth.call(null,vec__15790,0,null);var f = cljs.core.nth.call(null,vec__15790,1,null);f.call(null,key,this$__$1,oldval,newval);
{
var G__15792 = seq__15786;
var G__15793 = chunk__15787;
var G__15794 = count__15788;
var G__15795 = (i__15789 + 1);
seq__15786 = G__15792;
chunk__15787 = G__15793;
count__15788 = G__15794;
i__15789 = G__15795;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__15786);if(temp__4092__auto__)
{var seq__15786__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15786__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__15786__$1);{
var G__15796 = cljs.core.chunk_rest.call(null,seq__15786__$1);
var G__15797 = c__4262__auto__;
var G__15798 = cljs.core.count.call(null,c__4262__auto__);
var G__15799 = 0;
seq__15786 = G__15796;
chunk__15787 = G__15797;
count__15788 = G__15798;
i__15789 = G__15799;
continue;
}
} else
{var vec__15791 = cljs.core.first.call(null,seq__15786__$1);var key = cljs.core.nth.call(null,vec__15791,0,null);var f = cljs.core.nth.call(null,vec__15791,1,null);f.call(null,key,this$__$1,oldval,newval);
{
var G__15800 = cljs.core.next.call(null,seq__15786__$1);
var G__15801 = null;
var G__15802 = 0;
var G__15803 = 0;
seq__15786 = G__15800;
chunk__15787 = G__15801;
count__15788 = G__15802;
i__15789 = G__15803;
continue;
}
}
} else
{return null;
}
}
break;
}
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.assoc.call(null,self__.watches,key,f);
});
crate.binding.notifier.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){var self__ = this;
var this$__$1 = this;return this$__$1.watches = cljs.core.dissoc.call(null,self__.watches,key);
});
crate.binding.__GT_notifier = (function __GT_notifier(watches){return (new crate.binding.notifier(watches));
});

/**
* @constructor
*/
crate.binding.bound_collection = (function (atm,notif,opts,stuff){
this.atm = atm;
this.notif = notif;
this.opts = opts;
this.stuff = stuff;
})
crate.binding.bound_collection.cljs$lang$type = true;
crate.binding.bound_collection.cljs$lang$ctorStr = "crate.binding/bound-collection";
crate.binding.bound_collection.cljs$lang$ctorPrWriter = (function (this__4082__auto__,writer__4083__auto__,opt__4084__auto__){return cljs.core._write.call(null,writer__4083__auto__,"crate.binding/bound-collection");
});
crate.binding.bound_collection.prototype.crate$binding$bindable$ = true;
crate.binding.bound_collection.prototype.crate$binding$bindable$_value$arity$1 = (function (this$){var self__ = this;
var this$__$1 = this;return cljs.core.map.call(null,new cljs.core.Keyword(null,"elem","elem",1017020161),cljs.core.vals.call(null,this$__$1.stuff));
});
crate.binding.bound_collection.prototype.crate$binding$bindable$_on_change$arity$2 = (function (this$,func){var self__ = this;
var this$__$1 = this;return cljs.core.add_watch.call(null,self__.notif,cljs.core.gensym.call(null,"bound-coll"),(function (_,___$1,___$2,p__15804){var vec__15805 = p__15804;var event = cljs.core.nth.call(null,vec__15805,0,null);var el = cljs.core.nth.call(null,vec__15805,1,null);var v = cljs.core.nth.call(null,vec__15805,2,null);return func.call(null,event,el,v);
}));
});
crate.binding.bound_collection.prototype.crate$binding$bindable_coll$ = true;
crate.binding.__GT_bound_collection = (function __GT_bound_collection(atm,notif,opts,stuff){return (new crate.binding.bound_collection(atm,notif,opts,stuff));
});
crate.binding.opt = (function opt(bc,k){return bc.opts.call(null,k);
});
crate.binding.bc_add = (function bc_add(bc,path,key){var sa = crate.binding.subatom.call(null,bc.atm,path);var elem = crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"as","as",1013907364)).call(null,sa);bc.stuff = cljs.core.assoc.call(null,bc.stuff,key,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"elem","elem",1017020161),elem,new cljs.core.Keyword(null,"subatom","subatom",3440732931),sa], null));
return crate.binding.notify.call(null,bc.notif,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"add","add",1014000659),elem,cljs.core.deref.call(null,sa)], null));
});
crate.binding.bc_remove = (function bc_remove(bc,key){var notif = bc.notif;var prev = bc.stuff.call(null,key);bc.stuff = cljs.core.dissoc.call(null,bc.stuff,key);
crate.binding.notify.call(null,bc.notif,null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"remove","remove",4374260726),new cljs.core.Keyword(null,"elem","elem",1017020161).cljs$core$IFn$_invoke$arity$1(prev),null], null));
return crate.binding.sub_destroy_BANG_.call(null,new cljs.core.Keyword(null,"subatom","subatom",3440732931).cljs$core$IFn$_invoke$arity$1(prev));
});
crate.binding.__GT_indexed = (function __GT_indexed(coll){if(cljs.core.map_QMARK_.call(null,coll))
{return cljs.core.seq.call(null,coll);
} else
{if(cljs.core.set_QMARK_.call(null,coll))
{return cljs.core.map.call(null,cljs.core.juxt.call(null,cljs.core.identity,cljs.core.identity),coll);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return cljs.core.map_indexed.call(null,cljs.core.vector,coll);
} else
{return null;
}
}
}
});
crate.binding.__GT_keyed = (function __GT_keyed(coll,keyfn){return cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,keyfn,crate.binding.__GT_indexed.call(null,coll)));
});
/**
* @param {...*} var_args
*/
crate.binding.__GT_path = (function() { 
var __GT_path__delegate = function (bc,segs){return cljs.core.concat.call(null,(function (){var or__3520__auto__ = crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"path","path",1017337751));if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.PersistentVector.EMPTY;
}
})(),segs);
};
var __GT_path = function (bc,var_args){
var segs = null;if (arguments.length > 1) {
  segs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __GT_path__delegate.call(this,bc,segs);};
__GT_path.cljs$lang$maxFixedArity = 1;
__GT_path.cljs$lang$applyTo = (function (arglist__15806){
var bc = cljs.core.first(arglist__15806);
var segs = cljs.core.rest(arglist__15806);
return __GT_path__delegate(bc,segs);
});
__GT_path.cljs$core$IFn$_invoke$arity$variadic = __GT_path__delegate;
return __GT_path;
})()
;
crate.binding.bc_compare = (function bc_compare(bc,neue){var prev = bc.stuff;var pset = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.keys.call(null,prev));var nset = crate.binding.__GT_keyed.call(null,neue,crate.binding.opt.call(null,bc,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433)));var added = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,nset,pset));var removed = cljs.core.into.call(null,cljs.core.sorted_set.call(null),clojure.set.difference.call(null,pset,nset));var seq__15815_15823 = cljs.core.seq.call(null,added);var chunk__15816_15824 = null;var count__15817_15825 = 0;var i__15818_15826 = 0;while(true){
if((i__15818_15826 < count__15817_15825))
{var a_15827 = cljs.core._nth.call(null,chunk__15816_15824,i__15818_15826);crate.binding.bc_add.call(null,bc,a_15827,a_15827);
{
var G__15828 = seq__15815_15823;
var G__15829 = chunk__15816_15824;
var G__15830 = count__15817_15825;
var G__15831 = (i__15818_15826 + 1);
seq__15815_15823 = G__15828;
chunk__15816_15824 = G__15829;
count__15817_15825 = G__15830;
i__15818_15826 = G__15831;
continue;
}
} else
{var temp__4092__auto___15832 = cljs.core.seq.call(null,seq__15815_15823);if(temp__4092__auto___15832)
{var seq__15815_15833__$1 = temp__4092__auto___15832;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15815_15833__$1))
{var c__4262__auto___15834 = cljs.core.chunk_first.call(null,seq__15815_15833__$1);{
var G__15835 = cljs.core.chunk_rest.call(null,seq__15815_15833__$1);
var G__15836 = c__4262__auto___15834;
var G__15837 = cljs.core.count.call(null,c__4262__auto___15834);
var G__15838 = 0;
seq__15815_15823 = G__15835;
chunk__15816_15824 = G__15836;
count__15817_15825 = G__15837;
i__15818_15826 = G__15838;
continue;
}
} else
{var a_15839 = cljs.core.first.call(null,seq__15815_15833__$1);crate.binding.bc_add.call(null,bc,a_15839,a_15839);
{
var G__15840 = cljs.core.next.call(null,seq__15815_15833__$1);
var G__15841 = null;
var G__15842 = 0;
var G__15843 = 0;
seq__15815_15823 = G__15840;
chunk__15816_15824 = G__15841;
count__15817_15825 = G__15842;
i__15818_15826 = G__15843;
continue;
}
}
} else
{}
}
break;
}
var seq__15819 = cljs.core.seq.call(null,removed);var chunk__15820 = null;var count__15821 = 0;var i__15822 = 0;while(true){
if((i__15822 < count__15821))
{var r = cljs.core._nth.call(null,chunk__15820,i__15822);crate.binding.bc_remove.call(null,bc,r);
{
var G__15844 = seq__15819;
var G__15845 = chunk__15820;
var G__15846 = count__15821;
var G__15847 = (i__15822 + 1);
seq__15819 = G__15844;
chunk__15820 = G__15845;
count__15821 = G__15846;
i__15822 = G__15847;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__15819);if(temp__4092__auto__)
{var seq__15819__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__15819__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__15819__$1);{
var G__15848 = cljs.core.chunk_rest.call(null,seq__15819__$1);
var G__15849 = c__4262__auto__;
var G__15850 = cljs.core.count.call(null,c__4262__auto__);
var G__15851 = 0;
seq__15819 = G__15848;
chunk__15820 = G__15849;
count__15821 = G__15850;
i__15822 = G__15851;
continue;
}
} else
{var r = cljs.core.first.call(null,seq__15819__$1);crate.binding.bc_remove.call(null,bc,r);
{
var G__15852 = cljs.core.next.call(null,seq__15819__$1);
var G__15853 = null;
var G__15854 = 0;
var G__15855 = 0;
seq__15819 = G__15852;
chunk__15820 = G__15853;
count__15821 = G__15854;
i__15822 = G__15855;
continue;
}
}
} else
{return null;
}
}
break;
}
});
/**
* @param {...*} var_args
*/
crate.binding.bound_coll = (function() { 
var bound_coll__delegate = function (atm,p__15856){var vec__15859 = p__15856;var path = cljs.core.nth.call(null,vec__15859,0,null);var opts = cljs.core.nth.call(null,vec__15859,1,null);var vec__15860 = (cljs.core.truth_(opts)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,opts], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,path], null));var path__$1 = cljs.core.nth.call(null,vec__15860,0,null);var opts__$1 = cljs.core.nth.call(null,vec__15860,1,null);var atm__$1 = ((cljs.core.not.call(null,path__$1))?atm:crate.binding.subatom.call(null,atm,path__$1));var opts__$2 = cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"path","path",1017337751),path__$1);var opts__$3 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$2)))?cljs.core.assoc.call(null,opts__$2,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.first):cljs.core.assoc.call(null,opts__$2,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.comp.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$2),cljs.core.second)));var bc = (new crate.binding.bound_collection(atm__$1,(new crate.binding.notifier(null)),opts__$3,cljs.core.sorted_map.call(null)));cljs.core.add_watch.call(null,atm__$1,cljs.core.gensym.call(null,"bound-coll"),(function (_,___$1,___$2,neue){return crate.binding.bc_compare.call(null,bc,neue);
}));
crate.binding.bc_compare.call(null,bc,cljs.core.deref.call(null,atm__$1));
return bc;
};
var bound_coll = function (atm,var_args){
var p__15856 = null;if (arguments.length > 1) {
  p__15856 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return bound_coll__delegate.call(this,atm,p__15856);};
bound_coll.cljs$lang$maxFixedArity = 1;
bound_coll.cljs$lang$applyTo = (function (arglist__15861){
var atm = cljs.core.first(arglist__15861);
var p__15856 = cljs.core.rest(arglist__15861);
return bound_coll__delegate(atm,p__15856);
});
bound_coll.cljs$core$IFn$_invoke$arity$variadic = bound_coll__delegate;
return bound_coll;
})()
;
/**
* @param {...*} var_args
*/
crate.binding.map_bound = (function() { 
var map_bound__delegate = function (as,atm,p__15862){var vec__15864 = p__15862;var opts = cljs.core.nth.call(null,vec__15864,0,null);var opts__$1 = cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"as","as",1013907364),as);var atm__$1 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(opts__$1)))?atm:crate.binding.subatom.call(null,atm,new cljs.core.Keyword(null,"path","path",1017337751).cljs$core$IFn$_invoke$arity$1(opts__$1)));var opts__$2 = ((cljs.core.not.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$1)))?cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.first):cljs.core.assoc.call(null,opts__$1,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433),cljs.core.comp.call(null,new cljs.core.Keyword(null,"keyfn","keyfn",1115849433).cljs$core$IFn$_invoke$arity$1(opts__$1),cljs.core.second)));var bc = (new crate.binding.bound_collection(atm__$1,(new crate.binding.notifier(null)),opts__$2,cljs.core.sorted_map.call(null)));cljs.core.add_watch.call(null,atm__$1,cljs.core.gensym.call(null,"bound-coll"),(function (_,___$1,___$2,neue){return crate.binding.bc_compare.call(null,bc,neue);
}));
crate.binding.bc_compare.call(null,bc,cljs.core.deref.call(null,atm__$1));
return bc;
};
var map_bound = function (as,atm,var_args){
var p__15862 = null;if (arguments.length > 2) {
  p__15862 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return map_bound__delegate.call(this,as,atm,p__15862);};
map_bound.cljs$lang$maxFixedArity = 2;
map_bound.cljs$lang$applyTo = (function (arglist__15865){
var as = cljs.core.first(arglist__15865);
arglist__15865 = cljs.core.next(arglist__15865);
var atm = cljs.core.first(arglist__15865);
var p__15862 = cljs.core.rest(arglist__15865);
return map_bound__delegate(as,atm,p__15862);
});
map_bound.cljs$core$IFn$_invoke$arity$variadic = map_bound__delegate;
return map_bound;
})()
;
crate.binding.binding_QMARK_ = (function binding_QMARK_(b){var G__15867 = b;if(G__15867)
{var bit__4164__auto__ = null;if(cljs.core.truth_((function (){var or__3520__auto__ = bit__4164__auto__;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return G__15867.crate$binding$bindable$;
}
})()))
{return true;
} else
{if((!G__15867.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable,G__15867);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable,G__15867);
}
});
crate.binding.binding_coll_QMARK_ = (function binding_coll_QMARK_(b){var G__15869 = b;if(G__15869)
{var bit__4164__auto__ = null;if(cljs.core.truth_((function (){var or__3520__auto__ = bit__4164__auto__;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return G__15869.crate$binding$bindable_coll$;
}
})()))
{return true;
} else
{if((!G__15869.cljs$lang$protocol_mask$partition$))
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable_coll,G__15869);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,crate.binding.bindable_coll,G__15869);
}
});
crate.binding.deref_QMARK_ = (function deref_QMARK_(atm){var G__15871 = atm;if(G__15871)
{var bit__4164__auto__ = (G__15871.cljs$lang$protocol_mask$partition0$ & 32768);if((bit__4164__auto__) || (G__15871.cljs$core$IDeref$))
{return true;
} else
{if((!G__15871.cljs$lang$protocol_mask$partition0$))
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__15871);
} else
{return false;
}
}
} else
{return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IDeref,G__15871);
}
});
crate.binding.value = (function value(b){return crate.binding._value.call(null,b);
});
crate.binding.index = (function index(sub_atom){return cljs.core.last.call(null,sub_atom.path);
});
crate.binding.on_change = (function on_change(b,func){return crate.binding._on_change.call(null,b,func);
});
/**
* @param {...*} var_args
*/
crate.binding.bound = (function() { 
var bound__delegate = function (atm,p__15872){var vec__15874 = p__15872;var func = cljs.core.nth.call(null,vec__15874,0,null);var func__$1 = (function (){var or__3520__auto__ = func;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.identity;
}
})();return (new crate.binding.atom_binding(atm,func__$1));
};
var bound = function (atm,var_args){
var p__15872 = null;if (arguments.length > 1) {
  p__15872 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return bound__delegate.call(this,atm,p__15872);};
bound.cljs$lang$maxFixedArity = 1;
bound.cljs$lang$applyTo = (function (arglist__15875){
var atm = cljs.core.first(arglist__15875);
var p__15872 = cljs.core.rest(arglist__15875);
return bound__delegate(atm,p__15872);
});
bound.cljs$core$IFn$_invoke$arity$variadic = bound__delegate;
return bound;
})()
;
