// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.command');
goog.require('cljs.core');
goog.require('lt.object');
goog.require('lt.object');
lt.objs.command.required_keys = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"desc","desc",1016984067),null,new cljs.core.Keyword(null,"exec","exec",1017031683),null,new cljs.core.Keyword(null,"command","command",1964298941),null], null), null);
/**
* Define a command given a map with the following keys:
* 
* * :command (required) - Unique keyword name for command
* * :desc (required) - Brief description of command
* * :exec (required)  - Function to invoke when command is called
* * :hidden - When true, command is hidden from command bar. Not set by default
*/
lt.objs.command.command = (function command(cmd){if(cljs.core.every_QMARK_.call(null,cmd,lt.objs.command.required_keys))
{} else
{throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("Command doesn't have required keys: "),cljs.core.str(lt.objs.command.required_keys)].join('')),cljs.core.str("\n"),cljs.core.str(cljs.core.pr_str.call(null,cljs.core.list(new cljs.core.Symbol(null,"every?","every?",1363110461,null),new cljs.core.Symbol(null,"cmd","cmd",-1640432909,null),new cljs.core.Symbol(null,"required-keys","required-keys",-626521829,null))))].join('')));
}
lt.object.update_BANG_.call(null,lt.objs.command.manager,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"commands","commands",4706336250)], null),cljs.core.assoc,new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(cmd),cmd);
if(cljs.core.truth_(new cljs.core.Keyword(null,"options","options",4059396624).cljs$core$IFn$_invoke$arity$1(cmd)))
{lt.object.add_tags.call(null,new cljs.core.Keyword(null,"options","options",4059396624).cljs$core$IFn$_invoke$arity$1(cmd),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"command.options","command.options",1825500781)], null));
} else
{}
return lt.object.raise.call(null,lt.objs.command.manager,new cljs.core.Keyword(null,"added","added",1106564210),cmd);
});
lt.objs.command.by_id = (function by_id(k){return cljs.core.get.call(null,new cljs.core.Keyword(null,"commands","commands",4706336250).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.command.manager)),((cljs.core.map_QMARK_.call(null,k))?new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(k):k));
});
lt.objs.command.completions = (function completions(token){if(cljs.core.truth_((function (){var and__3508__auto__ = token;if(cljs.core.truth_(and__3508__auto__))
{return cljs.core._EQ_.call(null,cljs.core.subs.call(null,token,0,1),":");
} else
{return and__3508__auto__;
}
})()))
{return cljs.core.map.call(null,(function (p1__9558_SHARP_){return {"text": [cljs.core.str(new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(p1__9558_SHARP_))].join(''), "completion": [cljs.core.str(new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(p1__9558_SHARP_))].join('')};
}),cljs.core.vals.call(null,new cljs.core.Keyword(null,"commands","commands",4706336250).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.command.manager))));
} else
{return cljs.core.map.call(null,(function (p1__9559_SHARP_){if(cljs.core.not.call(null,new cljs.core.Keyword(null,"desc","desc",1016984067).cljs$core$IFn$_invoke$arity$1(p1__9559_SHARP_)))
{return {"text": [cljs.core.str(new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(p1__9559_SHARP_))].join(''), "completion": [cljs.core.str(new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(p1__9559_SHARP_))].join('')};
} else
{return {"text": new cljs.core.Keyword(null,"desc","desc",1016984067).cljs$core$IFn$_invoke$arity$1(p1__9559_SHARP_), "completion": [cljs.core.str(new cljs.core.Keyword(null,"command","command",1964298941).cljs$core$IFn$_invoke$arity$1(p1__9559_SHARP_))].join('')};
}
}),cljs.core.vals.call(null,new cljs.core.Keyword(null,"commands","commands",4706336250).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.command.manager))));
}
});
/**
* Execute a Light Table command with the given args
* @param {...*} var_args
*/
lt.objs.command.exec_BANG_ = (function() { 
var exec_BANG___delegate = function (cmd,args){var cmd__$1 = lt.objs.command.by_id.call(null,cmd);if(cljs.core.truth_((function (){var and__3508__auto__ = cmd__$1;if(cljs.core.truth_(and__3508__auto__))
{return new cljs.core.Keyword(null,"exec","exec",1017031683).cljs$core$IFn$_invoke$arity$1(cmd__$1);
} else
{return and__3508__auto__;
}
})()))
{if(cljs.core.truth_(new cljs.core.Keyword(null,"options","options",4059396624).cljs$core$IFn$_invoke$arity$1(cmd__$1)))
{return cljs.core.apply.call(null,lt.object.raise,cljs.core.first.call(null,lt.object.by_tag.call(null,new cljs.core.Keyword(null,"sidebar.command","sidebar.command",3945910827))),new cljs.core.Keyword(null,"exec!","exec!",1110854946),cmd__$1,args);
} else
{return cljs.core.apply.call(null,new cljs.core.Keyword(null,"exec","exec",1017031683).cljs$core$IFn$_invoke$arity$1(cmd__$1),args);
}
} else
{return null;
}
};
var exec_BANG_ = function (cmd,var_args){
var args = null;if (arguments.length > 1) {
  args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return exec_BANG___delegate.call(this,cmd,args);};
exec_BANG_.cljs$lang$maxFixedArity = 1;
exec_BANG_.cljs$lang$applyTo = (function (arglist__9560){
var cmd = cljs.core.first(arglist__9560);
var args = cljs.core.rest(arglist__9560);
return exec_BANG___delegate(cmd,args);
});
exec_BANG_.cljs$core$IFn$_invoke$arity$variadic = exec_BANG___delegate;
return exec_BANG_;
})()
;
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.command","command.manager","lt.objs.command/command.manager",2567370622),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"command.manager","command.manager",3910236028),null], null), null),new cljs.core.Keyword(null,"commands","commands",4706336250),cljs.core.PersistentArrayMap.EMPTY);
lt.objs.command.manager = lt.object.create.call(null,new cljs.core.Keyword("lt.objs.command","command.manager","lt.objs.command/command.manager",2567370622));
