// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.files');
goog.require('cljs.core');
goog.require('lt.util.js');
goog.require('lt.util.js');
goog.require('lt.objs.platform');
goog.require('lt.objs.platform');
goog.require('clojure.string');
goog.require('clojure.string');
goog.require('lt.util.load');
goog.require('lt.util.load');
goog.require('lt.object');
goog.require('lt.object');
lt.objs.files.fs = require("fs");
lt.objs.files.fpath = require("path");
lt.objs.files.wrench = lt.util.load.node_module.call(null,"wrench");
lt.objs.files.shell = require("shell");
lt.objs.files.os = require("os");
lt.objs.files.data_path = lt.objs.platform.get_data_path.call(null);
lt.objs.files.typelist__GT_index = (function typelist__GT_index(cur,types){var full = cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"name","name",1017277949),cljs.core.identity),types);var ext = (function (){var iter__4231__auto__ = ((function (full){
return (function iter__9055(s__9056){return (new cljs.core.LazySeq(null,((function (full){
return (function (){var s__9056__$1 = s__9056;while(true){
var temp__4092__auto__ = cljs.core.seq.call(null,s__9056__$1);if(temp__4092__auto__)
{var xs__4579__auto__ = temp__4092__auto__;var cur__$1 = cljs.core.first.call(null,xs__4579__auto__);var iterys__4227__auto__ = ((function (s__9056__$1,cur__$1,xs__4579__auto__,temp__4092__auto__,full){
return (function iter__9057(s__9058){return (new cljs.core.LazySeq(null,((function (s__9056__$1,cur__$1,xs__4579__auto__,temp__4092__auto__,full){
return (function (){var s__9058__$1 = s__9058;while(true){
var temp__4092__auto____$1 = cljs.core.seq.call(null,s__9058__$1);if(temp__4092__auto____$1)
{var s__9058__$2 = temp__4092__auto____$1;if(cljs.core.chunked_seq_QMARK_.call(null,s__9058__$2))
{var c__4229__auto__ = cljs.core.chunk_first.call(null,s__9058__$2);var size__4230__auto__ = cljs.core.count.call(null,c__4229__auto__);var b__9060 = cljs.core.chunk_buffer.call(null,size__4230__auto__);if((function (){var i__9059 = 0;while(true){
if((i__9059 < size__4230__auto__))
{var ext = cljs.core._nth.call(null,c__4229__auto__,i__9059);cljs.core.chunk_append.call(null,b__9060,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ext,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(cur__$1)], null));
{
var G__9061 = (i__9059 + 1);
i__9059 = G__9061;
continue;
}
} else
{return true;
}
break;
}
})())
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9060),iter__9057.call(null,cljs.core.chunk_rest.call(null,s__9058__$2)));
} else
{return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__9060),null);
}
} else
{var ext = cljs.core.first.call(null,s__9058__$2);return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [ext,new cljs.core.Keyword(null,"name","name",1017277949).cljs$core$IFn$_invoke$arity$1(cur__$1)], null),iter__9057.call(null,cljs.core.rest.call(null,s__9058__$2)));
}
} else
{return null;
}
break;
}
});})(s__9056__$1,cur__$1,xs__4579__auto__,temp__4092__auto__,full))
,null,null));
});})(s__9056__$1,cur__$1,xs__4579__auto__,temp__4092__auto__,full))
;var fs__4228__auto__ = cljs.core.seq.call(null,iterys__4227__auto__.call(null,new cljs.core.Keyword(null,"exts","exts",1017032164).cljs$core$IFn$_invoke$arity$1(cur__$1)));if(fs__4228__auto__)
{return cljs.core.concat.call(null,fs__4228__auto__,iter__9055.call(null,cljs.core.rest.call(null,s__9056__$1)));
} else
{{
var G__9062 = cljs.core.rest.call(null,s__9056__$1);
s__9056__$1 = G__9062;
continue;
}
}
} else
{return null;
}
break;
}
});})(full))
,null,null));
});})(full))
;return iter__4231__auto__.call(null,types);
})();return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"types","types",1124748267),cljs.core.into.call(null,new cljs.core.Keyword(null,"types","types",1124748267).cljs$core$IFn$_invoke$arity$2(cur,cljs.core.PersistentArrayMap.EMPTY),full),new cljs.core.Keyword(null,"exts","exts",1017032164),cljs.core.into.call(null,new cljs.core.Keyword(null,"exts","exts",1017032164).cljs$core$IFn$_invoke$arity$2(cur,cljs.core.PersistentArrayMap.EMPTY),ext)], null);
});
/**
* @param {...*} var_args
*/
lt.objs.files.join = (function() { 
var join__delegate = function (segs){return cljs.core.apply.call(null,lt.objs.files.fpath.join,cljs.core.filter.call(null,cljs.core.string_QMARK_,cljs.core.map.call(null,cljs.core.str,segs)));
};
var join = function (var_args){
var segs = null;if (arguments.length > 0) {
  segs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0),0);} 
return join__delegate.call(this,segs);};
join.cljs$lang$maxFixedArity = 0;
join.cljs$lang$applyTo = (function (arglist__9063){
var segs = cljs.core.seq(arglist__9063);
return join__delegate(segs);
});
join.cljs$core$IFn$_invoke$arity$variadic = join__delegate;
return join;
})()
;
lt.objs.files.ignore_pattern = /(^\..*)|\.class$|target\/|svn|cvs|\.git|\.pyc|~|\.swp|\.jar|.DS_Store/;
lt.objs.files.__BEH__file_types = (function __BEH__file_types(this$,types){return lt.object.merge_BANG_.call(null,lt.objs.files.files_obj,lt.objs.files.typelist__GT_index.call(null,cljs.core.deref.call(null,lt.objs.files.files_obj),types));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.files","file-types","lt.objs.files/file-types",772671169),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.files.__BEH__file_types,new cljs.core.Keyword(null,"desc","desc",1016984067),"Files: Associate file types",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"types",new cljs.core.Keyword(null,"example","example",3985900764),"[{:exts [:wisp],\n  :mime \"text/x-clojurescript\",\n  :name \"Wisp\",\n  :tags [:editor.wisp]}]"], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.files.__BEH__file__DOT__ignore_pattern = (function __BEH__file__DOT__ignore_pattern(this$,pattern){return lt.objs.files.ignore_pattern = (new RegExp(pattern));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.files","file.ignore-pattern","lt.objs.files/file.ignore-pattern",3559884578),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.files.__BEH__file__DOT__ignore_pattern,new cljs.core.Keyword(null,"desc","desc",1016984067),"Files: Set ignore pattern",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"pattern",new cljs.core.Keyword(null,"example","example",3985900764),"\"\\\\.git|\\\\.pyc\""], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"object.instant","object.instant",773332388),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549),new cljs.core.Keyword(null,"exclusive","exclusive",2700522000),true);
lt.objs.files.__BEH__open_failed = (function __BEH__open_failed(this$,path,e){return lt.objs.console.error([cljs.core.str("Failed to open path '"),cljs.core.str(path),cljs.core.str("' with error: "),cljs.core.str(e)].join(''));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.files","open-failed","lt.objs.files/open-failed",3548431081),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.files.__BEH__open_failed,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"files.open.error","files.open.error",1703181485),null], null), null));
lt.objs.files.files_obj = lt.object.create.call(null,lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.files","files","lt.objs.files/files",1053592914),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"files","files",1111338473)], null),new cljs.core.Keyword(null,"exts","exts",1017032164),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"types","types",1124748267),cljs.core.PersistentArrayMap.EMPTY));
/**
* Current platform-specific line
*/
lt.objs.files.line_ending = lt.objs.files.os.EOL;
/**
* Current platform-specific file separator
*/
lt.objs.files.separator = lt.objs.files.fpath.sep;
lt.objs.files.available_drives = cljs.core.PersistentHashSet.EMPTY;
/**
* Directory process is started in
*/
lt.objs.files.cwd = process.cwd();
if(cljs.core._EQ_.call(null,lt.objs.files.separator,"\\"))
{require("child_process").exec("wmic logicaldisk get name",(function (_,out,___$1){var ds = cljs.core.rest.call(null,out.split(/\r\n|\r|\n/));var ds__$1 = cljs.core.map.call(null,((function (ds){
return (function (p1__9064_SHARP_){return [cljs.core.str(p1__9064_SHARP_.trim()),cljs.core.str(lt.objs.files.separator)].join('');
});})(ds))
,cljs.core.remove.call(null,cljs.core.empty_QMARK_,ds));return lt.objs.files.available_drives = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,ds__$1);
}));
} else
{}
lt.objs.files.basename = (function() {
var basename = null;
var basename__1 = (function (path){return lt.objs.files.fpath.basename(path);
});
var basename__2 = (function (path,ext){return lt.objs.files.fpath.basename(path,ext);
});
basename = function(path,ext){
switch(arguments.length){
case 1:
return basename__1.call(this,path);
case 2:
return basename__2.call(this,path,ext);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
basename.cljs$core$IFn$_invoke$arity$1 = basename__1;
basename.cljs$core$IFn$_invoke$arity$2 = basename__2;
return basename;
})()
;
lt.objs.files.get_roots = (function get_roots(){if(cljs.core._EQ_.call(null,lt.objs.files.separator,"\\"))
{return lt.objs.files.available_drives;
} else
{return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["/",null], null), null);
}
});
lt.objs.files.get_file_parts = (function get_file_parts(path){var filename = lt.objs.files.basename.call(null,path);var file_parts = clojure.string.split.call(null,filename,/\./);var parts = file_parts;var acc = cljs.core.PersistentVector.EMPTY;while(true){
if(cljs.core.empty_QMARK_.call(null,parts))
{return acc;
} else
{{
var G__9065 = cljs.core.rest.call(null,parts);
var G__9066 = cljs.core.conj.call(null,acc,clojure.string.join.call(null,".",parts));
parts = G__9065;
acc = G__9066;
continue;
}
}
break;
}
});
lt.objs.files.ext = (function ext(path){return cljs.core.subs.call(null,lt.objs.files.fpath.extname(path),1);
});
lt.objs.files.without_ext = (function without_ext(path){var i = path.lastIndexOf(".");if((i > 0))
{return cljs.core.subs.call(null,path,0,i);
} else
{return path;
}
});
lt.objs.files.ext__GT_type = (function ext__GT_type(ext){var exts = new cljs.core.Keyword(null,"exts","exts",1017032164).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.files.files_obj));var types = new cljs.core.Keyword(null,"types","types",1124748267).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,lt.objs.files.files_obj));return types.call(null,cljs.core.get.call(null,exts,ext));
});
lt.objs.files.ext__GT_mode = (function ext__GT_mode(ext){return new cljs.core.Keyword(null,"mime","mime",1017255846).cljs$core$IFn$_invoke$arity$1(lt.objs.files.ext__GT_type.call(null,ext));
});
lt.objs.files.path__GT_type = (function path__GT_type(path){return cljs.core.first.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,(function (p1__9067_SHARP_){return lt.objs.files.ext__GT_type.call(null,cljs.core.keyword.call(null,p1__9067_SHARP_));
}),lt.objs.files.get_file_parts.call(null,path))));
});
lt.objs.files.path__GT_mode = (function path__GT_mode(path){return cljs.core.first.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.map.call(null,(function (p1__9068_SHARP_){return lt.objs.files.ext__GT_mode.call(null,cljs.core.keyword.call(null,p1__9068_SHARP_));
}),lt.objs.files.get_file_parts.call(null,path))));
});
lt.objs.files.determine_line_ending = (function determine_line_ending(text){var text__$1 = cljs.core.subs.call(null,text,0,1000);var rn = cljs.core.re_seq.call(null,/\r\n/,text__$1);var n = cljs.core.re_seq.call(null,/[^\r]\n/,text__$1);if(cljs.core.truth_((function (){var and__3508__auto__ = rn;if(cljs.core.truth_(and__3508__auto__))
{return n;
} else
{return and__3508__auto__;
}
})()))
{return lt.objs.files.line_ending;
} else
{if((cljs.core.not.call(null,rn)) && (cljs.core.not.call(null,n)))
{return lt.objs.files.line_ending;
} else
{if(cljs.core.not.call(null,n))
{return "\r\n";
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return "\n";
} else
{return null;
}
}
}
}
});
lt.objs.files.exists_QMARK_ = (function exists_QMARK_(path){return lt.objs.files.fs.existsSync(path);
});
lt.objs.files.stats = (function stats(path){if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,path)))
{return lt.objs.files.fs.statSync(path);
} else
{return null;
}
});
lt.objs.files.dir_QMARK_ = (function dir_QMARK_(path){if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,path)))
{var stat = lt.objs.files.fs.statSync(path);return stat.isDirectory();
} else
{return null;
}
});
lt.objs.files.file_QMARK_ = (function file_QMARK_(path){if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,path)))
{var stat = lt.objs.files.fs.statSync(path);return stat.isFile();
} else
{return null;
}
});
lt.objs.files.absolute_QMARK_ = (function absolute_QMARK_(path){return cljs.core.boolean$.call(null,cljs.core.re_seq.call(null,/^[\\\\/]|([\w]+:[\\\\/])/,path));
});
lt.objs.files.writable_QMARK_ = (function writable_QMARK_(path){var perm = [cljs.core.str(parseInt(lt.objs.files.fs.statSync(path).mode.toString(8),10))].join('');var perm__$1 = cljs.core.subs.call(null,perm,(cljs.core.count.call(null,perm) - 3));return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, ["2",null,"3",null,"6",null,"7",null], null), null).call(null,cljs.core.first.call(null,perm__$1));
});
lt.objs.files.resolve = (function resolve(base,cur){return lt.objs.files.fpath.resolve(base,cur);
});
lt.objs.files.real_path = (function real_path(c){return lt.objs.files.fs.realpathSync(c);
});
lt.objs.files.__GT_file_BAR_dir = (function __GT_file_BAR_dir(path,f){if(cljs.core.truth_(lt.objs.files.dir_QMARK_.call(null,[cljs.core.str(path),cljs.core.str(lt.objs.files.separator),cljs.core.str(f)].join(''))))
{return [cljs.core.str(f),cljs.core.str(lt.objs.files.separator)].join('');
} else
{return [cljs.core.str(f)].join('');
}
});
lt.objs.files.bomless_read = (function bomless_read(path){var content = lt.objs.files.fs.readFileSync(path,"utf-8");return clojure.string.replace.call(null,content,"\uFEFF","");
});
/**
* Open file and in callback return map with file's content in :content
*/
lt.objs.files.open = (function open(path,cb){try{var content = lt.objs.files.bomless_read.call(null,path);if(cljs.core.truth_(content))
{var e = lt.objs.files.ext.call(null,path);cb.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"content","content",1965434859),content,new cljs.core.Keyword(null,"line-ending","line-ending",4015468690),lt.objs.files.determine_line_ending.call(null,content),new cljs.core.Keyword(null,"type","type",1017479852),(function (){var or__3520__auto__ = lt.objs.files.path__GT_mode.call(null,path);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return e;
}
})()], null));
return lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.open","files.open",3666971347),content);
} else
{return null;
}
}catch (e9070){var e = e9070;lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.open.error","files.open.error",1703181485),path,e);
if(cljs.core.truth_(cb))
{return cb.call(null,null,e);
} else
{return null;
}
}});
/**
* Open file and return map with file's content in :content
*/
lt.objs.files.open_sync = (function open_sync(path){try{var content = lt.objs.files.bomless_read.call(null,path);if(cljs.core.truth_(content))
{var e = lt.objs.files.ext.call(null,path);lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.open","files.open",3666971347),content);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"content","content",1965434859),content,new cljs.core.Keyword(null,"line-ending","line-ending",4015468690),lt.objs.files.determine_line_ending.call(null,content),new cljs.core.Keyword(null,"type","type",1017479852),(function (){var or__3520__auto__ = lt.objs.files.ext__GT_mode.call(null,cljs.core.keyword.call(null,e));if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return e;
}
})()], null);
} else
{return null;
}
}catch (e9072){var e = e9072;lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.open.error","files.open.error",1703181485),path,e);
return null;
}});
/**
* Save path with given content. Optional callback called after save
* @param {...*} var_args
*/
lt.objs.files.save = (function() { 
var save__delegate = function (path,content,p__9073){var vec__9076 = p__9073;var cb = cljs.core.nth.call(null,vec__9076,0,null);try{lt.objs.files.fs.writeFileSync(path,content);
lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.save","files.save",3667076614),path);
if(cljs.core.truth_(cb))
{return cb.call(null);
} else
{return null;
}
}catch (e9077){var e = e9077;lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.save.error","files.save.error",2424546720),path,e);
if(cljs.core.truth_(cb))
{return cb.call(null,e);
} else
{return null;
}
}};
var save = function (path,content,var_args){
var p__9073 = null;if (arguments.length > 2) {
  p__9073 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return save__delegate.call(this,path,content,p__9073);};
save.cljs$lang$maxFixedArity = 2;
save.cljs$lang$applyTo = (function (arglist__9078){
var path = cljs.core.first(arglist__9078);
arglist__9078 = cljs.core.next(arglist__9078);
var content = cljs.core.first(arglist__9078);
var p__9073 = cljs.core.rest(arglist__9078);
return save__delegate(path,content,p__9073);
});
save.cljs$core$IFn$_invoke$arity$variadic = save__delegate;
return save;
})()
;
/**
* Append content to path. Optional callback called after append
* @param {...*} var_args
*/
lt.objs.files.append = (function() { 
var append__delegate = function (path,content,p__9079){var vec__9082 = p__9079;var cb = cljs.core.nth.call(null,vec__9082,0,null);try{lt.objs.files.fs.appendFileSync(path,content);
lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.save","files.save",3667076614),path);
if(cljs.core.truth_(cb))
{return cb.call(null);
} else
{return null;
}
}catch (e9083){var e = e9083;lt.object.raise.call(null,lt.objs.files.files_obj,new cljs.core.Keyword(null,"files.save.error","files.save.error",2424546720),path,e);
if(cljs.core.truth_(cb))
{return cb.call(null,e);
} else
{return null;
}
}};
var append = function (path,content,var_args){
var p__9079 = null;if (arguments.length > 2) {
  p__9079 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return append__delegate.call(this,path,content,p__9079);};
append.cljs$lang$maxFixedArity = 2;
append.cljs$lang$applyTo = (function (arglist__9084){
var path = cljs.core.first(arglist__9084);
arglist__9084 = cljs.core.next(arglist__9084);
var content = cljs.core.first(arglist__9084);
var p__9079 = cljs.core.rest(arglist__9084);
return append__delegate(path,content,p__9079);
});
append.cljs$core$IFn$_invoke$arity$variadic = append__delegate;
return append;
})()
;
lt.objs.files.trash_BANG_ = (function trash_BANG_(path){return lt.objs.files.shell.moveItemTotrash(path);
});
/**
* Delete file or directory
*/
lt.objs.files.delete_BANG_ = (function delete_BANG_(path){if(cljs.core.truth_(lt.objs.files.dir_QMARK_.call(null,path)))
{return lt.objs.files.wrench.rmdirSyncRecursive(path);
} else
{return lt.objs.files.fs.unlinkSync(path);
}
});
/**
* Move file or directory to given path
*/
lt.objs.files.move_BANG_ = (function move_BANG_(from,to){return lt.objs.files.fs.renameSync(from,to);
});
/**
* Copy file or directory to given path
*/
lt.objs.files.copy = (function copy(from,to){if(cljs.core.truth_(lt.objs.files.dir_QMARK_.call(null,from)))
{return lt.objs.files.wrench.copyDirSyncRecursive(from,to);
} else
{return lt.objs.files.save.call(null,to,new cljs.core.Keyword(null,"content","content",1965434859).cljs$core$IFn$_invoke$arity$1(lt.objs.files.open_sync.call(null,from)));
}
});
/**
* Make given directory
*/
lt.objs.files.mkdir = (function mkdir(path){return lt.objs.files.fs.mkdirSync(path);
});
/**
* Return directory of path
*/
lt.objs.files.parent = (function parent(path){return lt.objs.files.fpath.dirname(path);
});
lt.objs.files.next_available_name = (function next_available_name(path){if(cljs.core.not.call(null,lt.objs.files.exists_QMARK_.call(null,path)))
{return path;
} else
{var ext = lt.objs.files.ext.call(null,path);var name = lt.objs.files.without_ext.call(null,lt.objs.files.basename.call(null,path));var p = lt.objs.files.parent.call(null,path);var x = 1;var cur = lt.objs.files.join.call(null,p,[cljs.core.str(name),cljs.core.str(x),cljs.core.str("."),cljs.core.str(ext)].join(''));while(true){
if(cljs.core.not.call(null,lt.objs.files.exists_QMARK_.call(null,cur)))
{return cur;
} else
{{
var G__9085 = (x + 1);
var G__9086 = lt.objs.files.join.call(null,p,[cljs.core.str(name),cljs.core.str((x + 1)),cljs.core.str((cljs.core.truth_(ext)?[cljs.core.str("."),cljs.core.str(ext)].join(''):null))].join(''));
x = G__9085;
cur = G__9086;
continue;
}
}
break;
}
}
});
/**
* Return directory's files
*/
lt.objs.files.ls = (function() {
var ls = null;
var ls__1 = (function (path){return ls.call(null,path,null);
});
var ls__2 = (function (path,cb){try{var fs = cljs.core.map.call(null,cljs.core.partial.call(null,lt.objs.files.__GT_file_BAR_dir,path),lt.objs.files.fs.readdirSync(path));if(cljs.core.truth_(cb))
{return cb.call(null,fs);
} else
{return fs;
}
}catch (e9088){var e = e9088;if(cljs.core.truth_(cb))
{cb.call(null,null);
} else
{}
return null;
}});
ls = function(path,cb){
switch(arguments.length){
case 1:
return ls__1.call(this,path);
case 2:
return ls__2.call(this,path,cb);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
ls.cljs$core$IFn$_invoke$arity$1 = ls__1;
ls.cljs$core$IFn$_invoke$arity$2 = ls__2;
return ls;
})()
;
/**
* Return directory's files applying ignore-pattern. Takes map of options with keys:
* 
* * :files - When set only returns files
* * :dirs - When set only return directories
*/
lt.objs.files.ls_sync = (function ls_sync(path,opts){try{var fs = cljs.core.remove.call(null,(function (p1__9089_SHARP_){return cljs.core.re_seq.call(null,lt.objs.files.ignore_pattern,p1__9089_SHARP_);
}),cljs.core.map.call(null,cljs.core.partial.call(null,lt.objs.files.__GT_file_BAR_dir,path),lt.objs.files.fs.readdirSync(path)));if(cljs.core.truth_(new cljs.core.Keyword(null,"files","files",1111338473).cljs$core$IFn$_invoke$arity$1(opts)))
{return cljs.core.filter.call(null,(function (p1__9090_SHARP_){return lt.objs.files.file_QMARK_.call(null,lt.objs.files.join.call(null,path,p1__9090_SHARP_));
}),fs);
} else
{if(cljs.core.truth_(new cljs.core.Keyword(null,"dirs","dirs",1016987896).cljs$core$IFn$_invoke$arity$1(opts)))
{return cljs.core.filter.call(null,(function (p1__9091_SHARP_){return lt.objs.files.dir_QMARK_.call(null,lt.objs.files.join.call(null,path,p1__9091_SHARP_));
}),fs);
} else
{if(new cljs.core.Keyword(null,"else","else",1017020587))
{return fs;
} else
{return null;
}
}
}
}catch (e9093){var e = e9093;return lt.objs.console.error(e);
}});
/**
* Return directory's files as full paths
*/
lt.objs.files.full_path_ls = (function full_path_ls(path){try{return cljs.core.doall.call(null,cljs.core.map.call(null,cljs.core.partial.call(null,lt.objs.files.join,path),lt.objs.files.fs.readdirSync(path)));
}catch (e9095){var e = e9095;return lt.objs.console.error(e);
}});
/**
* Return directory's directories
*/
lt.objs.files.dirs = (function dirs(path){try{return cljs.core.filter.call(null,lt.objs.files.dir_QMARK_,cljs.core.map.call(null,cljs.core.partial.call(null,lt.objs.files.join,path),lt.objs.files.fs.readdirSync(path)));
}catch (e9097){var e = e9097;return lt.objs.console.error(e);
}});
/**
* Return users' home directory (e.g. ~/) or path under it
*/
lt.objs.files.home = (function() {
var home = null;
var home__0 = (function (){return home.call(null,null);
});
var home__1 = (function (path){var h = ((cljs.core._EQ_.call(null,process.platform,"win32"))?process.env.USERPROFILE:process.env.HOME);return lt.objs.files.join.call(null,h,(function (){var or__3520__auto__ = path;if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return lt.objs.files.separator;
}
})());
});
home = function(path){
switch(arguments.length){
case 0:
return home__0.call(this);
case 1:
return home__1.call(this,path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
home.cljs$core$IFn$_invoke$arity$0 = home__0;
home.cljs$core$IFn$_invoke$arity$1 = home__1;
return home;
})()
;
/**
* Return LT's home directory
*/
lt.objs.files.lt_home = (function() {
var lt_home = null;
var lt_home__0 = (function (){return lt.util.load.dir;
});
var lt_home__1 = (function (path){return lt.objs.files.join.call(null,lt_home.call(null),path);
});
lt_home = function(path){
switch(arguments.length){
case 0:
return lt_home__0.call(this);
case 1:
return lt_home__1.call(this,path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
lt_home.cljs$core$IFn$_invoke$arity$0 = lt_home__0;
lt_home.cljs$core$IFn$_invoke$arity$1 = lt_home__1;
return lt_home;
})()
;
/**
* Return LT's user directory. Used for storing user-related content e.g.
* settings, plugins, logs and caches
*/
lt.objs.files.lt_user_dir = (function() {
var lt_user_dir = null;
var lt_user_dir__0 = (function (){return lt_user_dir.call(null,"");
});
var lt_user_dir__1 = (function (path){if(cljs.core.truth_(process.env.LT_USER_DIR))
{return lt.objs.files.join.call(null,process.env.LT_USER_DIR,path);
} else
{return lt.objs.files.join.call(null,lt.objs.files.data_path,path);
}
});
lt_user_dir = function(path){
switch(arguments.length){
case 0:
return lt_user_dir__0.call(this);
case 1:
return lt_user_dir__1.call(this,path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
lt_user_dir.cljs$core$IFn$_invoke$arity$0 = lt_user_dir__0;
lt_user_dir.cljs$core$IFn$_invoke$arity$1 = lt_user_dir__1;
return lt_user_dir;
})()
;
/**
* Starting at start path, walk up parent directories and return first path
* whose basename matches find
*/
lt.objs.files.walk_up_find = (function walk_up_find(start,find){var roots = lt.objs.files.get_roots.call(null);var cur = start;var prev = "";while(true){
if(cljs.core.truth_((function (){var or__3520__auto__ = cljs.core.empty_QMARK_.call(null,cur);if(or__3520__auto__)
{return or__3520__auto__;
} else
{var or__3520__auto____$1 = roots.call(null,cur);if(cljs.core.truth_(or__3520__auto____$1))
{return or__3520__auto____$1;
} else
{return cljs.core._EQ_.call(null,cur,prev);
}
}
})()))
{return null;
} else
{if(cljs.core.truth_(lt.objs.files.exists_QMARK_.call(null,lt.objs.files.join.call(null,cur,find))))
{return lt.objs.files.join.call(null,cur,find);
} else
{{
var G__9098 = lt.objs.files.parent.call(null,cur);
var G__9099 = cur;
cur = G__9098;
prev = G__9099;
continue;
}
}
}
break;
}
});
lt.objs.files.relative = (function relative(a,b){return lt.objs.files.fpath.relative(a,b);
});
/**
* @param {...*} var_args
*/
lt.objs.files.__GT_name_BAR_path = (function() { 
var __GT_name_BAR_path__delegate = function (f,p__9100){var vec__9102 = p__9100;var rel = cljs.core.nth.call(null,vec__9102,0,null);var path = (cljs.core.truth_(rel)?lt.objs.files.relative.call(null,rel,f):f);return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lt.objs.files.fpath.basename(f),path], null);
};
var __GT_name_BAR_path = function (f,var_args){
var p__9100 = null;if (arguments.length > 1) {
  p__9100 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return __GT_name_BAR_path__delegate.call(this,f,p__9100);};
__GT_name_BAR_path.cljs$lang$maxFixedArity = 1;
__GT_name_BAR_path.cljs$lang$applyTo = (function (arglist__9103){
var f = cljs.core.first(arglist__9103);
var p__9100 = cljs.core.rest(arglist__9103);
return __GT_name_BAR_path__delegate(f,p__9100);
});
__GT_name_BAR_path.cljs$core$IFn$_invoke$arity$variadic = __GT_name_BAR_path__delegate;
return __GT_name_BAR_path;
})()
;
lt.objs.files.path_segs = (function path_segs(path){var segs = path.split(lt.objs.files.separator);var segs__$1 = (cljs.core.truth_((function (){var or__3520__auto__ = lt.objs.files.fpath.extname(cljs.core.last.call(null,segs));if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return cljs.core.empty_QMARK_.call(null,cljs.core.last.call(null,segs));
}
})())?cljs.core.butlast.call(null,segs):segs);return cljs.core.vec.call(null,cljs.core.map.call(null,(function (p1__9104_SHARP_){return [cljs.core.str(p1__9104_SHARP_),cljs.core.str(lt.objs.files.separator)].join('');
}),segs__$1));
});
lt.objs.files.filter_walk = (function filter_walk(func,path){var to_walk = lt.objs.files.dirs.call(null,path);var found = cljs.core.filterv.call(null,func,lt.objs.files.full_path_ls.call(null,path));while(true){
if(cljs.core.not.call(null,cljs.core.seq.call(null,to_walk)))
{return found;
} else
{var cur = cljs.core.first.call(null,to_walk);var neue = cljs.core.filterv.call(null,func,lt.objs.files.full_path_ls.call(null,cur));{
var G__9105 = cljs.core.concat.call(null,cljs.core.rest.call(null,to_walk),lt.objs.files.dirs.call(null,cur));
var G__9106 = cljs.core.concat.call(null,found,neue);
to_walk = G__9105;
found = G__9106;
continue;
}
}
break;
}
});
