// Compiled by ClojureScript 0.0-2138
goog.provide('lt.util.dom');
goog.require('cljs.core');
lt.util.dom.lazy_nl_via_item = (function() {
var lazy_nl_via_item = null;
var lazy_nl_via_item__1 = (function (nl){return lazy_nl_via_item.call(null,nl,0);
});
var lazy_nl_via_item__2 = (function (nl,n){if((n < nl.length))
{return (new cljs.core.LazySeq(null,(function (){return cljs.core.cons.call(null,nl.item(n),lazy_nl_via_item.call(null,nl,(n + 1)));
}),null,null));
} else
{return null;
}
});
lazy_nl_via_item = function(nl,n){
switch(arguments.length){
case 1:
return lazy_nl_via_item__1.call(this,nl);
case 2:
return lazy_nl_via_item__2.call(this,nl,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
lazy_nl_via_item.cljs$core$IFn$_invoke$arity$1 = lazy_nl_via_item__1;
lazy_nl_via_item.cljs$core$IFn$_invoke$arity$2 = lazy_nl_via_item__2;
return lazy_nl_via_item;
})()
;
HTMLCollection.prototype.cljs$core$IIndexed$ = true;
HTMLCollection.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){var this$__$1 = this;return this$__$1.item(n);
});
HTMLCollection.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){var this$__$1 = this;var or__3520__auto__ = this$__$1.item(n);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return not_found;
}
});
HTMLCollection.prototype.cljs$core$ICounted$ = true;
HTMLCollection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){var this$__$1 = this;return this$__$1.length;
});
HTMLCollection.prototype.cljs$core$ISeqable$ = true;
HTMLCollection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){var this$__$1 = this;return lt.util.dom.lazy_nl_via_item.call(null,this$__$1);
});
NodeList.prototype.cljs$core$IIndexed$ = true;
NodeList.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){var this$__$1 = this;return this$__$1.item(n);
});
NodeList.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){var this$__$1 = this;var or__3520__auto__ = this$__$1.item(n);if(cljs.core.truth_(or__3520__auto__))
{return or__3520__auto__;
} else
{return not_found;
}
});
NodeList.prototype.cljs$core$ICounted$ = true;
NodeList.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){var this$__$1 = this;return this$__$1.length;
});
NodeList.prototype.cljs$core$ISeqable$ = true;
NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){var this$__$1 = this;return lt.util.dom.lazy_nl_via_item.call(null,this$__$1);
});
lt.util.dom.text_node = (function text_node(text){return document.createTextNode(text);
});
lt.util.dom.$$ = (function() {
var $$ = null;
var $$__1 = (function (query){return $$.call(null,query,document);
});
var $$__2 = (function (query,elem){return elem.querySelectorAll(cljs.core.name.call(null,query));
});
$$ = function(query,elem){
switch(arguments.length){
case 1:
return $$__1.call(this,query);
case 2:
return $$__2.call(this,query,elem);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
$$.cljs$core$IFn$_invoke$arity$1 = $$__1;
$$.cljs$core$IFn$_invoke$arity$2 = $$__2;
return $$;
})()
;
lt.util.dom.$ = (function() {
var $ = null;
var $__1 = (function (query){return $.call(null,query,document);
});
var $__2 = (function (query,elem){return elem.querySelector(cljs.core.name.call(null,query));
});
$ = function(query,elem){
switch(arguments.length){
case 1:
return $__1.call(this,query);
case 2:
return $__2.call(this,query,elem);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
$.cljs$core$IFn$_invoke$arity$1 = $__1;
$.cljs$core$IFn$_invoke$arity$2 = $__2;
return $;
})()
;
lt.util.dom.append = (function append(parent,child){parent.appendChild(child);
return parent;
});
lt.util.dom.prepend = (function prepend(parent,child){if(cljs.core.truth_(parent.firstChild))
{return parent.insertBefore(child,parent.firstChild);
} else
{return lt.util.dom.append.call(null,parent,child);
}
});
lt.util.dom.add_class = (function add_class(elem,class$){if(cljs.core.truth_((function (){var and__3508__auto__ = elem;if(cljs.core.truth_(and__3508__auto__))
{return !(cljs.core.empty_QMARK_.call(null,cljs.core.name.call(null,class$)));
} else
{return and__3508__auto__;
}
})()))
{return elem.classList.add(cljs.core.name.call(null,class$));
} else
{return null;
}
});
lt.util.dom.remove_class = (function remove_class(elem,class$){if(cljs.core.truth_((function (){var and__3508__auto__ = elem;if(cljs.core.truth_(and__3508__auto__))
{return !(cljs.core.empty_QMARK_.call(null,cljs.core.name.call(null,class$)));
} else
{return and__3508__auto__;
}
})()))
{return elem.classList.remove(cljs.core.name.call(null,class$));
} else
{return null;
}
});
lt.util.dom.has_class_QMARK_ = (function has_class_QMARK_(elem,class$){if(cljs.core.truth_((function (){var and__3508__auto__ = elem;if(cljs.core.truth_(and__3508__auto__))
{return !(cljs.core.empty_QMARK_.call(null,cljs.core.name.call(null,class$)));
} else
{return and__3508__auto__;
}
})()))
{return elem.classList.contains(cljs.core.name.call(null,class$));
} else
{return null;
}
});
lt.util.dom.toggle_class = (function toggle_class(elem,class$){if(cljs.core.truth_(lt.util.dom.has_class_QMARK_.call(null,elem,class$)))
{return lt.util.dom.remove_class.call(null,elem,class$);
} else
{return lt.util.dom.add_class.call(null,elem,class$);
}
});
lt.util.dom.set_css = (function set_css(elem,things){var seq__5522 = cljs.core.seq.call(null,things);var chunk__5523 = null;var count__5524 = 0;var i__5525 = 0;while(true){
if((i__5525 < count__5524))
{var vec__5526 = cljs.core._nth.call(null,chunk__5523,i__5525);var k = cljs.core.nth.call(null,vec__5526,0,null);var v = cljs.core.nth.call(null,vec__5526,1,null);(elem.style[cljs.core.name.call(null,k)] = (((v instanceof cljs.core.Keyword))?cljs.core.name.call(null,v):v));
{
var G__5528 = seq__5522;
var G__5529 = chunk__5523;
var G__5530 = count__5524;
var G__5531 = (i__5525 + 1);
seq__5522 = G__5528;
chunk__5523 = G__5529;
count__5524 = G__5530;
i__5525 = G__5531;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5522);if(temp__4092__auto__)
{var seq__5522__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5522__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__5522__$1);{
var G__5532 = cljs.core.chunk_rest.call(null,seq__5522__$1);
var G__5533 = c__4262__auto__;
var G__5534 = cljs.core.count.call(null,c__4262__auto__);
var G__5535 = 0;
seq__5522 = G__5532;
chunk__5523 = G__5533;
count__5524 = G__5534;
i__5525 = G__5535;
continue;
}
} else
{var vec__5527 = cljs.core.first.call(null,seq__5522__$1);var k = cljs.core.nth.call(null,vec__5527,0,null);var v = cljs.core.nth.call(null,vec__5527,1,null);(elem.style[cljs.core.name.call(null,k)] = (((v instanceof cljs.core.Keyword))?cljs.core.name.call(null,v):v));
{
var G__5536 = cljs.core.next.call(null,seq__5522__$1);
var G__5537 = null;
var G__5538 = 0;
var G__5539 = 0;
seq__5522 = G__5536;
chunk__5523 = G__5537;
count__5524 = G__5538;
i__5525 = G__5539;
continue;
}
}
} else
{return null;
}
}
break;
}
});
lt.util.dom.css = (function css(elem,things){var things__$1 = ((cljs.core._EQ_.call(null,Object,cljs.core.type.call(null,things)))?cljs.core.js__GT_clj.call(null,things):things);if(cljs.core.map_QMARK_.call(null,things__$1))
{return lt.util.dom.set_css.call(null,elem,things__$1);
} else
{return (elem.style[cljs.core.name.call(null,things__$1)]);
}
});
lt.util.dom.set_attr = (function set_attr(elem,things){var seq__5546 = cljs.core.seq.call(null,things);var chunk__5547 = null;var count__5548 = 0;var i__5549 = 0;while(true){
if((i__5549 < count__5548))
{var vec__5550 = cljs.core._nth.call(null,chunk__5547,i__5549);var k = cljs.core.nth.call(null,vec__5550,0,null);var v = cljs.core.nth.call(null,vec__5550,1,null);elem.setAttribute(cljs.core.name.call(null,k),(((v instanceof cljs.core.Keyword))?cljs.core.name.call(null,v):v));
{
var G__5552 = seq__5546;
var G__5553 = chunk__5547;
var G__5554 = count__5548;
var G__5555 = (i__5549 + 1);
seq__5546 = G__5552;
chunk__5547 = G__5553;
count__5548 = G__5554;
i__5549 = G__5555;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5546);if(temp__4092__auto__)
{var seq__5546__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5546__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__5546__$1);{
var G__5556 = cljs.core.chunk_rest.call(null,seq__5546__$1);
var G__5557 = c__4262__auto__;
var G__5558 = cljs.core.count.call(null,c__4262__auto__);
var G__5559 = 0;
seq__5546 = G__5556;
chunk__5547 = G__5557;
count__5548 = G__5558;
i__5549 = G__5559;
continue;
}
} else
{var vec__5551 = cljs.core.first.call(null,seq__5546__$1);var k = cljs.core.nth.call(null,vec__5551,0,null);var v = cljs.core.nth.call(null,vec__5551,1,null);elem.setAttribute(cljs.core.name.call(null,k),(((v instanceof cljs.core.Keyword))?cljs.core.name.call(null,v):v));
{
var G__5560 = cljs.core.next.call(null,seq__5546__$1);
var G__5561 = null;
var G__5562 = 0;
var G__5563 = 0;
seq__5546 = G__5560;
chunk__5547 = G__5561;
count__5548 = G__5562;
i__5549 = G__5563;
continue;
}
}
} else
{return null;
}
}
break;
}
});
lt.util.dom.attr = (function attr(elem,things){if(cljs.core.map_QMARK_.call(null,things))
{return lt.util.dom.set_attr.call(null,elem,things);
} else
{return elem.getAttribute(cljs.core.name.call(null,things));
}
});
lt.util.dom.parent = (function parent(elem){return elem.parentNode;
});
lt.util.dom.children = (function children(elem){return elem.children;
});
lt.util.dom.remove = (function remove(elem){var temp__4092__auto__ = lt.util.dom.parent.call(null,elem);if(cljs.core.truth_(temp__4092__auto__))
{var p = temp__4092__auto__;return p.removeChild(elem);
} else
{return null;
}
});
lt.util.dom.empty = (function empty(elem){return elem.innerHTML = "";
});
/**
* @param {...*} var_args
*/
lt.util.dom.val = (function() { 
var val__delegate = function (elem,p__5564){var vec__5566 = p__5564;var v = cljs.core.nth.call(null,vec__5566,0,null);if(cljs.core.not.call(null,v))
{return elem.value;
} else
{return elem.value = v;
}
};
var val = function (elem,var_args){
var p__5564 = null;if (arguments.length > 1) {
  p__5564 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return val__delegate.call(this,elem,p__5564);};
val.cljs$lang$maxFixedArity = 1;
val.cljs$lang$applyTo = (function (arglist__5567){
var elem = cljs.core.first(arglist__5567);
var p__5564 = cljs.core.rest(arglist__5567);
return val__delegate(elem,p__5564);
});
val.cljs$core$IFn$_invoke$arity$variadic = val__delegate;
return val;
})()
;
lt.util.dom.prevent = (function prevent(e){return e.preventDefault();
});
lt.util.dom.stop_propagation = (function stop_propagation(e){return e.stopPropagation();
});
lt.util.dom.siblings = (function siblings(elem){return lt.util.dom.parent.call(null,elem).children;
});
lt.util.dom.parents = (function parents(elem,sel){var root = lt.util.dom.parent.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)));var p = lt.util.dom.parent.call(null,elem);while(true){
if(cljs.core.truth_((function (){var and__3508__auto__ = p;if(cljs.core.truth_(and__3508__auto__))
{return cljs.core.not_EQ_.call(null,p,root);
} else
{return and__3508__auto__;
}
})()))
{if(cljs.core.truth_(p.webkitMatchesSelector(cljs.core.name.call(null,sel))))
{return p;
} else
{{
var G__5568 = lt.util.dom.parent.call(null,p);
p = G__5568;
continue;
}
}
} else
{return null;
}
break;
}
});
lt.util.dom.next = (function next(elem){return elem.nextElementSibling;
});
lt.util.dom.before = (function before(elem,neue){return lt.util.dom.parent.call(null,elem).insertBefore(neue,elem);
});
lt.util.dom.after = (function after(elem,neue){var temp__4090__auto__ = lt.util.dom.next.call(null,elem);if(cljs.core.truth_(temp__4090__auto__))
{var n = temp__4090__auto__;return lt.util.dom.before.call(null,n,neue);
} else
{return lt.util.dom.append.call(null,lt.util.dom.parent.call(null,elem),neue);
}
});
lt.util.dom.replace_with = (function replace_with(orig,neue){var temp__4092__auto__ = lt.util.dom.parent.call(null,orig);if(cljs.core.truth_(temp__4092__auto__))
{var p = temp__4092__auto__;return p.replaceChild(neue,orig);
} else
{return null;
}
});
lt.util.dom.height = (function height(elem){return elem.clientHeight;
});
lt.util.dom.width = (function width(elem){return elem.clientWidth;
});
lt.util.dom.scroll_width = (function scroll_width(elem){return elem.scrollWidth;
});
lt.util.dom.offset_top = (function offset_top(elem){return elem.offsetTop;
});
/**
* @param {...*} var_args
*/
lt.util.dom.scroll_top = (function() { 
var scroll_top__delegate = function (elem,p__5569){var vec__5571 = p__5569;var v = cljs.core.nth.call(null,vec__5571,0,null);if(cljs.core.not.call(null,v))
{return elem.scrollTop;
} else
{return elem.scrollTop = v;
}
};
var scroll_top = function (elem,var_args){
var p__5569 = null;if (arguments.length > 1) {
  p__5569 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return scroll_top__delegate.call(this,elem,p__5569);};
scroll_top.cljs$lang$maxFixedArity = 1;
scroll_top.cljs$lang$applyTo = (function (arglist__5572){
var elem = cljs.core.first(arglist__5572);
var p__5569 = cljs.core.rest(arglist__5572);
return scroll_top__delegate(elem,p__5569);
});
scroll_top.cljs$core$IFn$_invoke$arity$variadic = scroll_top__delegate;
return scroll_top;
})()
;
lt.util.dom.top = (function top(elem){return lt.util.dom.css.call(null,elem,new cljs.core.Keyword(null,"top","top",1014019271));
});
lt.util.dom.bottom = (function bottom(elem){return lt.util.dom.css.call(null,elem,new cljs.core.Keyword(null,"bottom","bottom",3925642653));
});
lt.util.dom.left = (function left(elem){return lt.util.dom.css.call(null,elem,new cljs.core.Keyword(null,"left","left",1017222009));
});
lt.util.dom.right = (function right(elem){return lt.util.dom.css.call(null,elem,new cljs.core.Keyword(null,"right","right",1122416014));
});
/**
* @param {...*} var_args
*/
lt.util.dom.html = (function() { 
var html__delegate = function (elem,p__5573){var vec__5575 = p__5573;var h = cljs.core.nth.call(null,vec__5575,0,null);if(cljs.core.not.call(null,h))
{return elem.innerHTML;
} else
{return elem.innerHTML = h;
}
};
var html = function (elem,var_args){
var p__5573 = null;if (arguments.length > 1) {
  p__5573 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return html__delegate.call(this,elem,p__5573);};
html.cljs$lang$maxFixedArity = 1;
html.cljs$lang$applyTo = (function (arglist__5576){
var elem = cljs.core.first(arglist__5576);
var p__5573 = cljs.core.rest(arglist__5576);
return html__delegate(elem,p__5573);
});
html.cljs$core$IFn$_invoke$arity$variadic = html__delegate;
return html;
})()
;
lt.util.dom.__GT_ev = (function __GT_ev(ev){return [cljs.core.str(cljs.core.name.call(null,ev))].join('');
});
/**
* @param {...*} var_args
*/
lt.util.dom.trigger = (function() { 
var trigger__delegate = function (elem,ev,p__5577){var vec__5579 = p__5577;var opts = cljs.core.nth.call(null,vec__5579,0,null);var e = document.createEvent("HTMLEvents");e.initEvent(cljs.core.name.call(null,ev),true,true);
e.opts = opts;
return elem.dispatchEvent(e);
};
var trigger = function (elem,ev,var_args){
var p__5577 = null;if (arguments.length > 2) {
  p__5577 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2),0);} 
return trigger__delegate.call(this,elem,ev,p__5577);};
trigger.cljs$lang$maxFixedArity = 2;
trigger.cljs$lang$applyTo = (function (arglist__5580){
var elem = cljs.core.first(arglist__5580);
arglist__5580 = cljs.core.next(arglist__5580);
var ev = cljs.core.first(arglist__5580);
var p__5577 = cljs.core.rest(arglist__5580);
return trigger__delegate(elem,ev,p__5577);
});
trigger.cljs$core$IFn$_invoke$arity$variadic = trigger__delegate;
return trigger;
})()
;
lt.util.dom.on = (function on(elem,ev,cb){return elem.addEventListener(lt.util.dom.__GT_ev.call(null,ev),cb);
});
lt.util.dom.off = (function off(elem,ev,cb){return elem.removeEventListener(lt.util.dom.__GT_ev.call(null,ev),cb);
});
lt.util.dom.on_STAR_ = (function on_STAR_(elem,evs){var seq__5587 = cljs.core.seq.call(null,evs);var chunk__5588 = null;var count__5589 = 0;var i__5590 = 0;while(true){
if((i__5590 < count__5589))
{var vec__5591 = cljs.core._nth.call(null,chunk__5588,i__5590);var ev = cljs.core.nth.call(null,vec__5591,0,null);var cb = cljs.core.nth.call(null,vec__5591,1,null);elem.addEventListener(lt.util.dom.__GT_ev.call(null,ev),cb);
{
var G__5593 = seq__5587;
var G__5594 = chunk__5588;
var G__5595 = count__5589;
var G__5596 = (i__5590 + 1);
seq__5587 = G__5593;
chunk__5588 = G__5594;
count__5589 = G__5595;
i__5590 = G__5596;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__5587);if(temp__4092__auto__)
{var seq__5587__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5587__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__5587__$1);{
var G__5597 = cljs.core.chunk_rest.call(null,seq__5587__$1);
var G__5598 = c__4262__auto__;
var G__5599 = cljs.core.count.call(null,c__4262__auto__);
var G__5600 = 0;
seq__5587 = G__5597;
chunk__5588 = G__5598;
count__5589 = G__5599;
i__5590 = G__5600;
continue;
}
} else
{var vec__5592 = cljs.core.first.call(null,seq__5587__$1);var ev = cljs.core.nth.call(null,vec__5592,0,null);var cb = cljs.core.nth.call(null,vec__5592,1,null);elem.addEventListener(lt.util.dom.__GT_ev.call(null,ev),cb);
{
var G__5601 = cljs.core.next.call(null,seq__5587__$1);
var G__5602 = null;
var G__5603 = 0;
var G__5604 = 0;
seq__5587 = G__5601;
chunk__5588 = G__5602;
count__5589 = G__5603;
i__5590 = G__5604;
continue;
}
}
} else
{return null;
}
}
break;
}
});
lt.util.dom.active_element = (function active_element(){return document.activeElement;
});
lt.util.dom.focus = (function focus(elem){return elem.focus();
});
lt.util.dom.blur = (function blur(elem){return elem.blur();
});
lt.util.dom.selection = (function selection(elem,start,stop,dir){return elem.setSelectionRange(start,stop,dir);
});
lt.util.dom.make = (function make(str){var d = document.createElement("div");lt.util.dom.html.call(null,d,str);
return lt.util.dom.children.call(null,d);
});
lt.util.dom.index = (function index(e){var p = lt.util.dom.parent.call(null,e);var c = (cljs.core.truth_(p)?lt.util.dom.children.call(null,p):[]);var len = c.length;if(cljs.core.not.call(null,p))
{return -1;
} else
{var i = 0;while(true){
if((i >= len))
{return null;
} else
{if(cljs.core._EQ_.call(null,(c[i]),e))
{return i;
} else
{{
var G__5605 = (i + 1);
i = G__5605;
continue;
}
}
}
break;
}
}
});
lt.util.dom.ready = (function ready(func){return lt.util.dom.on.call(null,document,new cljs.core.Keyword(null,"DOMContentLoaded","DOMContentLoaded",3783578446),func);
});
lt.util.dom.fragment = (function fragment(items){var frag = document.createDocumentFragment();var seq__5610_5614 = cljs.core.seq.call(null,items);var chunk__5611_5615 = null;var count__5612_5616 = 0;var i__5613_5617 = 0;while(true){
if((i__5613_5617 < count__5612_5616))
{var i_5618 = cljs.core._nth.call(null,chunk__5611_5615,i__5613_5617);frag.appendChild(i_5618);
{
var G__5619 = seq__5610_5614;
var G__5620 = chunk__5611_5615;
var G__5621 = count__5612_5616;
var G__5622 = (i__5613_5617 + 1);
seq__5610_5614 = G__5619;
chunk__5611_5615 = G__5620;
count__5612_5616 = G__5621;
i__5613_5617 = G__5622;
continue;
}
} else
{var temp__4092__auto___5623 = cljs.core.seq.call(null,seq__5610_5614);if(temp__4092__auto___5623)
{var seq__5610_5624__$1 = temp__4092__auto___5623;if(cljs.core.chunked_seq_QMARK_.call(null,seq__5610_5624__$1))
{var c__4262__auto___5625 = cljs.core.chunk_first.call(null,seq__5610_5624__$1);{
var G__5626 = cljs.core.chunk_rest.call(null,seq__5610_5624__$1);
var G__5627 = c__4262__auto___5625;
var G__5628 = cljs.core.count.call(null,c__4262__auto___5625);
var G__5629 = 0;
seq__5610_5614 = G__5626;
chunk__5611_5615 = G__5627;
count__5612_5616 = G__5628;
i__5613_5617 = G__5629;
continue;
}
} else
{var i_5630 = cljs.core.first.call(null,seq__5610_5624__$1);frag.appendChild(i_5630);
{
var G__5631 = cljs.core.next.call(null,seq__5610_5624__$1);
var G__5632 = null;
var G__5633 = 0;
var G__5634 = 0;
seq__5610_5614 = G__5631;
chunk__5611_5615 = G__5632;
count__5612_5616 = G__5633;
i__5613_5617 = G__5634;
continue;
}
}
} else
{}
}
break;
}
return frag;
});
