/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.linux;

import com.lightcrafts.platform.DefaultFileChooser;
import com.lightcrafts.utils.file.FileUtil;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;

class LinuxFileChooser
extends DefaultFileChooser {
    LinuxFileChooser() {
    }

    public File openFile(String windowTitle, File directory, Frame parent, FilenameFilter filter) {
        int result;
        File file = null;
        JFileChooser chooser = new JFileChooser(directory);
        if (windowTitle != null) {
            chooser.setDialogTitle(windowTitle);
        }
        if ((result = chooser.showOpenDialog(parent)) == 0) {
            file = chooser.getSelectedFile();
        }
        return file;
    }

    public File saveFile(File file, Frame parent) {
        String extension = FileUtil.getExtensionOf((File)file);
        JFileChooser chooser = new JFileChooser(file);
        chooser.setSelectedFile(file);
        int result = chooser.showSaveDialog(parent);
        if (result == 0) {
            file = chooser.getSelectedFile();
            String dirPath = file.getParent();
            String fileName = file.getName();
            if (dirPath != null && fileName != null) {
                File newFile = new File(dirPath, fileName);
                String newExtension = FileUtil.getExtensionOf((File)newFile);
                if (newExtension == null) {
                    return new File(newFile.getAbsolutePath() + "." + extension);
                }
                if (!newExtension.equals(extension)) {
                    String path = FileUtil.replaceExtensionOf((File)newFile, (String)extension);
                    return new File(path);
                }
                return newFile;
            }
        }
        return null;
    }
}

