/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform.linux;

import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.linux.LinuxFileChooser;
import com.lightcrafts.platform.linux.LinuxKeyUtil;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.Version;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.color.ICC_Profile;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.JHelp;
import javax.swing.JFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class LinuxPlatform
extends Platform {
    private static final String home = System.getProperty("user.home");
    private static final File SystemProfileDir = new File("/usr/share/color/icc");
    private static final File UserProfileDir = new File(home, ".color/icc");
    private static Collection<ColorProfileInfo> Profiles;

    public File getDefaultImageDirectory() {
        ProcessBuilder pb = new ProcessBuilder("xdg-user-dir", "PICTURES");
        try {
            Process p = pb.start();
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = br.readLine();
            br.close();
            p.waitFor();
            p.destroy();
            if (p.exitValue() == 0 && line != null && !line.equals(home)) {
                return new File(line);
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new File(home, Version.getApplicationName());
    }

    public File getLightZoneDocumentsDirectory() {
        String appName = Version.getApplicationName();
        String path = ".local/share/" + appName;
        return new File(home, path);
    }

    public LookAndFeel getLookAndFeel() {
        return LightZoneSkin.getLightZoneLookAndFeel();
    }

    public FileChooser getFileChooser() {
        return new LinuxFileChooser();
    }

    public ICC_Profile getDisplayProfile() {
        Preferences prefs = Preferences.userRoot().node("/com/lightcrafts/platform/linux");
        String path = prefs.get("DisplayProfile", null);
        if (path != null) {
            try {
                return ICC_Profile.getInstance(path);
            }
            catch (Throwable e) {
                System.err.println("Malformed display profile at " + path);
            }
        }
        return null;
    }

    public Collection<ColorProfileInfo> getPrinterProfiles() {
        return LinuxPlatform.getColorProfiles();
    }

    public Collection<ColorProfileInfo> getExportProfiles() {
        return LinuxPlatform.getColorProfiles();
    }

    public boolean isKeyPressed(int keyCode) {
        return LinuxKeyUtil.isKeyPressed(keyCode);
    }

    private static Collection<ColorProfileInfo> getColorProfiles() {
        if (Profiles != null) {
            return Profiles;
        }
        Profiles = new HashSet<ColorProfileInfo>();
        Profiles.addAll(LinuxPlatform.getColorProfiles(SystemProfileDir));
        Profiles.addAll(LinuxPlatform.getColorProfiles(UserProfileDir));
        return Profiles;
    }

    private static Collection<ColorProfileInfo> getColorProfiles(File profileDir) {
        HashSet<ColorProfileInfo> profiles = new HashSet<ColorProfileInfo>();
        if (!profileDir.isDirectory()) {
            return profiles;
        }
        File[] files = profileDir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            String message;
            if (file.isDirectory()) {
                profiles.addAll(LinuxPlatform.getColorProfiles(file));
                continue;
            }
            if (!file.isFile()) continue;
            String path = file.getAbsolutePath();
            try {
                ICC_Profile profile = ICC_Profile.getInstance(path);
                String name = ColorProfileInfo.getNameOf((ICC_Profile)profile);
                ColorProfileInfo info = new ColorProfileInfo(name, path);
                profiles.add(info);
            }
            catch (IOException e) {
                message = e.getMessage();
                System.err.println("Can't read a color profile from " + path + ": " + message);
            }
            catch (Throwable e) {
                message = e.getMessage();
                System.err.println("Not a valid color profile at " + path + ": " + message);
            }
        }
        return profiles;
    }

    public int getPhysicalMemoryInMB() {
        String regex;
        String[] cmd;
        String osname = System.getProperty("os.name");
        if (osname.indexOf("Linux") >= 0) {
            cmd = new String[]{"cat", "/proc/meminfo"};
            regex = "MemTotal: *([0-9]*) .*";
        } else if (osname.indexOf("SunOS") >= 0) {
            cmd = new String[]{"prtconf"};
            regex = "Memory size: *([0-9]*) .*";
        } else {
            cmd = new String[]{"dmesg"};
            regex = "real memory *([0-9]*) .*";
        }
        Pattern pattern = Pattern.compile(regex);
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            InputStream in = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(in);
            BufferedReader buffer = new BufferedReader(reader);
            String line = buffer.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    String text = matcher.replaceAll("$1");
                    int i = Integer.parseInt(text);
                    if (osname.indexOf("Linux") >= 0) {
                        return i / 1024;
                    }
                    if (osname.indexOf("SunOS") >= 0) {
                        return i;
                    }
                    return i / 0x100000;
                }
                line = buffer.readLine();
            }
            buffer.close();
        }
        catch (IOException e) {
            System.err.println("Can't get memory size: " + e.getMessage());
        }
        catch (NumberFormatException e) {
            System.err.println("Malformed memory size text: " + e.getMessage());
        }
        return super.getPhysicalMemoryInMB();
    }

    public void loadLibraries() throws UnsatisfiedLinkError {
        System.loadLibrary("Linux");
    }

    public void makeModal(Dialog dialog) {
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public boolean showFileInFolder(String path) {
        File file = new File(path);
        if (file.isFile()) {
            path = file.getParent();
        }
        String[] fileManagers = new String[]{"nautilus", "dolphin", "konqueror", "nemo", "caja", "thunar", "pcmanfm", "rox-filer"};
        try {
            Runtime rt = Runtime.getRuntime();
            for (String fileManager : fileManagers) {
                String[] args = new String[]{"which", fileManager};
                if (rt.exec(args).waitFor() != 0) continue;
                args = new String[]{fileManager, path};
                rt.exec(args);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void showHelpTopic(String topic) {
        try {
            URL url = HelpSet.findHelpSet(null, (String)"LightZone.hs");
            HelpSet help = new HelpSet(null, url);
            String title = help.getTitle();
            JHelp jhelp = new JHelp(help);
            help.setHomeID("index");
            try {
                jhelp.setCurrentID(topic);
            }
            catch (Throwable t) {
                jhelp.setCurrentID("index");
            }
            JFrame frame = new JFrame();
            frame.setTitle(title);
            frame.setContentPane((Container)jhelp);
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);
        }
        catch (HelpSetException e) {
            LinuxPlatform.getPlatform().getAlertDialog().showAlert(null, "Couldn't initialize the LightZone help system.", ((Object)((Object)e)).getClass().getName() + ": " + e.getMessage(), 2, new String[]{"OK"});
        }
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        Platform platform = Platform.getPlatform();
        platform.loadLibraries();
        System.out.println(platform.getPhysicalMemoryInMB());
        UIManager.setLookAndFeel(platform.getLookAndFeel());
        platform.showHelpTopic("New_Features");
    }
}

