/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.BrowserLayout;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.ComboLayout;
import com.lightcrafts.app.EditorLayout;
import com.lightcrafts.app.LayoutHeader;
import com.lightcrafts.ui.browser.ctrls.FolderCtrl;
import com.lightcrafts.ui.browser.view.ImageBrowserScrollPane;
import com.lightcrafts.ui.editor.DocUndoHistory;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.layout.FadingTabConfiguration;
import com.lightcrafts.ui.layout.FadingTabbedPanel;
import com.lightcrafts.ui.layout.FadingTabbedPanelListener;
import com.lightcrafts.ui.layout.SmartSplitPane;
import com.lightcrafts.ui.metadata2.MetadataScroll;
import com.lightcrafts.ui.templates.TemplateControl;
import java.awt.Dimension;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JPanel;

public abstract class AbstractLayout
extends JPanel {
    private LayoutType type;
    static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private static final String LayoutKey = "Layout";
    private static final String ComboValue = "Combo";
    private static final String BrowserValue = "Browser";
    private static final String EditorValue = "Editor";
    private static final String LeftFaderTabKey = "LeftFaderTab";
    private static final String RightFaderTabKey = "RightFaderTab";
    static final int LeftDividerLoc = -1;
    static final int RightDividerLoc = -1;
    static final String LeftDividerKey = "leftDividerLocation";
    static final String RightDividerKey = "rightDividerLocation";
    static final int MinRightFaderWidth = 330;
    static final int MaxRightFaderWidth = 480;
    static final int MinLeftFaderWidth = 200;
    static final int MaxLeftFaderWidth = 400;
    final String NoLabel = "NoTabSelected";
    SmartSplitPane leftSplit;
    SmartSplitPane rightSplit;
    FadingTabbedPanel leftFader;
    FadingTabbedPanel rightFader;
    TemplateControl templates;
    Editor editor;
    DocUndoHistory history;
    FolderCtrl folders;
    ImageBrowserScrollPane browser;
    MetadataScroll info;
    LayoutHeader header;
    boolean isBrowserRotated;

    static AbstractLayout createRecentLayout(TemplateControl templates, Editor editor, DocUndoHistory history, FolderCtrl folders, ImageBrowserScrollPane browser, MetadataScroll info, LayoutHeader header, ComboFrame frame) {
        switch (AbstractLayout.getRecentLayoutType()) {
            case Browser: {
                return new BrowserLayout(templates, editor, history, folders, browser, info, header, frame);
            }
            case Editor: {
                return new EditorLayout(templates, editor, history, folders, browser, info, header);
            }
            case Combo: {
                return new ComboLayout(templates, editor, history, folders, browser, info, header, frame);
            }
        }
        return new BrowserLayout(templates, editor, history, folders, browser, info, header, frame);
    }

    static LayoutType getRecentLayoutType() {
        String recent = Prefs.get(LayoutKey, BrowserValue);
        if (recent.equals(BrowserValue)) {
            return LayoutType.Browser;
        }
        if (recent.equals(EditorValue)) {
            return LayoutType.Editor;
        }
        if (recent.equals(ComboValue)) {
            return LayoutType.Editor;
        }
        return LayoutType.Browser;
    }

    AbstractLayout(LayoutType type, TemplateControl templates, Editor editor, DocUndoHistory history, FolderCtrl folders, ImageBrowserScrollPane browser, MetadataScroll info, LayoutHeader header) {
        this.type = type;
        this.templates = templates;
        this.editor = editor;
        this.history = history;
        this.folders = folders;
        this.browser = browser;
        this.info = info;
        this.header = header;
        switch (type) {
            case Browser: {
                Prefs.put(LayoutKey, BrowserValue);
                break;
            }
            case Editor: {
                Prefs.put(LayoutKey, EditorValue);
                break;
            }
            default: {
                Prefs.put(LayoutKey, ComboValue);
            }
        }
        this.leftSplit = new SmartSplitPane(LeftDividerKey, "left");
        this.rightSplit = new SmartSplitPane(RightDividerKey, "right");
    }

    void restoreLayout() {
        this.leftSplit.restoreFromPrefs(-1, 1);
        this.rightSplit.restoreFromPrefs(-1, 1);
        this.restoreFaders();
    }

    LayoutType getLayoutType() {
        return this.type;
    }

    void updateEditor(TemplateControl templates, Editor editor, DocUndoHistory history, MetadataScroll info) {
        this.templates = templates;
        this.editor = editor;
        this.history = history;
        this.info = info;
    }

    abstract void updateBrowser();

    abstract List<FadingTabConfiguration> getLeftFaderConfs();

    abstract List<FadingTabConfiguration> getRightFaderConfs();

    abstract String getDefaultLeftFaderTab();

    abstract String getDefaultRightFaderTab();

    void initFaders() {
        List<FadingTabConfiguration> leftTabs = this.getLeftFaderConfs();
        this.leftFader = new FadingTabbedPanel(leftTabs, FadingTabbedPanel.Orientation.Up, new FadingTabbedPanelListener(){

            @Override
            public void somethingSelected() {
                AbstractLayout.this.leftSplit.unhide();
            }

            @Override
            public void tabSelected(String name) {
                Prefs.put((Object)((Object)AbstractLayout.this.type) + AbstractLayout.LeftFaderTabKey, name);
            }

            @Override
            public void nothingSelected() {
                AbstractLayout.this.leftSplit.hideLeft();
                Prefs.put((Object)((Object)AbstractLayout.this.type) + AbstractLayout.LeftFaderTabKey, "NoTabSelected");
            }
        });
        List<FadingTabConfiguration> rightTabs = this.getRightFaderConfs();
        this.rightFader = new FadingTabbedPanel(rightTabs, FadingTabbedPanel.Orientation.Down, new FadingTabbedPanelListener(){

            @Override
            public void somethingSelected() {
                AbstractLayout.this.rightSplit.unhide();
            }

            @Override
            public void tabSelected(String name) {
                Prefs.put((Object)((Object)AbstractLayout.this.type) + AbstractLayout.RightFaderTabKey, name);
            }

            @Override
            public void nothingSelected() {
                AbstractLayout.this.rightSplit.hideRight();
                Prefs.put((Object)((Object)AbstractLayout.this.type) + AbstractLayout.RightFaderTabKey, "NoTabSelected");
            }
        });
    }

    void dispose() {
        this.info.endEditing();
    }

    private void restoreFaders() {
        String leftDefault = this.getDefaultLeftFaderTab();
        String left = Prefs.get((Object)((Object)this.type) + LeftFaderTabKey, leftDefault);
        if (left.equals("NoTabSelected")) {
            this.leftSplit.hideLeft();
        } else {
            this.leftFader.setSelected(left);
        }
        String rightDefault = this.getDefaultRightFaderTab();
        String right = Prefs.get((Object)((Object)this.type) + RightFaderTabKey, rightDefault);
        if (right.equals("NoTabSelected")) {
            this.rightSplit.hideRight();
        } else {
            this.rightFader.setSelected(right);
        }
        this.constrainFaderWidths();
    }

    private void constrainFaderWidths() {
        Dimension size = this.leftFader.getMinimumSize();
        size = new Dimension(Math.max(200, size.width), size.height);
        this.leftFader.setMinimumSize(size);
        size = this.leftFader.getMaximumSize();
        size = new Dimension(Math.min(400, size.width), size.height);
        this.leftFader.setMaximumSize(size);
        size = this.rightFader.getMinimumSize();
        size = new Dimension(Math.max(330, size.width), size.height);
        this.rightFader.setMinimumSize(size);
        size = this.rightFader.getMaximumSize();
        size = new Dimension(Math.min(480, size.width), size.height);
        this.rightFader.setMaximumSize(size);
    }

    public static enum LayoutType {
        Combo,
        Browser,
        Editor;

    }
}

