/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import java.awt.EventQueue;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Map;

class AwtWatchdog
extends Thread {
    private static long DequeueLimit = 2000L;
    private static long ThreadDumpLimit = 15000L;
    private static NumberFormat TimeFormat = new DecimalFormat("0.000");
    private static AwtWatchdog Instance;
    private boolean invoked;
    private boolean cancelled;

    private AwtWatchdog() {
        super("AWT Watchdog");
        this.setDaemon(true);
    }

    static void spawn() {
        if (Instance == null) {
            Instance = new AwtWatchdog();
            Instance.start();
        }
    }

    static void deSpawn() {
        if (Instance != null) {
            Instance.cancel();
        }
    }

    static void dumpThreads() {
        Map<Thread, StackTraceElement[]> stacks = Thread.getAllStackTraces();
        for (Thread thread : stacks.keySet()) {
            StackTraceElement[] stack;
            System.out.println(thread.getName() + ": " + (Object)((Object)thread.getState()));
            for (StackTraceElement frame : stack = stacks.get(thread)) {
                System.out.println("\tat " + frame);
            }
        }
    }

    @Override
    public void run() {
        while (!this.cancelled) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AwtWatchdog.this.invoked = true;
                }
            });
            long start = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(DequeueLimit);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.invoked) continue;
                long time = System.currentTimeMillis();
                String s = TimeFormat.format((double)(time - start) / 1000.0);
                String message = "EventThread blocked for " + s + " seconds";
                System.err.println(message);
                if (time - start <= ThreadDumpLimit || System.getProperty("lightcrafts.debug") != null) continue;
                AwtWatchdog.dumpThreads();
            } while (!this.invoked);
            this.invoked = false;
        }
    }

    void cancel() {
        this.cancelled = true;
    }
}

