/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.util.prefs.Preferences;

class BrowserSelectionMemory {
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private static final String Key = "BrowserSelectionMemory";

    BrowserSelectionMemory() {
    }

    static void setRememberedFile(File file) {
        File folder = file.getParentFile();
        String key = BrowserSelectionMemory.getKeyForFolder(folder);
        file = FileUtil.resolveAliasFile(file);
        String path = file.getAbsolutePath();
        Prefs.put(key, path);
    }

    static File getRememberedFile(File folder) {
        String key = BrowserSelectionMemory.getKeyForFolder(folder);
        String path = Prefs.get(key, null);
        return path != null ? new File(path) : null;
    }

    private static String getKeyForFolder(File folder) {
        folder = FileUtil.resolveAliasFile(folder);
        return Key + folder.getAbsolutePath().hashCode();
    }
}

