/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.Locale;
import com.lightcrafts.app.other.LightroomApplication;
import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.app.other.UnknownApplication;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.Engine;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DocumentWriter {
    public static boolean save(Document doc, ComboFrame frame, boolean saveDirectly, ProgressThread progress) throws IOException {
        XmlDocument xml = new XmlDocument("http://www.lightcrafts.com/lightzone/LightZoneTransform", "LightZoneTransform");
        XmlNode root = xml.getRoot();
        doc.save(root);
        try {
            SaveOptions options = doc.getSaveOptions();
            if (!options.isLzn()) {
                Engine engine = doc.getEngine();
                ImageExportOptions export = SaveOptions.getExportOptions(options);
                OtherApplication app = (OtherApplication)doc.getSource();
                if (options.isSidecarJpeg() || options.isSidecarTiff()) {
                    if (app instanceof LightroomApplication) {
                        File file = LightroomApplication.getOriginalFile(options.getFile());
                        DocumentWriter.mangleLznSidecarFile(xml, file);
                    }
                    DocumentWriter.addLznMetadata(export, xml);
                } else if (options.isMultilayerTiff()) {
                    DocumentWriter.mangleLznMultilayerTiff(xml);
                    DocumentWriter.addLznMetadata(export, xml);
                }
                String message = Locale.LOCALE.get("SavingMessage");
                if (app != null && app != UnknownApplication.INSTANCE && saveDirectly) {
                    String name = app.getName();
                    message = Locale.LOCALE.get("SavingToMessage", name);
                }
                if (progress != null) {
                    DocumentWriter.export(engine, export, progress);
                    return true;
                }
                return DocumentWriter.exportWithDialog(engine, export, message, frame);
            }
            frame.pause();
            DocumentWriter.saveLzn(doc, xml);
            frame.resume();
        }
        catch (XMLException e) {
            throw new IOException("Internal error in XML mangling: " + e.getMessage());
        }
        return true;
    }

    static boolean exportWithDialog(final Engine engine, final ImageExportOptions options, String title, Frame parent) throws IOException {
        ProgressDialog dialog = Platform.getPlatform().getProgressDialog();
        ProgressThread thread = new ProgressThread(dialog){

            @Override
            public void run() {
                try {
                    DocumentWriter.export(engine, options, this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        dialog.showProgress(parent, thread, title, 0, 10, true);
        Throwable error = dialog.getThrown();
        if (error != null) {
            if (error instanceof IOException) {
                throw (IOException)error;
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RuntimeException(error);
        }
        return !thread.isCanceled();
    }

    static void saveLzn(Document doc, XmlDocument xmlDoc) throws IOException {
        Engine engine = doc.getEngine();
        SaveOptions options = doc.getSaveOptions();
        File file = options.getFile();
        FileOutputStream out = new FileOutputStream(file);
        xmlDoc.write(out);
        ((OutputStream)out).close();
        Object thumb = engine.getRendering(new Dimension(320, 320));
        thumb = new CachedImage((PlanarImage)thumb, JAIContext.fileCache);
        ImageInfo info = ImageInfo.getInstanceFor(file);
        LZNImageType.INSTANCE.putImage(info, (RenderedImage)thumb);
        int size = 1536;
        Object preview = engine.getRendering(new Dimension(size, size));
        preview = new CachedImage((PlanarImage)preview, JAIContext.fileCache);
        PreviewUpdater.cachePreviewForImage(file, preview);
    }

    private static void addLznMetadata(ImageExportOptions export, XmlDocument xml) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        xml.write(out);
        byte[] bytes = out.toByteArray();
        export.setAuxData(bytes);
    }

    private static void mangleLznSidecarFile(XmlDocument xml, File file) throws XMLException {
        XmlNode root = xml.getRoot();
        XmlNode imageNode = root.getChild("Image");
        imageNode.setAttribute("path", file.getAbsolutePath());
        imageNode.setAttribute("relativePath", file.getName());
    }

    private static void mangleLznMultilayerTiff(XmlDocument xml) throws XMLException {
        XmlNode root = xml.getRoot();
        XmlNode imageNode = root.getChild("Image");
        imageNode.setAttribute("path", "");
        imageNode.setAttribute("relativePath", "");
        imageNode.setAttribute("self", "true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(Engine engine, ImageExportOptions options, ProgressThread progress) throws IOException {
        File tempFile = null;
        try {
            boolean renameOK;
            File exportFile = options.getExportFile();
            File exportDir = exportFile.getParentFile();
            tempFile = File.createTempFile("LZExport", ".tmp", exportDir);
            options.setExportFile(tempFile);
            engine.write(progress, options);
            options.setExportFile(exportFile);
            if (exportFile.exists()) {
                boolean deleteOK = exportFile.delete();
                if (!deleteOK) {
                    ImageInfo.closeAll();
                    deleteOK = exportFile.delete();
                }
                if (!deleteOK) {
                    throw new IOException(Locale.LOCALE.get("ExportDeleteError", exportFile.getPath()));
                }
            }
            if (!(renameOK = tempFile.renameTo(exportFile))) {
                ImageInfo.closeAll();
                renameOK = tempFile.renameTo(exportFile);
            }
            if (!renameOK) {
                throw new IOException(Locale.LOCALE.get("ExportRenameError", tempFile.getPath(), exportFile.getPath()));
            }
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }
}

