/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.Locale;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDialog
extends JOptionPane {
    private static final String RegularMessage = Locale.LOCALE.get("CrashRegularMessage");
    private static final String MemoryMessage = Locale.LOCALE.get("CrashMemoryMessage");
    private static final String DetailsMessage = Locale.LOCALE.get("CrashDetailsMessage");
    private static final String SaveMessage = Locale.LOCALE.get("CrashSaveMessage");
    private static final String ContinueMessage = Locale.LOCALE.get("CrashContinueMessage");
    private static final String ExitMessage = Locale.LOCALE.get("CrashExitMessage");
    private static boolean isDisplayed;
    private JTextArea message = new JTextArea();
    private JTextArea trace;
    private JButton detailsButton;
    private JScrollPane detailsScroll;
    private JRadioButton saveButton;
    private JRadioButton contButton;
    private JRadioButton exitButton;

    public ExceptionDialog() {
        this.message.setBackground(this.getBackground());
        this.message.setWrapStyleWord(true);
        this.message.setRows(1);
        this.message.setLineWrap(true);
        this.message.setEditable(false);
        this.message.setBorder(null);
        this.trace = new JTextArea();
        this.trace.setRows(20);
        this.trace.setColumns(100);
        this.trace.setEditable(true);
        this.trace.setLineWrap(false);
        this.trace.setEditable(false);
        Font font = new Font("Monospaced", 0, 12);
        this.trace.setFont(font);
        this.detailsButton = new JButton(DetailsMessage);
        this.detailsScroll = new JScrollPane(this.trace);
        this.saveButton = new JRadioButton(SaveMessage);
        this.contButton = new JRadioButton(ContinueMessage);
        this.exitButton = new JRadioButton(ExitMessage);
        this.saveButton.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.saveButton);
        group.add(this.contButton);
        group.add(this.exitButton);
        Box buttonBox = Box.createHorizontalBox();
        Box buttonSubBox = Box.createVerticalBox();
        buttonSubBox.add(this.saveButton);
        buttonSubBox.add(this.contButton);
        buttonSubBox.add(this.exitButton);
        buttonBox.add(buttonSubBox);
        buttonBox.add(Box.createHorizontalGlue());
        Box box = Box.createVerticalBox();
        box.add(this.message);
        box.add(Box.createVerticalStrut(12));
        box.add(buttonBox);
        box.add(Box.createVerticalStrut(12));
        box.add(Box.createVerticalStrut(12));
        this.setMessage(box);
        this.setOptions(new Object[]{this.detailsButton, Locale.LOCALE.get("CrashOk")});
        this.setInitialValue(Locale.LOCALE.get("CrashOk"));
        this.setMessageType(0);
    }

    public void handle(Throwable t) {
        t.printStackTrace();
        if (System.getProperty("dieOnError") != null) {
            System.exit(-1);
        }
        this.showError(null, t);
    }

    private void setText(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            this.message.setText(MemoryMessage);
        } else {
            this.message.setText(RegularMessage);
        }
        StringWriter buffer = new StringWriter();
        PrintWriter writer = new PrintWriter(buffer);
        t.printStackTrace(writer);
        this.trace.setText(buffer.toString());
        this.trace.revalidate();
    }

    static void installHandler() {
        System.setProperty("sun.awt.exception.handler", ExceptionDialog.class.getName());
    }

    static void uninstallHandler() {
        System.setProperty("sun.awt.exception.handler", null);
    }

    void showError(Component parent, Throwable t) {
        if (isDisplayed) {
            return;
        }
        this.setText(t);
        this.trace.setCaretPosition(0);
        this.createDialog(null, "");
        final JDialog display = this.createDialog(parent, Locale.LOCALE.get("CrashTitle"));
        ActionListener detailsAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane pane = new JOptionPane(ExceptionDialog.this.detailsScroll);
                JDialog details = pane.createDialog(display, Locale.LOCALE.get("CrashDetailTitle"));
                details.setVisible(true);
            }
        };
        this.detailsButton.addActionListener(detailsAction);
        isDisplayed = true;
        display.setVisible(true);
        isDisplayed = false;
        this.detailsButton.removeActionListener(detailsAction);
        if (this.saveButton.isSelected()) {
            try {
                Application.saveAll();
                System.exit(-1);
            }
            catch (Throwable throwable) {
                System.exit(-1);
            }
        } else if (!this.contButton.isSelected() && this.exitButton.isSelected()) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) throws Exception {
        ExceptionDialog.installHandler();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Display Me");
            }
        });
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                throw new RuntimeException("Suppress Me");
            }
        });
    }
}

