/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app;

import com.lightcrafts.app.BrowseEditButtons;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.DoneButton;
import com.lightcrafts.app.EditButton;
import com.lightcrafts.app.ExportButton;
import com.lightcrafts.app.ExportDocButton;
import com.lightcrafts.app.FrameButton;
import com.lightcrafts.app.HelpButton;
import com.lightcrafts.app.Locale;
import com.lightcrafts.app.OpenButton;
import com.lightcrafts.app.PrintButton;
import com.lightcrafts.app.PrintDocButton;
import com.lightcrafts.app.RedoButton;
import com.lightcrafts.app.RevertButton;
import com.lightcrafts.app.SaveButton;
import com.lightcrafts.app.SendButton;
import com.lightcrafts.app.StylesButton;
import com.lightcrafts.app.UndoButton;
import com.lightcrafts.ui.layout.ToggleTitleBorder;
import com.lightcrafts.ui.toolkit.BoxedButton;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

class LayoutHeader
extends Box {
    private BrowseEditButtons modes;
    private BoxedButton help;
    private HelpButton helpButton;
    private BoxedButton browse;
    private BoxedButton printDoc;
    private BoxedButton exportDoc;
    private BoxedButton save;
    private BoxedButton revert;
    private BoxedButton undoRedo;
    private BoxedButton edit;
    private BoxedButton send;
    private BoxedButton print;
    private BoxedButton export;
    private BoxedButton styles;
    private BoxedButton open;
    private List<BoxedButton> buttonList;
    private Box buttonBox;

    LayoutHeader(ComboFrame frame) {
        super(0);
        this.modes = new BrowseEditButtons(frame);
        this.buttonBox = Box.createHorizontalBox();
        JComponent[] jComponentArray = new JComponent[1];
        this.helpButton = new HelpButton();
        jComponentArray[0] = this.helpButton;
        this.help = new BoxedButton(Locale.LOCALE.get("HelpLabel"), jComponentArray);
        LogoComponent logoButton = new LogoComponent();
        this.add(Box.createHorizontalStrut(22));
        this.add(this.modes);
        this.add(Box.createHorizontalStrut(64));
        this.add(this.buttonBox);
        this.add(Box.createHorizontalGlue());
        this.add(logoButton);
        this.add(Box.createHorizontalStrut(16));
        this.add(this.help.box);
        this.add(Box.createHorizontalStrut(4));
        this.buttonList = new LinkedList<BoxedButton>();
        this.browse = new BoxedButton(Locale.LOCALE.get("DoneLabel"), new DoneButton(frame));
        this.buttonList.add(this.browse);
        this.printDoc = new BoxedButton(Locale.LOCALE.get("PrintLabel"), new PrintDocButton(frame));
        this.buttonList.add(this.printDoc);
        this.exportDoc = new BoxedButton(Locale.LOCALE.get("ExportLabel"), new ExportDocButton(frame));
        this.buttonList.add(this.exportDoc);
        this.save = new BoxedButton(Locale.LOCALE.get("SaveLabel"), new SaveButton(frame));
        this.buttonList.add(this.save);
        this.revert = new BoxedButton(Locale.LOCALE.get("RevertLabel"), new RevertButton(frame));
        this.buttonList.add(this.revert);
        this.undoRedo = new BoxedButton(Locale.LOCALE.get("UndoRedoLabel"), new UndoButton(frame), new RedoButton(frame));
        this.buttonList.add(this.undoRedo);
        this.edit = new BoxedButton(Locale.LOCALE.get("EditLabel"), new EditButton(frame));
        this.buttonList.add(this.edit);
        this.send = new BoxedButton(Locale.LOCALE.get("SendLabel"), new SendButton(frame));
        this.buttonList.add(this.send);
        this.print = new BoxedButton(Locale.LOCALE.get("PrintLabel"), new PrintButton(frame));
        this.buttonList.add(this.print);
        this.export = new BoxedButton(Locale.LOCALE.get("ConvertLabel"), new ExportButton(frame));
        this.buttonList.add(this.export);
        this.styles = new BoxedButton(Locale.LOCALE.get("StylesLabel"), new StylesButton(frame));
        this.buttonList.add(this.styles);
        this.open = new BoxedButton(Locale.LOCALE.get("OpenLabel"), new OpenButton(frame));
        this.buttonList.add(this.open);
    }

    void setBrowseSelected() {
        this.modes.setBrowseSelected();
        this.buttonBox.removeAll();
        this.addButton(this.open.box);
        this.addButton(this.edit.box);
        this.addButton(this.print.box);
        JSeparator separator = new JSeparator(1);
        separator.setMaximumSize(new Dimension(3, 32));
        this.buttonBox.add(separator);
        this.buttonBox.add(Box.createHorizontalStrut(8));
        this.addButton(this.styles.box);
        this.addButton(this.send.box);
        this.addButton(this.export.box);
        this.helpButton.setMode(HelpButton.Mode.Browse);
    }

    void setEditSelected() {
        this.modes.setEditSelected();
        this.buttonBox.removeAll();
        this.addButton(this.undoRedo.box);
        this.addButton(this.revert.box);
        this.addButton(this.browse.box);
        this.helpButton.setMode(HelpButton.Mode.Edit);
    }

    void addButtons(Container container) {
        this.buttonBox.add(container);
    }

    void removeButtons() {
        int index = this.buttonBox.getComponentCount() - 1;
        if (index >= 0) {
            this.buttonBox.remove(index);
        }
    }

    private void addButton(JComponent button) {
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(8));
    }

    void update() {
        for (BoxedButton boxedButton : this.buttonList) {
            for (JComponent button : boxedButton.buttons) {
                if (!(button instanceof JButton)) continue;
                ((FrameButton)button).updateButton();
            }
        }
    }

    void dispose() {
        ToggleTitleBorder.unsetAllBorders(this);
        for (BoxedButton button : this.buttonList) {
            ToggleTitleBorder.unsetBorder(button.box);
        }
    }

    static class LogoComponent
    extends JComponent {
        private static final Icon lzLogo;

        LogoComponent() {
            this.setBorder(new EmptyBorder(8, 2, 8, 2));
            this.setMinimumSize(this.getPreferredSize());
            this.setMaximumSize(this.getPreferredSize());
        }

        @Override
        protected void paintComponent(Graphics g) {
            lzLogo.paintIcon(this, g, 0, 8);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(lzLogo.getIconWidth(), lzLogo.getIconHeight() + 12);
        }

        static {
            ImageIcon tmp = null;
            try {
                URL url = LayoutHeader.class.getResource("resources/LZLogo.png");
                BufferedImage image = ImageIO.read(url);
                tmp = new ImageIcon(image);
            }
            catch (Exception exception) {
                // empty catch block
            }
            lzLogo = tmp;
        }
    }
}

