/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.app.batch.BatchConfig;
import com.lightcrafts.app.batch.Locale;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.export.ExportMultiControls;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BatchConfigurator {
    private static boolean started;

    public static BatchConfig showDialog(File[] files, Frame parent, boolean isBatchExport) {
        final JDialog dialog = new JDialog(parent);
        final BatchConfig config = new BatchConfig();
        String saveKey = isBatchExport ? "Export" : "Apply";
        config.restoreFromPrefs(saveKey);
        if (!isBatchExport || config.directory == null) {
            config.directory = files[0].getParentFile();
        }
        final JTextField dirLabel = new JTextField(config.directory.getName());
        dirLabel.setEditable(false);
        JButton dirButton = new JButton(Locale.LOCALE.get("BatchConfOutputChooserButton"));
        dirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Platform platform = Platform.getPlatform();
                FileChooser chooser = platform.getFileChooser();
                File directory = chooser.chooseDirectory(Locale.LOCALE.get("BatchConfOutputChooserDialogTitle"), config.directory, dialog, false);
                if (directory != null) {
                    config.directory = directory;
                    String name = directory.getName();
                    dirLabel.setText(name);
                }
            }
        });
        final JTextField batchLabel = new JTextField(config.name);
        batchLabel.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                config.name = batchLabel.getText();
            }
        });
        batchLabel.setPreferredSize(new Dimension(160, batchLabel.getPreferredSize().height));
        batchLabel.setMaximumSize(batchLabel.getPreferredSize());
        ExportMultiControls exportCtrls = new ExportMultiControls(config.export, dialog, false);
        JButton start = new JButton(Locale.LOCALE.get("BatchConfStartButton"));
        start.setAlignmentX(0.5f);
        JButton cancel = new JButton(Locale.LOCALE.get("BatchConfCancelButton"));
        cancel.setAlignmentX(0.5f);
        started = false;
        ActionListener disposeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        };
        start.addActionListener(disposeAction);
        cancel.addActionListener(disposeAction);
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                started = true;
            }
        });
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalGlue());
        buttons.add(start);
        buttons.add(Box.createHorizontalStrut(8));
        buttons.add(cancel);
        buttons.setMaximumSize(buttons.getPreferredSize());
        JPanel batchLabelBox = new JPanel();
        batchLabelBox.setLayout(new BoxLayout(batchLabelBox, 0));
        batchLabelBox.add(batchLabel);
        batchLabelBox.setBorder(BorderFactory.createTitledBorder(Locale.LOCALE.get("BatchConfNameLabel")));
        Box batchBox = Box.createHorizontalBox();
        batchBox.add(batchLabelBox);
        batchBox.add(Box.createHorizontalGlue());
        JPanel dirBox = new JPanel();
        dirBox.setLayout(new BoxLayout(dirBox, 0));
        if (isBatchExport) {
            dirBox.add(new JLabel(Locale.LOCALE.get("BatchConfExportOutputLabel")));
        } else {
            dirBox.add(new JLabel(Locale.LOCALE.get("BatchConfSaveOutputLabel")));
        }
        dirBox.add(Box.createHorizontalStrut(8));
        dirBox.add(dirLabel);
        dirBox.add(Box.createHorizontalStrut(8));
        dirBox.add(dirButton);
        Box dirBoxBox = Box.createHorizontalBox();
        dirBoxBox.add(dirBox);
        dirBoxBox.add(Box.createHorizontalGlue());
        exportCtrls.setBorder(BorderFactory.createTitledBorder(Locale.LOCALE.get("BatchConfFormatBorder")));
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        content.add(dirBoxBox);
        content.add(Box.createVerticalStrut(8));
        content.add(batchBox);
        content.add(Box.createVerticalStrut(8));
        content.add(exportCtrls);
        content.add(Box.createVerticalStrut(8));
        content.add(buttons);
        content.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        content.registerKeyboardAction(disposeAction, KeyStroke.getKeyStroke(27, 0), 2);
        dialog.setContentPane(content);
        dialog.getRootPane().setDefaultButton(start);
        dialog.setModal(true);
        dialog.setTitle(Locale.LOCALE.get("BatchConfDialogTitle"));
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (started) {
            config.export = (ImageFileExportOptions)exportCtrls.getSelectedExportOptions();
            config.saveToPrefs(saveKey);
            return config;
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(Platform.getPlatform().getLookAndFeel());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                File[] files = new File[100];
                for (int n = 0; n < 100; ++n) {
                    files[n] = new File("/a/b/" + n + ".lzn");
                }
                BatchConfigurator.showDialog(files, null, false);
                System.exit(0);
            }
        });
    }
}

