/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.AffineDescriptor;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageTask;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.filecache.FileCacheFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

class BatchImageComponent
extends JComponent {
    static final Dimension ImageSize = new Dimension(150, 150);
    private RenderedImage image;

    BatchImageComponent() {
        this.setLayout(null);
        this.setPreferredSize(ImageSize);
        this.setMinimumSize(ImageSize);
        this.setMaximumSize(ImageSize);
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.gray), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.image == null) {
            Dimension size = this.getSize();
            Insets insets = this.getInsets();
            g.setColor(LightZoneSkin.Colors.BrowserBackground);
            g.fillRect(insets.left, insets.top, size.width - insets.left - insets.right, size.height - insets.top - insets.bottom);
        } else {
            RenderedOp op = AffineDescriptor.create((RenderedImage)this.image, (AffineTransform)this.getTransform(), null, null, null);
            g.drawRenderedImage((RenderedImage)op, new AffineTransform());
        }
    }

    void setCachedFile(File file) {
        if (file != null) {
            try {
                String key = ImageTask.getImageKey(file);
                FileCache cache = FileCacheFactory.get(file.getParentFile());
                File cachedFile = cache.getFileFor(key);
                if (cachedFile != null) {
                    this.image = JPEGImageType.getImageFromInputStream(new FileInputStream(cachedFile), null, 320, 320);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.image = null;
            }
        }
        this.repaint();
    }

    void setFile(File file) {
        if (file != null) {
            ImageInfo info = ImageInfo.getInstanceFor(file);
            try {
                this.image = info.getImage(null);
                this.image = BatchImageComponent.systemColorSpaceImage(this.image);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.image = null;
            }
        }
        this.repaint();
    }

    private AffineTransform getTransform() {
        Dimension bound = this.getSize();
        Insets insets = this.getInsets();
        double hSpace = bound.width - insets.left - insets.right;
        double vSpace = bound.height - insets.top - insets.bottom;
        double sWide = hSpace / (double)this.image.getWidth();
        double sTall = vSpace / (double)this.image.getHeight();
        double s = Math.min(sWide, sTall);
        AffineTransform xform = AffineTransform.getScaleInstance(s, s);
        if (sWide < sTall) {
            double gap = (double)insets.top + (vSpace - (double)this.image.getHeight() * s) / 2.0;
            AffineTransform trans = AffineTransform.getTranslateInstance(insets.left, gap);
            xform.preConcatenate(trans);
        } else {
            double gap = (double)insets.left + (hSpace - (double)this.image.getWidth() * s) / 2.0;
            AffineTransform trans = AffineTransform.getTranslateInstance(gap, insets.top);
            xform.preConcatenate(trans);
        }
        return xform;
    }

    private static RenderedImage systemColorSpaceImage(RenderedImage image) {
        ColorModel colors = image.getColorModel();
        ColorSpace space = colors.getColorSpace();
        if (space != null && !space.equals(JAIContext.systemColorSpace)) {
            image = Functions.toColorSpace(image, JAIContext.systemColorSpace, null);
        }
        return new Functions.sRGBWrapper(image);
    }
}

