/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.batch;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.EventQueue;
import javax.swing.JProgressBar;

class BatchProgressBar
extends ProgressThread {
    BatchProgressBar() {
        super(new BatchProgressIndicator());
    }

    JProgressBar getComponent() {
        BatchProgressIndicator indicator = (BatchProgressIndicator)this.getProgressIndicator();
        return indicator.bar;
    }

    void reset() {
        BatchProgressIndicator indicator = (BatchProgressIndicator)this.getProgressIndicator();
        indicator.setIndeterminate(false);
    }

    @Override
    public void run() {
    }

    static class BatchProgressIndicator
    implements ProgressIndicator {
        JProgressBar bar = new JProgressBar();

        BatchProgressIndicator() {
            this.bar.putClientProperty("substancelaf.theme", LightZoneSkin.orangeTheme);
            this.bar.setBorder(null);
        }

        @Override
        public void incrementBy(final int delta) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int value = BatchProgressIndicator.this.bar.getValue();
                    BatchProgressIndicator.this.bar.setValue(value + delta);
                }
            });
        }

        @Override
        public void setIndeterminate(final boolean indeterminate) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (indeterminate) {
                        int max = BatchProgressIndicator.this.bar.getMaximum();
                        BatchProgressIndicator.this.bar.setValue(max);
                    } else {
                        int min = BatchProgressIndicator.this.bar.getMinimum();
                        BatchProgressIndicator.this.bar.setValue(min);
                    }
                    BatchProgressIndicator.this.bar.setIndeterminate(indeterminate);
                }
            });
        }

        @Override
        public void setMaximum(final int maxValue) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatchProgressIndicator.this.bar.setMaximum(maxValue);
                }
            });
        }

        @Override
        public void setMinimum(final int minValue) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BatchProgressIndicator.this.bar.setMinimum(minValue);
                }
            });
        }
    }
}

