/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.PrefsMenuItem;
import com.lightcrafts.app.menu.RedoMenuItem;
import com.lightcrafts.app.menu.UndoMenuItem;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.EditorControls;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.operation.OpStackListener;
import com.lightcrafts.ui.operation.SelectableControl;
import com.lightcrafts.ui.region.CurveIterator;
import com.lightcrafts.ui.region.CurveSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.JMenuItem;

final class EditMenu
extends UpdatableDisposableMenu {
    private CurveSelection.Listener CurveSelectionListener = new CurveSelection.Listener(){

        @Override
        public void selectionChanged(CurveIterator oldSelection, CurveIterator newSelection) {
            EditMenu.this.put("selection", newSelection);
            boolean isSelected = newSelection.hasNext();
            JMenuItem cutItem = (JMenuItem)EditMenu.this.get("cut");
            JMenuItem copyItem = (JMenuItem)EditMenu.this.get("copy");
            cutItem.setEnabled(isSelected);
            copyItem.setEnabled(isSelected);
        }
    };
    private OpStackListener ToolListener = new OpStackListener(){

        @Override
        public void opAdded(OpControl control) {
        }

        @Override
        public void opChanged(OpControl control) {
            EditMenu.this.isRegionToolSelected = !control.isRawCorrection();
            EditMenu.this.updatePasteEnabled();
        }

        @Override
        public void opChanged(SelectableControl control) {
            EditMenu.this.isRegionToolSelected = false;
            EditMenu.this.updatePasteEnabled();
        }

        @Override
        public void opLockChanged(OpControl control) {
        }

        @Override
        public void opRemoved(OpControl control) {
        }
    };
    private boolean isRegionToolSelected;
    private WeakReference<Document> docRef = new WeakReference<Object>(null);

    EditMenu(ComboFrame frame) {
        super(frame, "Edit");
        this.add(new UndoMenuItem(frame));
        this.add(new RedoMenuItem(frame));
        this.addSeparator();
        JMenuItem cutItem = MenuFactory.createMenuItem("Cut");
        JMenuItem copyItem = MenuFactory.createMenuItem("Copy");
        JMenuItem pasteItem = MenuFactory.createMenuItem("Paste");
        JMenuItem pasteRefItem = MenuFactory.createMenuItem("PasteRef");
        cutItem.setEnabled(false);
        copyItem.setEnabled(false);
        pasteItem.setEnabled(false);
        pasteRefItem.setEnabled(false);
        this.put("cut", cutItem);
        this.put("copy", copyItem);
        this.put("paste", pasteItem);
        this.put("pasteRef", pasteRefItem);
        this.add(cutItem);
        this.add(copyItem);
        this.add(pasteItem);
        this.add(pasteRefItem);
        cutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RegionManager regions = (RegionManager)EditMenu.this.get("regions");
                CurveIterator selection = (CurveIterator)EditMenu.this.get("selection");
                regions.unShareShapes(selection);
                EditMenu.this.put("clipboard", selection);
                EditMenu.this.updatePasteEnabled();
            }
        });
        copyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object selection = EditMenu.this.get("selection");
                EditMenu.this.put("clipboard", selection);
                EditMenu.this.updatePasteEnabled();
            }
        });
        pasteItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CurveIterator selection = (CurveIterator)EditMenu.this.get("clipboard");
                RegionManager regions = (RegionManager)EditMenu.this.get("regions");
                regions.shareShapes(selection, true);
            }
        });
        pasteRefItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                CurveIterator selection = (CurveIterator)EditMenu.this.get("clipboard");
                RegionManager regions = (RegionManager)EditMenu.this.get("regions");
                regions.shareShapes(selection, false);
            }
        });
        if (Platform.getType() != Platform.MacOSX) {
            this.addSeparator();
            this.add(new PrefsMenuItem(frame));
        }
    }

    @Override
    void update() {
        Document oldDoc;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame != null ? frame.getDocument() : null;
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            EditorControls controls;
            Editor editor;
            if (oldDoc != null) {
                RegionManager oldRegions = oldDoc.getRegionManager();
                oldRegions.removeSelectionListener(this.CurveSelectionListener);
                this.remove("regions");
                editor = oldDoc.getEditor();
                controls = editor.getToolStack();
                controls.removeOpStackListener(this.ToolListener);
            }
            if (newDoc != null) {
                RegionManager newRegions = newDoc.getRegionManager();
                newRegions.addSelectionListener(this.CurveSelectionListener);
                this.put("regions", newRegions);
                editor = newDoc.getEditor();
                controls = editor.getToolStack();
                controls.addOpStackListener(this.ToolListener);
            } else {
                this.remove("regions");
                this.remove("selection");
                this.remove("clipboard");
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
        super.update();
    }

    private void updatePasteEnabled() {
        Object clipboard = this.get("clipboard");
        boolean canPaste = clipboard != null && this.isRegionToolSelected;
        JMenuItem pasteItem = (JMenuItem)this.get("paste");
        JMenuItem pasteRefItem = (JMenuItem)this.get("pasteRef");
        pasteItem.setEnabled(canPaste);
        pasteRefItem.setEnabled(canPaste);
    }
}

