/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.Application;
import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.CloseDocMenuItem;
import com.lightcrafts.app.menu.ExitMenuItem;
import com.lightcrafts.app.menu.ExportMenuItem;
import com.lightcrafts.app.menu.ManageTemplatesMenuItem;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.NewMenuItem;
import com.lightcrafts.app.menu.OpenMenuItem;
import com.lightcrafts.app.menu.PrintMenuItem;
import com.lightcrafts.app.menu.RevertMenuItem;
import com.lightcrafts.app.menu.SaveAsMenuItem;
import com.lightcrafts.app.menu.SaveMenuItem;
import com.lightcrafts.app.menu.SaveTemplateMenuItem;
import com.lightcrafts.app.menu.SendMenuItem;
import com.lightcrafts.app.menu.ShowInMenuItem;
import com.lightcrafts.app.menu.TemplateMenu;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.EditorMode;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class FileMenu
extends UpdatableDisposableMenu
implements PreferenceChangeListener {
    FileMenu(ComboFrame frame) {
        super(frame, "File");
        this.add(new NewMenuItem(frame));
        this.add(new OpenMenuItem(frame));
        JMenu recentFileMenu = MenuFactory.createMenu("RecentFile");
        this.put("recentFile", recentFileMenu);
        this.add(recentFileMenu);
        JMenu recentFolderMenu = MenuFactory.createMenu("RecentFolder");
        this.put("recentFolder", recentFolderMenu);
        this.add(recentFolderMenu);
        this.addSeparator();
        this.add(new CloseDocMenuItem(frame));
        this.add(new SaveMenuItem(frame));
        this.add(new SaveAsMenuItem(frame));
        this.add(new RevertMenuItem(frame));
        this.addSeparator();
        this.add(new ExportMenuItem(frame));
        this.add(new SendMenuItem(frame));
        this.add(new ShowInMenuItem(frame));
        this.addSeparator();
        this.add(new SaveTemplateMenuItem(frame));
        final TemplateMenu templateMenu = new TemplateMenu(frame);
        this.add(templateMenu);
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                templateMenu.update();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.add(new ManageTemplatesMenuItem(frame));
        this.addSeparator();
        this.add(new PrintMenuItem(frame));
        if (Platform.getType() != Platform.MacOSX) {
            this.addSeparator();
            this.add(new ExitMenuItem(frame));
        }
        Preferences prefs = Application.getPreferences();
        prefs.addPreferenceChangeListener(this);
    }

    private void updateRecentFiles() {
        JMenu recentMenu = (JMenu)this.get("recentFile");
        if (recentMenu == null) {
            return;
        }
        recentMenu.removeAll();
        List<File> recent = Application.getRecentFiles();
        for (final File file : recent) {
            String path = file.getAbsolutePath();
            JMenuItem menuItem = new JMenuItem(path);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboFrame frame = FileMenu.this.getComboFrame();
                    if (frame != null) {
                        Editor editor = frame.getEditor();
                        editor.setMode(EditorMode.ARROW);
                    } else {
                        Application.openEmpty();
                    }
                    Application.open(frame, file);
                }
            });
            recentMenu.add(menuItem);
        }
        if (recent.isEmpty()) {
            JMenuItem emptyItem = MenuFactory.createMenuItem("NoRecentFile");
            emptyItem.setEnabled(false);
            recentMenu.add(emptyItem);
        }
        recentMenu.addSeparator();
        JMenuItem clearItem = MenuFactory.createMenuItem("ClearRecentFile");
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.clearRecentFiles();
            }
        });
        recentMenu.add(clearItem);
    }

    private void updateRecentFolders() {
        JMenu recentMenu = (JMenu)this.get("recentFolder");
        if (recentMenu == null) {
            return;
        }
        recentMenu.removeAll();
        List<File> recent = Application.getRecentFolders();
        for (final File folder : recent) {
            String path = folder.getAbsolutePath();
            JMenuItem menuItem = new JMenuItem(path);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ComboFrame frame = FileMenu.this.getComboFrame();
                    if (frame != null) {
                        Editor editor = frame.getEditor();
                        editor.setMode(EditorMode.ARROW);
                    } else {
                        Application.openEmpty();
                    }
                    Application.openRecentFolder(frame, folder);
                }
            });
            recentMenu.add(menuItem);
        }
        if (recent.isEmpty()) {
            JMenuItem emptyItem = MenuFactory.createMenuItem("NoRecentFolder");
            emptyItem.setEnabled(false);
            recentMenu.add(emptyItem);
        }
        recentMenu.addSeparator();
        JMenuItem clearItem = MenuFactory.createMenuItem("ClearRecentFolder");
        clearItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Application.clearRecentFolders();
            }
        });
        recentMenu.add(clearItem);
    }

    @Override
    void update() {
        super.update();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileMenu.this.updateRecentFiles();
                FileMenu.this.updateRecentFolders();
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        Preferences prefs = Application.getPreferences();
        prefs.removePreferenceChangeListener(this);
    }
}

