/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.ProofMenuItem;
import com.lightcrafts.app.menu.UpdatableDisposableMenu;
import com.lightcrafts.ui.editor.Document;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;

class OperationMenu
extends UpdatableDisposableMenu {
    private WeakReference<Document> docRef = new WeakReference<Object>(null);

    OperationMenu(ComboFrame frame) {
        super(frame, "Operation");
        ProofMenuItem proofItem = new ProofMenuItem(frame);
        proofItem.setEnabled(false);
        this.add(proofItem);
        this.put("proof", proofItem);
        this.addSeparator();
        JMenuItem emptyItem = MenuFactory.createMenuItem("NoOperation");
        emptyItem.setEnabled(false);
        this.add(emptyItem);
    }

    @Override
    void update() {
        Document oldDoc;
        ComboFrame frame = this.getComboFrame();
        Document newDoc = frame != null ? frame.getDocument() : null;
        if (newDoc != (oldDoc = (Document)this.docRef.get())) {
            this.removeAll();
            JMenuItem proofItem = (JMenuItem)this.get("proof");
            this.add(proofItem);
            this.addSeparator();
            if (newDoc != null) {
                List<Action> opActions = newDoc.getOperations();
                for (Action action : opActions) {
                    JMenuItem addItem = new JMenuItem(action);
                    addItem.setToolTipText(null);
                    addItem.setIcon(null);
                    addItem.setText(addItem.getText());
                    this.add(addItem);
                }
            } else {
                JMenuItem emptyItem = MenuFactory.createMenuItem("NoOperation");
                emptyItem.setEnabled(false);
                this.add(emptyItem);
            }
            this.docRef = new WeakReference<Document>(newDoc);
        }
        super.update();
    }
}

