/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.menu;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.app.menu.MenuFactory;
import com.lightcrafts.app.menu.UpdatableMenuItem;
import com.lightcrafts.ui.editor.Document;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

class UpdatableDisposableMenu
extends JMenu {
    private Map<String, Object> props = new HashMap<String, Object>();
    private WeakReference<ComboFrame> frameRef;

    UpdatableDisposableMenu(ComboFrame frame, String key) {
        this.frameRef = new WeakReference<ComboFrame>(frame);
        MenuFactory.configureMenu(key, this);
        if (frame != null) {
            Document doc = frame.getDocument();
            this.put("document", doc);
        }
    }

    ComboFrame getComboFrame() {
        return (ComboFrame)this.frameRef.get();
    }

    void put(String key, Object value) {
        this.props.put(key, value);
    }

    Object get(String key) {
        return this.props.get(key);
    }

    void remove(String key) {
        this.props.remove(key);
    }

    boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    void update() {
        for (int n = 0; n < this.getItemCount(); ++n) {
            JMenuItem item = this.getItem(n);
            if (item instanceof UpdatableMenuItem) {
                ((UpdatableMenuItem)item).update();
                continue;
            }
            if (!(item instanceof UpdatableDisposableMenu)) continue;
            ((UpdatableDisposableMenu)item).update();
        }
        ComboFrame frame = this.getComboFrame();
        if (frame != null) {
            Document doc = frame.getDocument();
            this.put("document", doc);
        } else {
            this.put("document", null);
        }
    }

    public void dispose() {
        this.props.clear();
        for (int n = 0; n < this.getItemCount(); ++n) {
            JMenuItem item = this.getItem(n);
            if (item == null) continue;
            item.setAction(null);
        }
        this.removeAll();
    }
}

