/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.other;

import com.lightcrafts.app.other.OtherApplication;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.MultipageTIFFImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.SidecarJPEGImageType;
import com.lightcrafts.image.types.SidecarTIFFImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.LightCraftsException;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.file.FileUtil;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LightroomApplication
extends OtherApplication {
    static final LightroomApplication INSTANCE = new LightroomApplication();
    private static final Pattern COPY_PATTERN;
    private static final String[] EDIT_WORDS;

    @Override
    public ImageFileExportOptions createExportOptions(ImageInfo imageInfo, Dimension saveSize) throws IOException, LightCraftsException {
        ImageType t = imageInfo.getImageType();
        ImageFileExportOptions options = t instanceof JPEGImageType ? SidecarJPEGImageType.INSTANCE.newExportOptions() : (t instanceof RawImageType ? SidecarTIFFImageType.INSTANCE.newExportOptions() : MultipageTIFFImageType.INSTANCE.newExportOptions());
        LightroomApplication.initOptions(options, imageInfo, saveSize);
        return options;
    }

    public static File getOriginalFile(File currFile) {
        Matcher m = COPY_PATTERN.matcher(TextUtil.normalize(currFile.getAbsolutePath()));
        if (!m.matches()) {
            return currFile;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(m.group(1));
        String number = m.group(3);
        if (number != null) {
            try {
                int n = -Integer.parseInt(number);
                if (n > 1) {
                    String editWord = m.group(2);
                    sb.append('-');
                    sb.append(editWord);
                    sb.append('-');
                    sb.append(n - 1);
                }
            }
            catch (NumberFormatException n) {
                // empty catch block
            }
        }
        sb.append(".tmp");
        String origFilename = sb.toString();
        String ext = FileUtil.getExtensionOf(currFile);
        boolean isJPEG = "jpg".equalsIgnoreCase(ext) || "jpeg".equalsIgnoreCase(ext);
        origFilename = FileUtil.replaceExtensionOf(origFilename, isJPEG ? "jpg" : "tif");
        File origFile = new File(origFilename);
        if (origFile.exists()) {
            return origFile;
        }
        origFile = new File(origFilename = FileUtil.replaceExtensionOf(origFilename, isJPEG ? "jpeg" : "tiff"));
        if (origFile.exists()) {
            return origFile;
        }
        return currFile;
    }

    @Override
    public void postSave(File imageFile, boolean didSaveDirectly, boolean openPending) {
        if (!openPending) {
            Platform.getPlatform().bringAppToFront("Adobe Lightroom");
        }
    }

    @Override
    public boolean shouldSaveDirectly(ImageInfo imageInfo) {
        File file = imageInfo.getFile();
        String filename = TextUtil.normalize(file.getName());
        if (!COPY_PATTERN.matcher(filename).matches()) {
            return false;
        }
        try {
            ImageType t = imageInfo.getImageType();
            if (t instanceof TIFFImageType) {
                return true;
            }
            File origFile = LightroomApplication.getOriginalFile(file);
            return origFile != null && !origFile.equals(file);
        }
        catch (IOException iOException) {
        }
        catch (LightCraftsException lightCraftsException) {
            // empty catch block
        }
        return false;
    }

    private LightroomApplication() {
        super("Lightroom");
    }

    static {
        EDIT_WORDS = new String[]{"Edit", "Modifie\u0301", "Bearbeiten"};
        COPY_PATTERN = Pattern.compile("^(.*)-(" + TextUtil.join(EDIT_WORDS, "|") + ")(-\\d+)?\\.([jJ][pP][eE]?[gG]|[tT][iI][fF][fF]?)$");
    }
}

