/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.app.other;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.export.ImageFileExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.LightCraftsException;
import java.awt.Dimension;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;

public abstract class OtherApplication {
    private final String m_name;
    private static final String PREFS_PACKAGE = "/com/lightcrafts/app/other";
    private static final String INTEGRATION_ENABLED_KEY = "IntegrationEnabled";
    private static final Preferences m_prefs = Preferences.userRoot().node("/com/lightcrafts/app/other");

    public ImageFileExportOptions createExportOptions(ImageInfo imageInfo, Dimension saveSize) throws IOException, LightCraftsException {
        return null;
    }

    public final String getName() {
        return this.m_name;
    }

    public static boolean isIntegrationEnabled() {
        return m_prefs.getBoolean(INTEGRATION_ENABLED_KEY, true);
    }

    public void postSave(File imageFile, boolean didSaveDirectly, boolean openPending) throws IOException {
    }

    public boolean shouldSaveDirectly(ImageInfo imageInfo) {
        return false;
    }

    protected OtherApplication(String name) {
        this.m_name = name;
    }

    protected static void initOptions(ImageFileExportOptions options, ImageInfo imageInfo, Dimension saveSize) throws IOException, LightCraftsException {
        ImageMetadata metadata = imageInfo.getMetadata();
        ImageType t = imageInfo.getImageType();
        options.setExportFile(imageInfo.getFile());
        try {
            ICC_Profile profile = t.getICCProfile(imageInfo);
            if (profile != null) {
                String profileName = ColorProfileInfo.getNameOf(profile);
                options.colorProfile.setValue(profileName);
            }
        }
        catch (LightCraftsException profile) {
        }
        catch (IOException profile) {
            // empty catch block
        }
        options.originalWidth.setValue(metadata.getImageWidth());
        options.originalHeight.setValue(metadata.getImageHeight());
        options.resizeWidth.setValue(saveSize.width);
        options.resizeHeight.setValue(saveSize.height);
        double resolution = metadata.getResolution();
        int resolutionUnit = metadata.getResolutionUnit();
        if (resolution > 0.0 && resolutionUnit != 1) {
            options.resolution.setValue((int)resolution);
            options.resolutionUnit.setValue(resolutionUnit);
        }
        if (options instanceof TIFFImageType.ExportOptions) {
            TIFFImageType.ExportOptions tiffOptions = (TIFFImageType.ExportOptions)options;
            int bitsPerChannel = metadata.getBitsPerChannel();
            if (bitsPerChannel > 0) {
                tiffOptions.bitsPerChannel.setValue(bitsPerChannel);
            }
        }
    }
}

