/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.color;

import Jama.Matrix;
import com.lightcrafts.image.color.BlackBody;
import com.lightcrafts.jai.JAIContext;
import java.awt.color.ICC_ProfileRGB;

public class ColorScience {
    static final float[][] rgbXYZ;
    static final float[] wtptXYZ;
    static final float whitePointTemperature;
    public static final float Wr;
    public static final float Wg;
    public static final float Wb;
    public static final float[] W;
    static final float[][] Cxy;
    public static final float[][] XYZToRGBMat;
    public static final float[][] RGBToXYZMat;
    static float[][] Bradford;
    static float[][] VonKries;
    static float[][] CAT02;
    static float[][] Sharp;
    static float[][] CMCCAT2000;
    static float[][] XYZScaling;
    private static Matrix RGBtoZYX;
    private static Matrix XYZtoRGB;

    public static float[] XYZ2xy(float[] XYZ2) {
        return new float[]{XYZ2[0] / (XYZ2[0] + XYZ2[1] + XYZ2[2]), XYZ2[1] / (XYZ2[0] + XYZ2[1] + XYZ2[2])};
    }

    public static float[] xy2XYZ(float[] xy) {
        return new float[]{xy[0] / xy[1], 1.0f, (1.0f - xy[0] - xy[1]) / xy[1]};
    }

    public static float[] XYZ2xyY(float[] XYZ2) {
        return new float[]{XYZ2[0] / (XYZ2[0] + XYZ2[1] + XYZ2[2]), XYZ2[1] / (XYZ2[0] + XYZ2[1] + XYZ2[2]), XYZ2[1]};
    }

    public static float[] xyY2XYZ(float[] xyY) {
        return new float[]{xyY[2] * xyY[0] / xyY[1], xyY[2], xyY[2] * (1.0f - xyY[0] - xyY[1]) / xyY[1]};
    }

    static float[] D(float t) {
        return BlackBody.xy(t);
    }

    public static float CCTX(float x) {
        return BlackBody.t(x);
    }

    public static float[][] RGBtoZYX() {
        double[][] mdata = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                mdata[i][j] = rgbXYZ[i][j];
            }
        }
        Matrix XYZRGB = new Matrix(mdata);
        float[][] S = new Matrix(new double[][]{{wtptXYZ[0], wtptXYZ[1], wtptXYZ[2]}}).times(XYZRGB.inverse()).getArrayFloat();
        return new float[][]{{S[0][0] * rgbXYZ[0][0], S[0][0] * rgbXYZ[0][1], S[0][0] * rgbXYZ[0][2]}, {S[0][1] * rgbXYZ[1][0], S[0][1] * rgbXYZ[1][1], S[0][1] * rgbXYZ[1][2]}, {S[0][2] * rgbXYZ[2][0], S[0][2] * rgbXYZ[2][1], S[0][2] * rgbXYZ[2][2]}};
    }

    static float[] mul(float c, float[] v) {
        float[] r = new float[v.length];
        for (int i = 0; i < v.length; ++i) {
            r[i] = c * v[i];
        }
        return r;
    }

    public static float[] W(float T) {
        return ColorScience.W(T, Cxy);
    }

    public static float[] W(float T, float[][] Cxy) {
        float[] DT = ColorScience.D(T);
        float[] R = new float[]{Cxy[0][0], Cxy[0][1], 1.0f - Cxy[0][0] - Cxy[0][1]};
        float[] G = new float[]{Cxy[1][0], Cxy[1][1], 1.0f - Cxy[1][0] - Cxy[1][1]};
        float[] B = new float[]{Cxy[2][0], Cxy[2][1], 1.0f - Cxy[2][0] - Cxy[2][1]};
        float[] W = new float[]{DT[0], DT[1], 1.0f - DT[0] - DT[1]};
        Matrix RGB = ColorScience.vec(R, G, B);
        Matrix WGB = ColorScience.vec(W, G, B);
        Matrix RWB = ColorScience.vec(R, W, B);
        Matrix RGW = ColorScience.vec(R, G, W);
        float rgbDet = (float)RGB.det();
        return new float[]{R[1] * (float)WGB.det() / (W[1] * rgbDet), G[1] * (float)RWB.det() / (W[1] * rgbDet), B[1] * (float)RGW.det() / (W[1] * rgbDet)};
    }

    static Matrix vec(float[] A, float[] B, float[] C) {
        int i;
        Matrix ABC = new Matrix(3, 3);
        for (i = 0; i < 3; ++i) {
            ABC.set(i, 0, A[i]);
        }
        for (i = 0; i < 3; ++i) {
            ABC.set(i, 1, B[i]);
        }
        for (i = 0; i < 3; ++i) {
            ABC.set(i, 2, C[i]);
        }
        return ABC;
    }

    public static double[][] strip(double[][] x) {
        double[][] r = new double[][]{x[0], x[1], x[2]};
        return r;
    }

    static float mixer(float t) {
        return (float)(Math.atan((t - 5000.0f) / 100.0f) / Math.PI + 0.5);
    }

    static float[][] matrix(float t) {
        float[][] matrix = new float[3][3];
        float m = ColorScience.mixer(t);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                matrix[i][j] = XYZScaling[i][j] * (1.0f - m) + Bradford[i][j] * m;
            }
        }
        return matrix;
    }

    public static float[][] chromaticAdaptation(float source, float target) {
        return ColorScience.chromaticAdaptation(source, target, CAMethod.Bradford);
    }

    public static float[][] chromaticAdaptation(float source, float target, CAMethod caMethod) {
        float[][] method;
        switch (caMethod) {
            case Bradford: {
                method = Bradford;
                break;
            }
            case VonKries: {
                method = VonKries;
                break;
            }
            case CAT02: {
                method = CAT02;
                break;
            }
            case Sharp: {
                method = Sharp;
                break;
            }
            case CMCCAT2000: {
                method = CMCCAT2000;
                break;
            }
            case Mixed: {
                method = ColorScience.matrix(target);
                break;
            }
            default: {
                method = XYZScaling;
            }
        }
        Matrix B = new Matrix(method);
        float[] sXYZ = ColorScience.xy2XYZ(ColorScience.D(source));
        sXYZ = new Matrix(new float[][]{{sXYZ[0], sXYZ[1], sXYZ[2]}}).times(B).getArrayFloat()[0];
        float[] tXYZ = ColorScience.xy2XYZ(ColorScience.D(target));
        tXYZ = new Matrix(new float[][]{{tXYZ[0], tXYZ[1], tXYZ[2]}}).times(B).getArrayFloat()[0];
        float[][] diag = new float[][]{{sXYZ[0] / tXYZ[0], 0.0f, 0.0f}, {0.0f, sXYZ[1] / tXYZ[1], 0.0f}, {0.0f, 0.0f, sXYZ[2] / tXYZ[2]}};
        return B.times(new Matrix(diag)).times(B.inverse()).getArrayFloat();
    }

    public static double saturation(double r, double g, double b) {
        double min = Math.min(r, Math.min(g, b));
        double max = Math.max(r, Math.max(g, b));
        return max != 0.0 ? 1.0 - min / max : 0.0;
    }

    public static float[] neutralTemperature(float[] rgb, float refT, CAMethod caMethod) {
        float sat = Float.MAX_VALUE;
        float minT = 0.0f;
        double wbr = 0.0;
        double wbg = 0.0;
        double wbb = 0.0;
        float tint = 0.0f;
        Matrix color = new Matrix(new double[][]{{rgb[0]}, {rgb[1]}, {rgb[2]}});
        int t = 1000;
        while (t < 40000) {
            double b;
            double g;
            Matrix B = new Matrix(ColorScience.chromaticAdaptation(t, refT, caMethod));
            Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
            Matrix adapdedColor = combo.times(color);
            double r = ColorScience.clip(adapdedColor.get(0, 0));
            float tSat = (float)ColorScience.saturation(r, g = ColorScience.clip(adapdedColor.get(1, 0)), b = ColorScience.clip(adapdedColor.get(2, 0)));
            if (tSat < sat) {
                sat = tSat;
                minT = t;
                wbr = r;
                wbg = g;
                wbb = b;
            }
            t = (int)((double)t + 0.001 * (double)t);
        }
        if (wbr != 0.0 || wbg != 0.0 || wbb != 0.0) {
            tint = (float)(-(wbg - (wbr + wbb) / 2.0));
        }
        return new float[]{minT, tint};
    }

    static double clip(double x) {
        return Math.min(Math.max(0.0, x), 1.0);
    }

    public static float findTemperature(float[] rgb, float refT, CAMethod caMethod) {
        float minDiff = Float.MAX_VALUE;
        float minT = 0.0f;
        float[] xyzRef = JAIContext.linearColorSpace.toCIEXYZ(rgb);
        float[] labRef = JAIContext.labColorSpace.fromCIEXYZ(xyzRef);
        Matrix gray = new Matrix(new double[][]{{0.18}, {0.18}, {0.18}});
        int t = 1000;
        while (t < 40000) {
            Matrix B = new Matrix(ColorScience.chromaticAdaptation(t, refT, caMethod));
            Matrix combo = XYZtoRGB.times(B.times(RGBtoZYX));
            gray = combo.times(gray);
            double r = ColorScience.clip(gray.get(0, 0));
            double g = ColorScience.clip(gray.get(1, 0));
            double b = ColorScience.clip(gray.get(2, 0));
            float[] xyzGray = JAIContext.linearColorSpace.toCIEXYZ(new float[]{(float)r, (float)g, (float)b});
            float[] labGray = JAIContext.labColorSpace.fromCIEXYZ(xyzGray);
            float diff = 0.0f;
            for (int i = 1; i < 3; ++i) {
                float di = labGray[i] - labRef[i];
                diff += di * di;
            }
            if ((diff = (float)Math.sqrt(diff)) < minDiff) {
                minDiff = diff;
                minT = t;
            }
            t = (int)((double)t + 0.001 * (double)t);
        }
        return minT;
    }

    public static void main(String[] args) {
        int j;
        int i;
        for (int i2 = 2000; i2 < 25000; i2 += 500) {
            System.out.println("m(" + i2 + ") : " + ColorScience.mixer(i2));
        }
        float[] D65 = ColorScience.D(whitePointTemperature);
        System.out.println("D65: " + D65[0] + ", " + D65[1] + ", " + (1.0f - D65[0] - D65[1]));
        System.out.println("xr: " + Cxy[0][0] + ", yr: " + Cxy[0][1]);
        System.out.println("xg: " + Cxy[1][0] + ", yg: " + Cxy[1][1]);
        System.out.println("xb: " + Cxy[2][0] + ", yb: " + Cxy[2][1]);
        System.out.println("W: " + Wr + ", " + Wg + ", " + Wb);
        System.out.println("RGBToXYZ");
        for (int i3 = 0; i3 < 3; ++i3) {
            for (int j2 = 0; j2 < 3; ++j2) {
                System.out.print(" " + RGBToXYZMat[i3][j2]);
            }
            System.out.println();
        }
        float[][] rgb2xyz = ColorScience.RGBtoZYX();
        System.out.println("rgb2xyz");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                System.out.print(" " + rgb2xyz[i][j]);
            }
            System.out.println();
        }
        System.out.println("XYZToRGB");
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                System.out.print(" " + XYZToRGBMat[i][j]);
            }
            System.out.println();
        }
    }

    static {
        ICC_ProfileParameters pp = new ICC_ProfileParameters((ICC_ProfileRGB)JAIContext.linearProfile);
        rgbXYZ = pp.rgbXYZ;
        wtptXYZ = pp.wtptXYZ;
        Cxy = pp.Cxy;
        whitePointTemperature = pp.whitePointTemperature;
        W = pp.W;
        Wr = pp.W[0];
        Wg = pp.W[1];
        Wb = pp.W[2];
        RGBToXYZMat = pp.RGBToXYZMat;
        XYZToRGBMat = pp.XYZToRGBMat;
        Bradford = new float[][]{{0.8951f, -0.7502f, 0.0389f}, {0.2664f, 1.7135f, -0.0685f}, {-0.1614f, 0.0367f, 1.0296f}};
        VonKries = new float[][]{{0.40024f, -0.2263f, 0.0f}, {0.7076f, 1.16532f, 0.0f}, {-0.08081f, 0.0457f, 0.91822f}};
        CAT02 = new float[][]{{0.7328f, -0.7036f, 0.003f}, {0.4296f, 1.6975f, 0.0136f}, {-0.1624f, 0.0061f, 0.9834f}};
        Sharp = new float[][]{{1.2694f, -0.8364f, 0.0297f}, {-0.0988f, 1.8006f, -0.0315f}, {-0.1706f, 0.0357f, 1.0018f}};
        CMCCAT2000 = new float[][]{{0.7982f, -0.5918f, 8.0E-4f}, {0.3389f, 1.5512f, 0.0239f}, {-0.1371f, 0.0406f, 0.9753f}};
        XYZScaling = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        RGBtoZYX = new Matrix(ColorScience.RGBtoZYX()).transpose();
        XYZtoRGB = RGBtoZYX.inverse();
    }

    public static enum CAMethod {
        Bradford,
        VonKries,
        CAT02,
        Sharp,
        CMCCAT2000,
        XYZScaling,
        Mixed;

    }

    public static class YCC
    extends LinearTransform {
        @Override
        double[][] getTransform() {
            return new double[][]{{Wr, Wg, Wb, 0.0}, {(double)(-Wr / (2.0f - 2.0f * Wb)) + 0.5, (double)(-Wg / (2.0f - 2.0f * Wb)) + 0.5, (double)((1.0f - Wb) / (2.0f - 2.0f * Wb)) + 0.5, 0.0}, {(double)((1.0f - Wr) / (2.0f - 2.0f * Wr)) + 0.5, (double)(-Wg / (2.0f - 2.0f * Wr)) + 0.5, (double)(-Wb / (2.0f - 2.0f * Wr)) + 0.5, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        }
    }

    public static class LLab
    extends LinearTransform {
        @Override
        double[][] getTransform() {
            return new double[][]{{Wr, Wg, Wb, 0.0}, {0.5, -0.5, 0.0, 0.5}, {0.0, 0.5, -0.5, 0.5}, {0.0, 0.0, 0.0, 1.0}};
        }
    }

    public static class YST
    extends LinearTransform {
        @Override
        double[][] getTransform() {
            return new double[][]{{Wr, Wg, Wb, 0.0}, {0.5, -0.25, -0.25, 0.5}, {0.0, 0.5, -0.5, 0.5}, {0.0, 0.0, 0.0, 1.0}};
        }
    }

    public static class XYZ
    extends LinearTransform {
        @Override
        double[][] getTransform() {
            return new double[][]{{Wr, Wg, Wb, 0.0}, {0.5, -0.25, -0.25, 0.5}, {0.0, 0.5, -0.5, 0.5}, {0.0, 0.0, 0.0, 1.0}};
        }
    }

    public static abstract class LinearTransform {
        static double[][] scaleTransform(double[][] t, int dataType) {
            switch (dataType) {
                case 0: {
                    t[1][3] = 127.5;
                    t[2][3] = 127.5;
                    break;
                }
                case 2: {
                    t[1][3] = 16383.5;
                    t[2][3] = 16383.5;
                    break;
                }
                case 1: {
                    t[1][3] = 32767.5;
                    t[2][3] = 32767.5;
                    break;
                }
                case 3: {
                    t[1][3] = 1.0737418235E9;
                    t[2][3] = 1.0737418235E9;
                    break;
                }
                case 4: 
                case 5: {
                    t[1][3] = 0.5;
                    t[2][3] = 0.5;
                }
            }
            return t;
        }

        abstract double[][] getTransform();

        public double[][] fromRGB(int dataType) {
            double[][] t = LinearTransform.scaleTransform(this.getTransform(), dataType);
            return ColorScience.strip(t);
        }

        public double[][] toRGB(int dataType) {
            double[][] t = LinearTransform.scaleTransform(this.getTransform(), dataType);
            return ColorScience.strip(new Matrix(t).inverse().getArray());
        }
    }

    public static class ICC_ProfileParameters {
        public float[][] rgbXYZ = new float[3][3];
        public float[] wtptXYZ;
        public float[][] Cxy;
        public float whitePointTemperature;
        public float[] W;
        public float[][] RGBToXYZMat;
        public float[][] XYZToRGBMat;

        public ICC_ProfileParameters(ICC_ProfileRGB profile) {
            float[][] rgbXYZt = profile.getMatrix();
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    this.rgbXYZ[i][j] = rgbXYZt[j][i];
                }
            }
            this.wtptXYZ = profile.getMediaWhitePoint();
            float Cr = this.rgbXYZ[0][0] + this.rgbXYZ[0][1] + this.rgbXYZ[0][2];
            float Cg = this.rgbXYZ[1][0] + this.rgbXYZ[1][1] + this.rgbXYZ[1][2];
            float Cb = this.rgbXYZ[2][0] + this.rgbXYZ[2][1] + this.rgbXYZ[2][2];
            this.Cxy = new float[][]{{this.rgbXYZ[0][0] / Cr, this.rgbXYZ[0][1] / Cr}, {this.rgbXYZ[1][0] / Cg, this.rgbXYZ[1][1] / Cg}, {this.rgbXYZ[2][0] / Cb, this.rgbXYZ[2][1] / Cb}};
            float[] Zr = new float[]{this.Cxy[0][0], this.Cxy[0][1], 1.0f - this.Cxy[0][0] - this.Cxy[0][1]};
            float[] Zg = new float[]{this.Cxy[1][0], this.Cxy[1][1], 1.0f - this.Cxy[1][0] - this.Cxy[1][1]};
            float[] Zb = new float[]{this.Cxy[2][0], this.Cxy[2][1], 1.0f - this.Cxy[2][0] - this.Cxy[2][1]};
            float[] wtptxy = ColorScience.XYZ2xy(this.wtptXYZ);
            this.whitePointTemperature = ColorScience.CCTX(wtptxy[0]);
            this.W = ColorScience.W(this.whitePointTemperature, this.Cxy);
            this.RGBToXYZMat = new Matrix(new float[][]{ColorScience.mul(this.W[0] / Zr[1], Zr), ColorScience.mul(this.W[1] / Zg[1], Zg), ColorScience.mul(this.W[2] / Zb[1], Zb)}).transpose().getArrayFloat();
            this.XYZToRGBMat = new Matrix(this.RGBToXYZMat).inverse().getArrayFloat();
        }
    }
}

