/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.libs.LCImageDataReceiver;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.EXIFEncoder;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ICC_Profile;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.w3c.dom.Document;

public final class LCJPEGWriter {
    private final int m_exportHeight;
    private final int m_exportWidth;
    private final int m_resolution;
    private final int m_resolutionUnit;
    private long m_nativePtr;

    public LCJPEGWriter(String fileName, int width, int height, int colorsPerPixel, int colorSpace, int quality, int resolution, int resolutionUnit) throws IOException, LCImageLibException {
        this.m_exportWidth = width;
        this.m_exportHeight = height;
        this.m_resolution = resolution;
        this.m_resolutionUnit = resolutionUnit;
        this.openForWriting(fileName, width, height, colorsPerPixel, colorSpace, quality);
    }

    public LCJPEGWriter(LCImageDataReceiver receiver, int bufSize, int width, int height, int colorsPerPixel, int colorSpace, int quality) throws LCImageLibException {
        this.m_exportWidth = width;
        this.m_exportHeight = height;
        this.m_resolution = 300;
        this.m_resolutionUnit = 2;
        this.beginWrite(receiver, bufSize, width, height, colorsPerPixel, colorSpace, quality);
    }

    public native void dispose();

    public static int getColorSpaceFromNumComponents(int numComponents) {
        switch (numComponents) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    public void putImage(RenderedImage image) throws LCImageLibException {
        this.putImage(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putImage(RenderedImage image, ProgressThread thread) throws LCImageLibException {
        try {
            int bands = image.getSampleModel().getNumBands();
            if (bands == 4) {
                this.writeAdobeSegment((byte)0);
            }
            this.writeImage(image, thread);
        }
        finally {
            this.dispose();
        }
    }

    public void putMetadata(ImageMetadata metadata) throws LCImageLibException {
        byte[] iptcSegBuf;
        ImageMetadataDirectory exifDir = (metadata = metadata.prepForExport(JPEGImageType.INSTANCE, this.m_exportWidth, this.m_exportHeight, this.m_resolution, this.m_resolutionUnit, false)).getDirectoryFor(EXIFDirectory.class);
        if (exifDir != null) {
            byte[] exifSegBuf = EXIFEncoder.encode(metadata, true).array();
            this.writeSegment(-31, exifSegBuf);
        }
        Document xmpDoc = metadata.toXMP(false, true, new Class[0]);
        byte[] xmpSegBuf = XMLUtil.encodeDocument(xmpDoc, true);
        this.writeSegment(-31, xmpSegBuf);
        ImageMetadataDirectory iptcDir = metadata.getDirectoryFor(IPTCDirectory.class);
        if (iptcDir != null && (iptcSegBuf = ((IPTCDirectory)iptcDir).encode(true)) != null) {
            this.writeSegment(-19, iptcSegBuf);
        }
    }

    public void setICCProfile(ICC_Profile iccProfile) throws LCImageLibException {
        byte[] iccProfileData = iccProfile.getData();
        int chunkSize = 65519;
        int totalSize = iccProfileData.length + ((iccProfileData.length - 1) / 65519 + 1) * 14;
        int numSegments = (totalSize - 1) / 65533 + 1;
        for (int i = 0; i < numSegments; ++i) {
            int segSize = Math.min(65533, totalSize);
            ByteBuffer buf = ByteBuffer.allocate(segSize);
            ByteBufferUtil.put(buf, "ICC_PROFILE", "ASCII");
            buf.put((byte)0);
            buf.put((byte)(i + 1));
            buf.put((byte)numSegments);
            buf.put(iccProfileData, i * 65519, segSize - 14);
            this.writeSegment(-30, buf.array());
            totalSize -= 65533;
        }
    }

    public synchronized native int writeScanLines(byte[] var1, int var2, int var3, int var4) throws LCImageLibException;

    public native void writeSegment(int var1, byte[] var2) throws LCImageLibException;

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private native void beginWrite(LCImageDataReceiver var1, int var2, int var3, int var4, int var5, int var6, int var7) throws LCImageLibException;

    private void openForWriting(String fileName, int width, int height, int colorsPerPixel, int colorSpace, int quality) throws IOException, LCImageLibException {
        byte[] fileNameUtf8 = (fileName + '\u0000').getBytes("UTF-8");
        this.openForWriting(fileNameUtf8, width, height, colorsPerPixel, colorSpace, quality);
    }

    private native void openForWriting(byte[] var1, int var2, int var3, int var4, int var5, int var6) throws IOException, LCImageLibException;

    private void writeAdobeSegment(byte colorTransformationCode) throws LCImageLibException {
        ByteBuffer buf = ByteBuffer.allocate(12);
        ByteBufferUtil.put(buf, "Adobe", "ASCII");
        buf.putShort((short)100);
        buf.putShort((short)0);
        buf.putShort((short)0);
        buf.put(colorTransformationCode);
        this.writeSegment(-18, buf.array());
    }

    private void writeImage(RenderedImage image, ProgressThread thread) throws LCImageLibException {
        int[] nArray;
        int bands;
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Rectangle stripRect = new Rectangle();
        int stripHeight = 8;
        ProgressIndicator indicator = null;
        if (thread != null) {
            indicator = thread.getProgressIndicator();
        }
        if (indicator != null) {
            indicator.setMaximum(imageHeight);
        }
        if ((bands = image.getSampleModel().getNumBands()) == 1) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else if (bands == 3) {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        } else {
            int[] nArray4 = new int[4];
            nArray4[0] = 0;
            nArray4[1] = 1;
            nArray4[2] = 2;
            nArray = nArray4;
            nArray4[3] = 3;
        }
        WritableRaster rasterBuffer = Raster.createInterleavedRaster(0, imageWidth, stripHeight, bands * imageWidth, bands, nArray, new Point(0, 0));
        for (int y = 0; y < imageHeight; y += stripHeight) {
            if (thread != null && thread.isCanceled()) {
                return;
            }
            stripHeight = Math.min(stripHeight, imageHeight - y);
            stripRect.setBounds(0, y, imageWidth, stripHeight);
            WritableRaster raster = (WritableRaster)rasterBuffer.createTranslatedChild(0, y);
            if (image instanceof PlanarImage) {
                ((PlanarImage)image).getTiles(((PlanarImage)image).getTileIndices(raster.getBounds()));
            }
            image.copyData(raster);
            DataBufferByte db = (DataBufferByte)raster.getDataBuffer();
            ComponentSampleModel csm = (ComponentSampleModel)raster.getSampleModel();
            int[] offsets = csm.getBandOffsets();
            int offset = offsets[0];
            for (int i = 1; i < offsets.length; ++i) {
                offset = Math.min(offset, offsets[i]);
            }
            if (bands == 4) {
                byte[] data = db.getData();
                for (int i = 0; i < data.length; ++i) {
                    data[i] = ~data[i];
                }
            }
            int lineStride = csm.getScanlineStride();
            int written = this.writeScanLines(db.getData(), offset, stripHeight, lineStride);
            if (written != stripHeight) {
                throw new LCImageLibException("something is wrong: " + written + " != " + stripHeight);
            }
            if (indicator == null) continue;
            indicator.incrementBy(stripHeight);
        }
        if (indicator != null) {
            indicator.setIndeterminate(true);
        }
    }

    static {
        System.loadLibrary("LCJPEG");
    }
}

