/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.libs;

import com.lightcrafts.image.libs.LCImageDataReceiver;
import com.lightcrafts.image.libs.LCImageLibException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public final class OutputStreamImageDataReceiver
implements LCImageDataReceiver {
    private WritableByteChannel m_channel;

    public OutputStreamImageDataReceiver(OutputStream stream) {
        this.m_channel = Channels.newChannel(stream);
    }

    public synchronized void dispose() {
        if (this.m_channel != null) {
            WritableByteChannel temp = this.m_channel;
            this.m_channel = null;
            try {
                temp.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public int putImageData(ByteBuffer buf) throws IOException, LCImageLibException {
        buf.rewind();
        return this.m_channel.write(buf);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }
}

