/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataReader;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.RationalMetaValue;
import com.lightcrafts.image.metadata.values.StringMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedRationalMetaValue;
import com.lightcrafts.image.metadata.values.UnsignedShortMetaValue;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.utils.DCRaw;
import com.lightcrafts.utils.LightCraftsException;
import java.io.IOException;
import java.util.Date;

public final class DCRawMetadataReader
extends ImageMetadataReader {
    public DCRawMetadataReader(ImageInfo imageInfo) {
        super(imageInfo, null);
    }

    @Override
    protected void readAllDirectories() throws IOException {
        float shutterSpeed;
        String model;
        String make;
        int iso;
        float focalLength;
        Date captureDateTime;
        RawImageInfo info;
        try {
            info = (RawImageInfo)this.m_imageInfo.getAuxiliaryInfo();
        }
        catch (LightCraftsException e) {
            return;
        }
        DCRaw dcraw = info.getDCRaw();
        ImageMetadata metadata = this.m_imageInfo.getCurrentMetadata();
        EXIFDirectory exifDir = (EXIFDirectory)metadata.getDirectoryFor(EXIFDirectory.class, true);
        float aperture = dcraw.getAperture();
        if (aperture > 0.0f) {
            exifDir.putValue(33437, new UnsignedRationalMetaValue((int)(aperture * 10.0f), 10));
        }
        if ((captureDateTime = dcraw.getCaptureDateTime()) != null) {
            exifDir.putValue(306, new DateMetaValue(captureDateTime));
        }
        if ((focalLength = dcraw.getFocalLength()) > 0.0f) {
            exifDir.putValue(37386, new UnsignedRationalMetaValue((int)(focalLength * 10.0f), 10));
        }
        int width = dcraw.getImageWidth();
        int height = dcraw.getImageHeight();
        if (width > 0 && height > 0) {
            exifDir.putValue(256, new UnsignedShortMetaValue(width));
            exifDir.putValue(257, new UnsignedShortMetaValue(height));
        }
        if ((iso = dcraw.getISO()) > 0) {
            exifDir.putValue(34855, new UnsignedShortMetaValue(iso));
        }
        if ((make = dcraw.getMake()) != null) {
            exifDir.putValue(271, new StringMetaValue(make));
        }
        if ((model = dcraw.getModel()) != null) {
            exifDir.putValue(272, new StringMetaValue(model));
        }
        if ((shutterSpeed = dcraw.getShutterSpeed()) > 0.0f) {
            exifDir.putValue(33434, new RationalMetaValue((int)(shutterSpeed * 10000.0f), 10000));
        }
    }

    @Override
    protected void readHeader() {
    }
}

