/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.IPTCConstants;
import com.lightcrafts.image.metadata.IPTCTagInfo;
import com.lightcrafts.image.metadata.IPTCTags;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetaTags;
import com.lightcrafts.image.metadata.ImageMetaType;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.XMPMetadataReader;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.providers.ArtistProvider;
import com.lightcrafts.image.metadata.providers.CaptionProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.CopyrightProvider;
import com.lightcrafts.image.metadata.providers.ImageMetadataProvider;
import com.lightcrafts.image.metadata.providers.TitleProvider;
import com.lightcrafts.image.metadata.values.DateMetaValue;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import com.lightcrafts.utils.xml.ElementPrefixFilter;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IPTCDirectory
extends ImageMetadataDirectory
implements ArtistProvider,
CaptureDateTimeProvider,
CopyrightProvider,
TitleProvider {
    private static final ResourceBundle m_tagBundle = ResourceBundle.getBundle("com.lightcrafts.image.metadata.IPTCTags");
    private static final Map<Integer, IPTCTagInfo> m_tagsByID = new HashMap<Integer, IPTCTagInfo>();
    private static final Map<String, IPTCTagInfo> m_tagsByName = new HashMap<String, IPTCTagInfo>();

    public byte[] encode(boolean includePhotoshopHeader) {
        ImageMetadataDirectory iptcCopy = this.clone();
        iptcCopy.removeAllEmptyStringValues();
        if (iptcCopy.isEmpty()) {
            return null;
        }
        ByteBuffer buf = ((IPTCDirectory)iptcCopy).encodeImpl(includePhotoshopHeader);
        return buf.array();
    }

    @Override
    public String getArtist() {
        ImageMetaValue value = this.getValue(592);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public Date getCaptureDateTime() {
        ImageMetaValue value = this.getValue(567);
        return value instanceof DateMetaValue ? ((DateMetaValue)value).getDateValue() : null;
    }

    @Override
    public String getCopyright() {
        ImageMetaValue value = this.getValue(628);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public String getName() {
        return "IPTC";
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(Integer id) {
        return m_tagsByID.get(id);
    }

    @Override
    public ImageMetaTagInfo getTagInfoFor(String name) {
        return m_tagsByName.get(name);
    }

    @Override
    public String getTitle() {
        ImageMetaValue value = this.getValue(517);
        return value != null ? value.getStringValue() : null;
    }

    @Override
    public boolean isLegalValue(Integer tagID, String value) {
        if (!super.isLegalValue(tagID, value)) {
            return false;
        }
        if (value == null || value.length() == 0) {
            return true;
        }
        switch (tagID) {
            case 527: {
                int categoryLength = value.length();
                return categoryLength >= 1 && categoryLength <= 3;
            }
            case 612: {
                for (String countryCode : Locale.getISOCountries()) {
                    if (!value.equalsIgnoreCase(countryCode)) continue;
                    return true;
                }
                return false;
            }
            case 316: {
                try {
                    int priority = Integer.parseInt(value);
                    return priority >= 1 && priority <= 9;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 643: {
                for (String langCode : Locale.getISOLanguages()) {
                    if (!value.equalsIgnoreCase(langCode)) continue;
                    return true;
                }
                return false;
            }
            case 587: {
                return value.length() == 1 && "apb".contains(value);
            }
            case 61957: {
                try {
                    Integer.parseInt(value);
                    if (value.length() != 6) {
                        return false;
                    }
                    return this.getTagValuesFor(tagID, false).contains(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 61958: {
                try {
                    Integer.parseInt(value);
                    if (value.length() != 8) {
                        return false;
                    }
                    return this.getTagValuesFor(tagID, false).contains(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case 522: {
                try {
                    int urgency = Integer.parseInt(value);
                    return urgency >= 1 && urgency <= 8;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean parseXMP(ImageMetaTagInfo tagInfo, Element element, ElementPrefixFilter dirPrefixFilter) {
        if (tagInfo.getID() != 61696) {
            return false;
        }
        Node[] children = XMLUtil.getChildrenOf(element, dirPrefixFilter);
        XMPMetadataReader.parseElements(children, dirPrefixFilter, this);
        return true;
    }

    public static boolean tagIsCreatorContactInfo(int tagID) {
        return (tagID & 0xFF00) == 61696;
    }

    public static boolean tagIsIIM(int tagID) {
        return tagID < 2560;
    }

    @Override
    public Collection<Element> toXMP(Document xmpDoc) {
        return this.toXMP(xmpDoc, "http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore");
    }

    @Override
    public String valueToString(ImageMetaValue value) {
        switch (value.getOwningTagID()) {
            case 326: 
            case 542: 
            case 549: 
            case 567: 
            case 574: {
                String s = value.getStringValue();
                if (s.length() != 19 || !s.endsWith("00:00:00")) break;
                return s.substring(0, 11);
            }
            case 336: 
            case 547: 
            case 550: 
            case 572: 
            case 575: {
                String s = value.getStringValue();
                if (s.length() != 11) break;
                return s.substring(0, 2) + ':' + s.substring(2, 4) + ':' + s.substring(4, 6) + ' ' + s.substring(6);
            }
        }
        return super.valueToString(value);
    }

    @Override
    protected int getProviderPriorityFor(Class<? extends ImageMetadataProvider> provider) {
        return provider == ArtistProvider.class || provider == CaptionProvider.class || provider == CopyrightProvider.class || provider == TitleProvider.class ? 0x7FFFFFFE : super.getProviderPriorityFor(provider);
    }

    @Override
    protected ResourceBundle getTagLabelBundle() {
        return m_tagBundle;
    }

    @Override
    protected Class<? extends ImageMetaTags> getTagsInterface() {
        return IPTCTags.class;
    }

    @Override
    protected Collection<Element> toXMP(Document xmpDoc, String nsURI, String prefix) {
        int tagID;
        Map.Entry<Integer, ImageMetaValue> me;
        Element rdfDescElement = null;
        Element cciElement = null;
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        while (i.hasNext()) {
            me = i.next();
            tagID = me.getKey();
            if (!IPTCDirectory.tagIsCreatorContactInfo(tagID)) continue;
            rdfDescElement = XMPUtil.createRDFDescription(xmpDoc, nsURI, prefix);
            cciElement = XMLUtil.addElementChildTo(rdfDescElement, nsURI, prefix + ':' + "CreatorContactInfo");
            cciElement.setAttribute("rdf:parseType", "Resource");
            rdfDescElement.appendChild(cciElement);
            break;
        }
        i = this.iterator();
        block4: while (i.hasNext()) {
            Element parent;
            Element valueElement;
            me = i.next();
            tagID = me.getKey();
            ImageMetaValue value = me.getValue();
            switch (tagID) {
                case 516: 
                case 604: 
                case 612: 
                case 61957: 
                case 61958: {
                    break;
                }
                default: {
                    if (!IPTCDirectory.tagIsCreatorContactInfo(tagID)) continue block4;
                }
            }
            if ((valueElement = value.toXMP(xmpDoc, nsURI, prefix)) == null) continue;
            if (IPTCDirectory.tagIsCreatorContactInfo(tagID)) {
                parent = cciElement;
            } else {
                if (rdfDescElement == null) {
                    rdfDescElement = XMPUtil.createRDFDescription(xmpDoc, nsURI, prefix);
                }
                parent = rdfDescElement;
            }
            parent.appendChild(valueElement);
        }
        if (rdfDescElement != null) {
            ArrayList<Element> elements = new ArrayList<Element>(1);
            elements.add(rdfDescElement);
            return elements;
        }
        return null;
    }

    private static void add(int id, String name, ImageMetaType type, boolean isChangeable, int tagAttributes) {
        IPTCTagInfo tagInfo = new IPTCTagInfo(id, name, type, isChangeable, tagAttributes);
        m_tagsByID.put(id, tagInfo);
        m_tagsByName.put(name, tagInfo);
    }

    private int calcEncodedIPTCSize() {
        int size = 0;
        Iterator<Map.Entry<Integer, ImageMetaValue>> i = this.iterator();
        block8: while (i.hasNext()) {
            Map.Entry<Integer, ImageMetaValue> me = i.next();
            ImageMetaValue imValue = me.getValue();
            switch (imValue.getType()) {
                case META_SBYTE: 
                case META_UBYTE: {
                    size += 6;
                    break;
                }
                case META_DATE: {
                    size += 13;
                    break;
                }
                case META_SSHORT: 
                case META_USHORT: {
                    size += 7;
                    break;
                }
                case META_STRING: {
                    for (String s : imValue.getValues()) {
                        try {
                            byte[] b = s.getBytes("UTF-8");
                            size += 5 + b.length;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    continue block8;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return size;
    }

    private ByteBuffer encodeImpl(boolean includePhotoshopHeader) {
        int encodedIPTCSize;
        int bufSize = encodedIPTCSize = this.calcEncodedIPTCSize();
        if (includePhotoshopHeader) {
            bufSize += IPTCConstants.IPTC_JPEG_HEADER_SIZE;
        }
        ByteBuffer buf = ByteBuffer.allocate(bufSize + (bufSize & 1));
        if (includePhotoshopHeader) {
            ByteBufferUtil.put(buf, "Photoshop 3.0", "ASCII");
            buf.put((byte)0);
            ByteBufferUtil.put(buf, "8BIM", "ASCII");
            buf.putShort((short)1028);
            buf.putShort((short)0);
            buf.putInt(encodedIPTCSize);
        }
        Object[] tagIDs = this.getTagIDSet(false).toArray(new Integer[]{null});
        Arrays.sort(tagIDs);
        Object[] arr$ = tagIDs;
        int len$ = arr$.length;
        block6: for (int i$ = 0; i$ < len$; ++i$) {
            int tagID = (Integer)arr$[i$];
            if (!IPTCDirectory.tagIsIIM(tagID)) continue;
            ImageMetaValue imValue = this.getValue(tagID);
            switch (imValue.getType()) {
                case META_SBYTE: 
                case META_UBYTE: {
                    IPTCDirectory.encodeTag(buf, tagID);
                    buf.putShort((short)1);
                    buf.put(imValue.getStringValue().getBytes()[0]);
                    continue block6;
                }
                case META_DATE: {
                    IPTCDirectory.encodeTag(buf, tagID);
                    String date = imValue.getStringValue();
                    date = date.substring(0, 4) + date.substring(5, 7) + date.substring(8, 10);
                    IPTCDirectory.encodeString(buf, date);
                    continue block6;
                }
                case META_SSHORT: 
                case META_USHORT: {
                    IPTCDirectory.encodeTag(buf, tagID);
                    buf.putShort((short)2);
                    buf.putShort(imValue.getShortValue());
                    continue block6;
                }
                case META_STRING: {
                    for (String s : imValue.getValues()) {
                        IPTCDirectory.encodeTag(buf, tagID);
                        IPTCDirectory.encodeString(buf, s);
                    }
                    continue block6;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        if ((bufSize & 1) != 0) {
            buf.put((byte)0);
        }
        return buf;
    }

    private static void encodeString(ByteBuffer buf, String s) {
        try {
            byte[] b = s.getBytes("UTF-8");
            buf.putShort((short)b.length);
            buf.put(b);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void encodeTag(ByteBuffer buf, int tagID) {
        buf.put((byte)28);
        buf.putShort((short)tagID);
    }

    private ImageMetaValue mergeDateTime(ImageMetaValue date, int timeTagID) {
        ImageMetaValue timeValue = this.getValue(timeTagID);
        if (timeValue == null) {
            return date;
        }
        String timeString = timeValue.getStringValue();
        if (timeString.length() != 11) {
            return date;
        }
        try {
            int hh = Integer.parseInt(timeString.substring(0, 2));
            int mm = Integer.parseInt(timeString.substring(2, 4));
            int ss = Integer.parseInt(timeString.substring(4, 6));
            int zh = Integer.parseInt(timeString.substring(7, 9));
            int zm = Integer.parseInt(timeString.substring(9, 11));
            switch (timeString.charAt(6)) {
                case '+': {
                    zh = -zh;
                    zm = -zm;
                    break;
                }
                case '-': {
                    break;
                }
                default: {
                    return date;
                }
            }
            int delta = ((hh + zh) * 60 * 60 + (mm + zm) * 60 + ss) * 1000;
            DateMetaValue newDateValue = (DateMetaValue)date.clone();
            Date newDate = newDateValue.getDateValue();
            newDate.setTime(newDate.getTime() + (long)delta);
            return newDateValue;
        }
        catch (NumberFormatException e) {
            return date;
        }
    }

    private static void xmp(int id, String name) {
        IPTCTagInfo iimTagInfo = m_tagsByID.get(id);
        IPTCTagInfo xmpTagInfo = new IPTCTagInfo(id, name, iimTagInfo.getType(), iimTagInfo.isChangeable(), iimTagInfo.getAttributes());
        m_tagsByID.put(id, xmpTagInfo);
        m_tagsByName.put(name, iimTagInfo);
    }

    static {
        IPTCDirectory.add(592, "ByLine", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(597, "ByLineTitle", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(632, "Caption/Abstract", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(527, "Category", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(602, "City", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(346, "CodedCharacterSet", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(630, "Contact", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(538, "ContentLocationCode", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(539, "ContentLocationName", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(628, "CopyrightNotice", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(612, "CountryPrimaryLocationCode", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(613, "CountryPrimaryLocationName", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(622, "Credit", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(567, "DateCreated", ImageMetaType.META_DATE, true, 0);
        IPTCDirectory.add(326, "DateSent", ImageMetaType.META_DATE, true, 0);
        IPTCDirectory.add(261, "Destination", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(574, "DigitalCreationDate", ImageMetaType.META_DATE, true, 0);
        IPTCDirectory.add(575, "DigitalCreationTime", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(519, "EditStatus", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(296, "EnvelopeNumber", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(316, "EnvelopePriority", ImageMetaType.META_UBYTE, true, 0);
        IPTCDirectory.add(549, "ExpirationDate", ImageMetaType.META_DATE, true, 0);
        IPTCDirectory.add(550, "ExpirationTime", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(534, "FixtureIdentifier", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(617, "Headline", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(537, "Keywords", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(643, "LanguageIdentifier", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(516, "ObjectAttributeReference", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(587, "ObjectCycle", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(517, "ObjectName", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(615, "OriginalTransmissionReference", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(577, "OriginatingProgram", ImageMetaType.META_STRING, false, 0);
        IPTCDirectory.add(306, "ProgramID", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(578, "ProgramVersion", ImageMetaType.META_STRING, false, 0);
        IPTCDirectory.add(607, "Province-State", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(512, "RecordVersion", ImageMetaType.META_USHORT, false, 0);
        IPTCDirectory.add(542, "ReleaseDate", ImageMetaType.META_DATE, true, 0);
        IPTCDirectory.add(547, "ReleaseTime", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(286, "ServiceIdentifier", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(627, "Source", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(552, "SpecialInstructions", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(604, "Sublocation", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(532, "SupplementalCategories", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(572, "TimeCreated", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(336, "TimeSent", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(356, "UNO", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(522, "Urgency", ImageMetaType.META_UBYTE, true, 0);
        IPTCDirectory.add(634, "Writer/Editor", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(61697, "CiAdrExtadr", ImageMetaType.META_STRING, true, 1);
        IPTCDirectory.add(61698, "CiAdrCity", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61699, "CiAdrCtry", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61700, "CiEmailWork", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61701, "CiTelWork", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61702, "CiAdrPcode", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61703, "CiAdrRegion", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61704, "CiUrlWork", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(612, "CountryCode", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61696, "CreatorContactInfo", ImageMetaType.META_UNKNOWN, false, 0);
        IPTCDirectory.add(516, "IntellectualGenre", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(604, "Location", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61956, "RightsUsageTerms", ImageMetaType.META_STRING, true, 0);
        IPTCDirectory.add(61957, "Scene", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.add(61958, "SubjectCode", ImageMetaType.META_STRING, true, 2);
        IPTCDirectory.xmp(613, "Country");
        IPTCDirectory.xmp(612, "CountryCode");
        IPTCDirectory.xmp(592, "Creator");
        IPTCDirectory.xmp(597, "CreatorJobtitle");
        IPTCDirectory.xmp(632, "Description");
        IPTCDirectory.xmp(634, "DescriptionWriter");
        IPTCDirectory.xmp(552, "Instructions");
        IPTCDirectory.xmp(516, "IntellectualGenre");
        IPTCDirectory.xmp(615, "JobID");
        IPTCDirectory.xmp(604, "Location");
        IPTCDirectory.xmp(622, "Provider");
        IPTCDirectory.xmp(517, "Title");
        IPTCDirectory.xmp(628, "rights");
        IPTCDirectory.xmp(592, "creator");
        IPTCDirectory.xmp(632, "description");
        IPTCDirectory.xmp(517, "title");
    }
}

