/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.Rational;
import com.lightcrafts.utils.TextUtil;

public final class MetadataUtil {
    public static final double HALF_LOG_2 = Math.log(2.0) / 2.0;
    public static final double LN_2 = Math.log(2.0);
    private static final float[] FSTOPS = new float[]{0.0f, 1.0f, 1.1f, 1.2f, 1.3f, 1.4f, 1.6f, 1.8f, 2.0f, 2.2f, 2.5f, 2.8f, 3.2f, 3.5f, 3.6f, 4.0f, 4.5f, 5.0f, 5.7f, 6.3f, 7.1f, 8.0f, 9.0f, 10.1f, 11.0f, 12.7f, 14.3f, 16.0f, 18.0f, 20.2f, 22.0f, 25.4f, 28.5f, 32.0f, 45.0f, 64.0f, 90.0f, 125.0f, 180.0f};
    private static final float[] SHUTTER_SPEED = new float[]{0.0f, 1.0f, 2.0f, 2.5f, 3.2f, 4.0f, 5.0f, 6.4f, 8.0f, 10.0f, 12.0f, 15.0f, 20.0f, 25.0f, 30.0f, 40.0f, 50.0f, 60.0f, 80.0f, 100.0f, 125.0f, 160.0f, 200.0f, 250.0f, 320.0f, 400.0f, 500.0f, 640.0f, 800.0f, 1000.0f, 1250.0f, 1600.0f, 2000.0f};

    public static double convertAPEXToEV(int apex) {
        double dFrac;
        int sign;
        if (apex < 0) {
            apex = -apex;
            sign = -1;
        } else {
            sign = 1;
        }
        int frac = apex & 0x1F;
        apex = (int)((long)apex & 0xFFFFFFFFFFFFFFE0L);
        switch (frac) {
            case 12: {
                dFrac = 10.666666666666666;
                break;
            }
            case 20: {
                dFrac = 21.333333333333332;
                break;
            }
            default: {
                dFrac = frac;
            }
        }
        return (double)sign * ((double)apex + dFrac) / 32.0;
    }

    public static String convertBiasFromAPEX(double apex) {
        if (apex == 0.0) {
            return "0";
        }
        if ((double)((int)(apex *= 1.00001)) / apex > 0.999) {
            return "+" + (int)apex;
        }
        if ((double)((int)(apex * 2.0)) / (apex * 2.0) > 0.999) {
            return 43 + (int)(apex * 2.0) + "/2";
        }
        if ((double)((int)(apex * 3.0)) / (apex * 3.0) > 0.999) {
            return 43 + (int)(apex * 3.0) + "/3";
        }
        return TextUtil.tenths(apex);
    }

    public static double convertFStopFromAPEX(int apex) {
        double n = Math.exp(MetadataUtil.convertAPEXToEV(apex) * HALF_LOG_2);
        return MetadataUtil.fixFStop(n);
    }

    public static int convertISOFromAPEX(int apex) {
        double n = Math.exp(MetadataUtil.convertAPEXToEV(apex) * LN_2) * 100.0 / 32.0;
        return (int)(n + 0.5);
    }

    public static Rational convertShutterSpeedFromAPEX(int apex) {
        double n = Math.exp(-MetadataUtil.convertAPEXToEV(apex) * LN_2);
        return n > 0.0 && n < 1.0 ? new Rational(1, (int)MetadataUtil.fixShutterSpeed(1.0 / n)) : new Rational((int)(n * 10.0), 10);
    }

    public static int convertEVToAPEX(float ev) {
        int sign;
        if (ev < 0.0f) {
            ev = -ev;
            sign = -1;
        } else {
            sign = 1;
        }
        int val = (int)ev;
        double frac = ev - (float)val;
        frac = Math.abs(frac - 0.33) < 0.05 ? 12.0 : (Math.abs(frac - 0.67) < 0.05 ? 20.0 : (double)((int)(frac * 32.0 + 0.5)));
        return (int)((double)sign * ((double)(val * 32) + frac));
    }

    public static float fixFStop(double fStop) {
        return MetadataUtil.fixValue(fStop, FSTOPS);
    }

    public static float fixShutterSpeed(double speed) {
        return MetadataUtil.fixValue(speed, SHUTTER_SPEED);
    }

    public static boolean isFullSizedImage(ImageMetadataDirectory dir) {
        ImageMetaValue value = dir.getValue(254);
        if (value != null && value.getIntValue() == 0) {
            return true;
        }
        value = dir.getValue(255);
        return value != null && value.getIntValue() == 1;
    }

    public static int maxTagValue(ImageMetadataDirectory dir, int tagID1, int tagID2) {
        ImageMetaValue v1 = dir.getValue(tagID1);
        ImageMetaValue v2 = dir.getValue(tagID2);
        if (v1 == null) {
            return v2 != null ? v2.getIntValue() : 0;
        }
        if (v2 == null) {
            return v1.getIntValue();
        }
        return Math.max(v1.getIntValue(), v2.getIntValue());
    }

    public static void removePreviewMetadataFrom(ImageMetadata metadata) {
        ImageMetadataDirectory tiffDir;
        ImageMetadataDirectory exifDir = metadata.getDirectoryFor(EXIFDirectory.class);
        if (exifDir != null) {
            exifDir.removeValue(258);
            exifDir.removeValue(37122);
            exifDir.removeValue(259);
            exifDir.removeValue(254);
            exifDir.removeValue(40962);
            exifDir.removeValue(40963);
            exifDir.removeValue(296);
            exifDir.removeValue(278);
            exifDir.removeValue(277);
            exifDir.removeValue(255);
            exifDir.removeValue(282);
            exifDir.removeValue(283);
        }
        if ((tiffDir = metadata.getDirectoryFor(TIFFDirectory.class)) != null) {
            tiffDir.removeValue(258);
            tiffDir.removeValue(259);
            tiffDir.removeValue(254);
            tiffDir.removeValue(262);
            tiffDir.removeValue(284);
            tiffDir.removeValue(296);
            tiffDir.removeValue(278);
            tiffDir.removeValue(277);
            tiffDir.removeValue(255);
            tiffDir.removeValue(282);
            tiffDir.removeValue(283);
        }
    }

    public static void removeWidthHeightFrom(ImageMetadata metadata) {
        ImageMetadataDirectory tiffDir;
        ImageMetadataDirectory exifDir = metadata.getDirectoryFor(EXIFDirectory.class);
        if (exifDir != null) {
            exifDir.removeValue(256);
            exifDir.removeValue(257);
            exifDir.removeValue(40962);
            exifDir.removeValue(40963);
        }
        if ((tiffDir = metadata.getDirectoryFor(TIFFDirectory.class)) != null) {
            tiffDir.removeValue(256);
            tiffDir.removeValue(257);
        }
    }

    public static String shutterSpeedString(double speed) {
        if (speed < 1.0) {
            return "1/" + (int)MetadataUtil.fixShutterSpeed(1.0 / speed);
        }
        return TextUtil.tenths(speed);
    }

    public static String undupMakeModel(String make, String model) {
        make = make.trim();
        model = model.trim();
        String MAKE = make.toUpperCase();
        String MODEL = model.toUpperCase();
        if (MODEL.contains(MAKE)) {
            return model;
        }
        int spacePos = MODEL.indexOf(32);
        if (spacePos > 1 && MAKE.contains(MODEL.substring(0, spacePos))) {
            return model;
        }
        return make + ' ' + model;
    }

    private static float fixValue(double value, float[] table) {
        value = (double)((int)(value * 10.0 + 0.5)) / 10.0;
        int min = 0;
        int max = table.length - 1;
        while (min < max) {
            int i = (min + max) / 2;
            double valueAtI = table[i];
            if (value == valueAtI) {
                return (float)value;
            }
            if (value < valueAtI) {
                max = i - 1;
                continue;
            }
            min = i + 1;
        }
        double smallestDeltaSoFar = 9999.0;
        int bestI = 0;
        for (int i = max - 1; i <= min + 1; ++i) {
            double delta;
            if (i < 0 || i >= table.length || !((delta = Math.abs((double)table[i] - value)) < smallestDeltaSoFar)) continue;
            smallestDeltaSoFar = delta;
            bestI = i;
        }
        return table[bestI];
    }
}

