/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata;

import com.lightcrafts.image.metadata.CoreDirectory;
import com.lightcrafts.image.metadata.EXIFDirectory;
import com.lightcrafts.image.metadata.IPTCDirectory;
import com.lightcrafts.image.metadata.ImageMetaTagInfo;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageMetadataDirectory;
import com.lightcrafts.image.metadata.TIFFDirectory;
import com.lightcrafts.image.metadata.XMPMetadataWriter;
import com.lightcrafts.image.metadata.XMPUtil;
import com.lightcrafts.image.metadata.values.ImageMetaValue;
import com.lightcrafts.utils.xml.ElementFilter;
import com.lightcrafts.utils.xml.ElementPrefixFilter;
import com.lightcrafts.utils.xml.OrXMLFilter;
import com.lightcrafts.utils.xml.XMLFilter;
import com.lightcrafts.utils.xml.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMPMetadataReader {
    private static final XMLFilter m_rdfListElementFilter = new OrXMLFilter(new ElementFilter("rdf:Alt"), new ElementFilter("rdf:Seq"));
    private static final XMLFilter m_rdfListItemElementFilter = new ElementFilter("rdf:li");

    public static ImageMetadata readFrom(Document xmpDoc) {
        Element rdfElement = XMPUtil.getRDFElementOf(xmpDoc);
        if (rdfElement == null) {
            return null;
        }
        ImageMetadata metadata = new ImageMetadata();
        XMPMetadataReader.readMetadata(rdfElement, "http://purl.org/dc/elements/1.1/", "dc", IPTCDirectory.class, metadata);
        XMPMetadataReader.readMetadata(rdfElement, "http://ns.adobe.com/exif/1.0/aux/", "aux", CoreDirectory.class, metadata);
        XMPMetadataReader.readMetadata(rdfElement, "http://ns.adobe.com/exif/1.0/", "exif", EXIFDirectory.class, metadata);
        XMPMetadataReader.readMetadata(rdfElement, "http://iptc.org/std/Iptc4xmpCore/1.0/xmlns/", "Iptc4xmpCore", IPTCDirectory.class, metadata);
        XMPMetadataReader.readMetadata(rdfElement, "http://ns.adobe.com/tiff/1.0/", "tiff", TIFFDirectory.class, metadata);
        XMPMetadataReader.readMetadata(rdfElement, "http://ns.adobe.com/xap/1.0/", "xmp", CoreDirectory.class, metadata);
        return metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageMetadata readFrom(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            ImageMetadata imageMetadata = XMPMetadataReader.readFrom(fis);
            return imageMetadata;
        }
        finally {
            fis.close();
        }
    }

    public static ImageMetadata readFrom(InputStream is) throws IOException {
        return XMPMetadataReader.readFrom(XMLUtil.readDocumentFrom(is));
    }

    static void parseElements(Node[] elements, ElementPrefixFilter dirPrefixFilter, ImageMetadataDirectory dir) {
        block5: for (Node node : elements) {
            Element dirElement = (Element)node;
            String tagName = dirElement.getTagName().replaceAll(".*:", "");
            ImageMetaTagInfo tagInfo = dir.getTagInfoFor(tagName);
            if (tagInfo == null || dir.parseXMP(tagInfo, dirElement, dirPrefixFilter)) continue;
            switch (tagInfo.getType()) {
                case META_UNDEFINED: 
                case META_UNKNOWN: {
                    continue block5;
                }
                default: {
                    ImageMetaValue value = tagInfo.createValue();
                    value.setIsChangeable(true);
                    try {
                        Node child = XMLUtil.getFirstChildOf(dirElement, m_rdfListElementFilter);
                        if (child != null) {
                            value.setValues(XMPMetadataReader.readSeqList((Element)child));
                        } else {
                            Node[] children = XMLUtil.getChildrenOf(dirElement, dirPrefixFilter);
                            if (children != null && children.length > 0) {
                                XMPMetadataReader.parseElements(children, dirPrefixFilter, dir);
                                continue block5;
                            }
                            String text = XMLUtil.getTextOfFirstTextChildOf(dirElement);
                            if (text != null) {
                                value.setValues(text.trim());
                            } else {
                                value.setValues("");
                            }
                        }
                        dir.putValue(tagInfo.getID(), value);
                        continue block5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private XMPMetadataReader() {
    }

    private static void parseAttributes(NamedNodeMap atts, String prefix, ImageMetadataDirectory dir) {
        block5: for (int i = 0; i < atts.getLength(); ++i) {
            ImageMetaTagInfo tagInfo;
            Attr att = (Attr)atts.item(i);
            if (!prefix.equals(att.getPrefix()) || (tagInfo = dir.getTagInfoFor(att.getLocalName())) == null) continue;
            switch (tagInfo.getType()) {
                case META_UNDEFINED: 
                case META_UNKNOWN: {
                    continue block5;
                }
                default: {
                    try {
                        ImageMetaValue value = tagInfo.createValue();
                        value.setIsChangeable(true);
                        value.setValues(att.getValue());
                        dir.putValue(tagInfo.getID(), value);
                        continue block5;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void readMetadata(Element rdfElement, String dirNS, String dirPrefix, Class<? extends ImageMetadataDirectory> dirClass, ImageMetadata metadata) {
        ElementFilter dirFilter = new ElementFilter("rdf:Description", "xmlns:" + dirPrefix, dirNS);
        Element rdfDirElement = (Element)XMLUtil.getFirstChildOf(rdfElement, dirFilter);
        if (rdfDirElement == null) {
            return;
        }
        ElementPrefixFilter dirPrefixFilter = new ElementPrefixFilter(dirPrefix);
        Node[] dirElements = XMLUtil.getChildrenOf(rdfDirElement, dirPrefixFilter);
        ImageMetadataDirectory dir = metadata.getDirectoryFor(dirClass, true);
        XMPMetadataReader.parseElements(dirElements, dirPrefixFilter, dir);
        XMPMetadataReader.parseAttributes(rdfDirElement.getAttributes(), dirPrefix, dir);
        if (dir.isEmpty()) {
            metadata.removeDirectory(dirClass);
        }
    }

    private static String[] readSeqList(Element seqElement) {
        Node[] listElements = XMLUtil.getChildrenOf(seqElement, m_rdfListItemElementFilter);
        if (listElements.length == 0) {
            return null;
        }
        String[] values = new String[listElements.length];
        for (int i = 0; i < listElements.length; ++i) {
            Element listElement = (Element)listElements[i];
            values[i] = XMLUtil.getTextOfFirstTextChildOf(listElement);
        }
        return values;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fis = new FileInputStream(args[0]);
        ImageMetadata md = XMPMetadataReader.readFrom(fis);
        XMPMetadataWriter.mergeInto(md, new File(args[1]));
    }
}

