/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.metadata.makernotes;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.makernotes.CanonMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.FujiMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.KodakMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.MakerNotesDirectory;
import com.lightcrafts.image.metadata.makernotes.MinoltaMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.NikonMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.OlympusMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.PanasonicMakerNoteProbe;
import com.lightcrafts.image.metadata.makernotes.PentaxMakerNoteProbe;
import java.util.ArrayList;

public abstract class MakerNoteProbe {
    private static final ArrayList<MakerNoteProbe> m_makerNoteProbes = new ArrayList();

    public static Class<? extends MakerNotesDirectory> determineMakerNotesFrom(ImageMetadata metadata) {
        for (MakerNoteProbe probe : m_makerNoteProbes) {
            Class<? extends MakerNotesDirectory> dirClass = probe.match(metadata);
            if (dirClass == null) continue;
            return dirClass;
        }
        return null;
    }

    protected MakerNoteProbe() {
        m_makerNoteProbes.add(this);
    }

    protected abstract Class<? extends MakerNotesDirectory> match(ImageMetadata var1);

    protected static Class<? extends MakerNotesDirectory> matchUsingMake(ImageMetadata metadata, String makeWanted, Class<? extends MakerNotesDirectory> dir) {
        String make = metadata.getCameraMake(false);
        if (make != null) {
            return make.contains(makeWanted.toUpperCase()) ? dir : null;
        }
        return null;
    }

    static {
        MakerNoteProbe[] makerNoteProbeArray = new MakerNoteProbe[]{CanonMakerNoteProbe.INSTANCE, FujiMakerNoteProbe.INSTANCE, KodakMakerNoteProbe.INSTANCE, MinoltaMakerNoteProbe.INSTANCE, NikonMakerNoteProbe.INSTANCE, OlympusMakerNoteProbe.INSTANCE, PanasonicMakerNoteProbe.INSTANCE, PentaxMakerNoteProbe.INSTANCE};
    }
}

